/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.PlugableXmlParser;
import org.jboss.galleon.xml.ProvisionedConfigBuilder;
import org.jboss.galleon.xml.ProvisionedFeatureBuilder;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ProvisionedConfigXmlParser30
implements PlugableXmlParser<ProvisionedConfigBuilder> {
    public static final String NAMESPACE_3_0 = "urn:jboss:galleon:provisioned-config:3.0";
    public static final QName ROOT_3_0 = new QName("urn:jboss:galleon:provisioned-config:3.0", Element.CONFIG.getLocalName());

    @Override
    public QName getRoot() {
        return ROOT_3_0;
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, ProvisionedConfigBuilder config) throws XMLStreamException {
        ProvisionedConfigXmlParser30.read(reader, config);
    }

    public static void read(XMLExtendedStreamReader reader, ProvisionedConfigBuilder config) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    config.setName(reader.getAttributeValue(i));
                    continue block13;
                }
                case MODEL: {
                    config.setModel(reader.getAttributeValue(i));
                    continue block13;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        block14: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PROPS: {
                            ProvisionedConfigXmlParser30.readProps(reader, config);
                            continue block14;
                        }
                        case LAYERS: {
                            ProvisionedConfigXmlParser30.readLayers(reader, config);
                            continue block14;
                        }
                        case FEATURE_PACK: {
                            ProvisionedConfigXmlParser30.readFeaturePack(reader, config);
                            continue block14;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readProps(XMLExtendedStreamReader reader, ProvisionedConfigBuilder config) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PROP: {
                            ProvisionedConfigXmlParser30.readProp(reader, config);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readProp(XMLExtendedStreamReader reader, ProvisionedConfigBuilder config) throws XMLStreamException {
        String name = null;
        String value = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (name == null) {
            if (value == null) {
                HashSet<Attribute> attrs = new HashSet<Attribute>();
                attrs.add(Attribute.NAME);
                attrs.add(Attribute.VALUE);
                throw ParsingUtils.missingAttributes(reader.getLocation(), attrs);
            }
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        if (value == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.VALUE));
        }
        config.setProperty(name, value);
        ParsingUtils.parseNoContent(reader);
    }

    private static void readLayers(XMLExtendedStreamReader reader, ProvisionedConfigBuilder config) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case LAYER: {
                            ProvisionedConfigXmlParser30.readLayer(reader, config);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readLayer(XMLExtendedStreamReader reader, ProvisionedConfigBuilder config) throws XMLStreamException {
        String name = null;
        String model = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case MODEL: {
                    model = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        config.addLayer(model, name);
        ParsingUtils.parseNoContent(reader);
    }

    private static void readFeaturePack(XMLExtendedStreamReader reader, ProvisionedConfigBuilder config) throws XMLStreamException {
        FeaturePackLocation location = ProvisionedConfigXmlParser30.parseSource(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case SPEC: {
                            ProvisionedConfigXmlParser30.readSpec(reader, location.getProducer(), config);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static FeaturePackLocation parseSource(XMLExtendedStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        FeaturePackLocation fps = null;
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case LOCATION: {
                    try {
                        fps = FeaturePackLocation.fromString(reader.getAttributeValue(i));
                        continue block5;
                    }
                    catch (IllegalArgumentException e) {
                        throw new XMLStreamException("Failed to parse feature-pack location", e);
                    }
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (fps == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.LOCATION));
        }
        return fps;
    }

    private static void readSpec(XMLExtendedStreamReader reader, FeaturePackLocation.ProducerSpec producer, ProvisionedConfigBuilder config) throws XMLStreamException {
        String name = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        ResolvedSpecId specId = new ResolvedSpecId(producer, name);
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FEATURE: {
                            ProvisionedConfigXmlParser30.readFeature(reader, specId, config);
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readFeature(XMLExtendedStreamReader reader, ResolvedSpecId specId, ProvisionedConfigBuilder config) throws XMLStreamException {
        ProvisionedFeatureBuilder featureBuilder;
        ResolvedFeatureId id = null;
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case ID: {
                    try {
                        id = ResolvedFeatureId.fromString(reader.getAttributeValue(i));
                        continue block14;
                    }
                    catch (ProvisioningDescriptionException e) {
                        throw new XMLStreamException(Errors.parseXml(), e);
                    }
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        ProvisionedFeatureBuilder provisionedFeatureBuilder = featureBuilder = id == null ? ProvisionedFeatureBuilder.builder(specId) : ProvisionedFeatureBuilder.builder(id);
        block15: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    try {
                        config.addFeature(featureBuilder.build());
                    }
                    catch (ProvisioningDescriptionException e) {
                        throw new XMLStreamException("Failed to instantiate provisioned feature", reader.getLocation(), e);
                    }
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PARAM: {
                            ProvisionedConfigXmlParser30.readParam(reader, featureBuilder);
                            continue block15;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readParam(XMLExtendedStreamReader reader, ProvisionedFeatureBuilder featureBuilder) throws XMLStreamException {
        String name = null;
        String value = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (name == null) {
            Set<Attribute> missingAttrs = null;
            if (value == null) {
                missingAttrs = new HashSet<Attribute>(2);
                missingAttrs.add(Attribute.NAME);
                missingAttrs.add(Attribute.VALUE);
            } else {
                missingAttrs = Collections.singleton(Attribute.NAME);
            }
            throw ParsingUtils.missingAttributes(reader.getLocation(), missingAttrs);
        }
        if (value == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.VALUE));
        }
        featureBuilder.setConfigParam(name, value);
        ParsingUtils.parseNoContent(reader);
    }

    static enum Attribute implements XmlNameProvider
    {
        ID("id"),
        LOCATION("location"),
        MODEL("model"),
        NAME("name"),
        VALUE("value"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        public String toString() {
            return this.name;
        }

        static {
            attributes = new HashMap<QName, Attribute>(6);
            attributes.put(new QName(Attribute.ID.name), ID);
            attributes.put(new QName(Attribute.LOCATION.name), LOCATION);
            attributes.put(new QName(Attribute.MODEL.name), MODEL);
            attributes.put(new QName(Attribute.NAME.name), NAME);
            attributes.put(new QName(Attribute.VALUE.name), VALUE);
            attributes.put(null, UNKNOWN);
        }
    }

    static enum Element implements XmlNameProvider
    {
        CONFIG("config"),
        FEATURE("feature"),
        FEATURE_PACK("feature-pack"),
        INSTALLATION("installation"),
        LAYER("layer"),
        LAYERS("layers"),
        PACKAGE("package"),
        PACKAGES("packages"),
        PARAM("param"),
        PROP("prop"),
        PROPS("props"),
        SPEC("spec"),
        UNKNOWN(null);

        private static final Map<String, Element> elements;
        private final String name;
        private final String namespace = "urn:jboss:galleon:provisioned-config:3.0";

        static Element of(QName qName) {
            Element element = elements.get(qName.getLocalPart());
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return ProvisionedConfigXmlParser30.NAMESPACE_3_0;
        }

        public String toString() {
            return this.name;
        }

        static {
            elements = new HashMap<String, Element>(13);
            elements.put(Element.CONFIG.name, CONFIG);
            elements.put(Element.FEATURE.name, FEATURE);
            elements.put(Element.FEATURE_PACK.name, FEATURE_PACK);
            elements.put(Element.LAYER.name, LAYER);
            elements.put(Element.LAYERS.name, LAYERS);
            elements.put(Element.PARAM.name, PARAM);
            elements.put(Element.PROP.name, PROP);
            elements.put(Element.PROPS.name, PROPS);
            elements.put(Element.SPEC.name, SPEC);
            elements.put(null, UNKNOWN);
        }
    }
}

