/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.PriorityQueue;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class RankStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private TupleStream stream;
    private StreamComparator comp;
    private int size;
    private transient PriorityQueue<Tuple> top;
    private transient boolean finished = false;
    private transient LinkedList<Tuple> topList;

    public RankStream(TupleStream tupleStream, int size, StreamComparator comp) throws IOException {
        this.init(tupleStream, size, comp);
    }

    public RankStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        StreamExpressionNamedParameter nParam = factory.getNamedOperand(expression, "n");
        StreamExpressionNamedParameter sortExpression = factory.getNamedOperand(expression, "sort");
        if (expression.getParameters().size() != streamExpressions.size() + 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (null == nParam || null == nParam.getParameter() || !(nParam.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single 'n' parameter of type positive integer but didn't find one", expression));
        }
        String nStr = ((StreamExpressionValue)nParam.getParameter()).getValue();
        int nInt = 0;
        try {
            nInt = Integer.parseInt(nStr);
            if (nInt <= 0) {
                throw new IOException(String.format(Locale.ROOT, "invalid expression %s - topN '%s' must be greater than 0.", expression, nStr));
            }
        }
        catch (NumberFormatException e) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - topN '%s' is not a valid integer.", expression, nStr));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        if (null == sortExpression || !(sortExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'over' parameter listing fields to unique over but didn't find one", expression));
        }
        TupleStream stream = factory.constructStream(streamExpressions.get(0));
        StreamComparator comp = factory.constructComparator(((StreamExpressionValue)sortExpression.getParameter()).getValue(), FieldComparator.class);
        this.init(stream, nInt, comp);
    }

    private void init(TupleStream tupleStream, int size, StreamComparator comp) throws IOException {
        this.stream = tupleStream;
        this.comp = comp;
        this.size = size;
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(new StreamExpressionNamedParameter("n", Integer.toString(this.size)));
        if (includeStreams) {
            if (!(this.stream instanceof Expressible)) throw new IOException("This RankStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(((Expressible)((Object)this.stream)).toExpression(factory));
        } else {
            expression.addParameter("<stream>");
        }
        expression.addParameter(new StreamExpressionNamedParameter("sort", this.comp.toExpression(factory)));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.stream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString()).withHelper(this.comp.toExplanation(factory));
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.stream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.stream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.top = new PriorityQueue<Tuple>(this.size, new ReverseComp(this.comp));
        this.topList = new LinkedList();
        this.stream.open();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    public StreamComparator getComparator() {
        return this.comp;
    }

    @Override
    public Tuple read() throws IOException {
        if (!this.finished) {
            while (true) {
                Tuple tuple = this.stream.read();
                if (tuple.EOF) {
                    this.finished = true;
                    int s = this.top.size();
                    for (int i = 0; i < s; ++i) {
                        Tuple t = this.top.poll();
                        this.topList.addFirst(t);
                    }
                    this.topList.addLast(tuple);
                    break;
                }
                if (this.top.size() >= this.size) {
                    Tuple peek = this.top.peek();
                    if (this.comp.compare(tuple, peek) >= 0) continue;
                    this.top.poll();
                    this.top.add(tuple);
                    continue;
                }
                this.top.add(tuple);
            }
        }
        return this.topList.pollFirst();
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.comp;
    }

    @Override
    public int getCost() {
        return 0;
    }

    static class ReverseComp
    implements Comparator<Tuple>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private StreamComparator comp;

        public ReverseComp(StreamComparator comp) {
            this.comp = comp;
        }

        @Override
        public int compare(Tuple t1, Tuple t2) {
            return this.comp.compare(t1, t2) * -1;
        }
    }
}

