/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;

public class GenericContentChecker
implements ContentChecker {
    private final OCFPackage ocf;
    private final Report report;
    private final String path;

    GenericContentChecker(OCFPackage ocf, Report report, String path) {
        this.ocf = ocf;
        this.report = report;
        this.path = path;
    }

    @Override
    public void runChecks() {
        if (!this.ocf.hasEntry(this.path)) {
            this.report.message(MessageId.RSC_001, EPUBLocation.create(this.ocf.getName()), this.path);
        } else if (!this.ocf.canDecrypt(this.path)) {
            this.report.message(MessageId.RSC_004, EPUBLocation.create(this.ocf.getName()), this.path);
        }
    }
}

