/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.map;

import com.googlecode.d2j.DexLabel;
import com.googlecode.d2j.DexType;
import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.Visibility;
import com.googlecode.d2j.node.DexAnnotationNode;
import com.googlecode.d2j.reader.Op;
import com.googlecode.d2j.util.Mapper;
import com.googlecode.d2j.util.Types;
import com.googlecode.d2j.visitors.DexAnnotationAble;
import com.googlecode.d2j.visitors.DexAnnotationVisitor;
import com.googlecode.d2j.visitors.DexClassVisitor;
import com.googlecode.d2j.visitors.DexCodeVisitor;
import com.googlecode.d2j.visitors.DexDebugVisitor;
import com.googlecode.d2j.visitors.DexFieldVisitor;
import com.googlecode.d2j.visitors.DexFileVisitor;
import com.googlecode.d2j.visitors.DexMethodVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;

public class DexMappingAdapter
extends DexFileVisitor {
    protected Mapper mapper;

    public DexMappingAdapter(Mapper mapper, DexFileVisitor visitor) {
        super(visitor);
        this.mapper = mapper;
    }

    static String mapClassName(Mapper map, String oldDesc) {
        if (oldDesc == null) {
            return null;
        }
        int count = 0;
        while (count < oldDesc.length() && oldDesc.charAt(count) == '[') {
            ++count;
        }
        if (count + 1 == oldDesc.length()) {
            return oldDesc;
        }
        if (count > 0) {
            String n = map.mapClassName(oldDesc.substring(count));
            if (n == null) {
                return oldDesc;
            }
            return String.valueOf(oldDesc.substring(0, count)) + n;
        }
        String n = map.mapClassName(oldDesc);
        if (n == null) {
            return oldDesc;
        }
        return n;
    }

    static String mapAnnotationElementName(Mapper map, String owner, String name) {
        String n = map.mapMethodName(owner, name, null, null);
        if (n == null) {
            return name;
        }
        return n;
    }

    static String[] mapClassNames(Mapper map, String[] oldDescs) {
        if (oldDescs != null && oldDescs.length > 0) {
            String[] copy = new String[oldDescs.length];
            int i = 0;
            while (i < oldDescs.length) {
                copy[i] = DexMappingAdapter.mapClassName(map, oldDescs[i]);
                ++i;
            }
            return copy;
        }
        return oldDescs;
    }

    static String mapFieldName(Mapper map, String owner, String name, String type) {
        String n = map.mapFieldName(owner, name, type);
        if (n == null) {
            return name;
        }
        return n;
    }

    static Field mapField(Mapper map, Field f) {
        String n = map.mapFieldName(f.getOwner(), f.getName(), f.getType());
        if (n == null) {
            n = f.getName();
        }
        return new Field(DexMappingAdapter.mapClassName(map, f.getOwner()), n, DexMappingAdapter.mapClassName(map, f.getType()));
    }

    static Field mapFieldNameAndOwner(Mapper map, Field f) {
        String n = map.mapFieldName(f.getOwner(), f.getName(), f.getType());
        if (n == null) {
            n = f.getName();
        }
        return new Field(DexMappingAdapter.mapFieldOwner(map, f.getOwner(), f.getName(), f.getType()), n, DexMappingAdapter.mapClassName(map, f.getType()));
    }

    private static String mapFieldOwner(Mapper map, String owner, String name, String type) {
        String n = map.mapFieldOwner(owner, name, type);
        if (n == null) {
            return owner;
        }
        return n;
    }

    private static Method mapMethod(Mapper map, Method m) {
        String n = map.mapMethodName(m.getOwner(), m.getName(), m.getParameterTypes(), m.getReturnType());
        if (n == null) {
            n = m.getName();
        }
        return new Method(DexMappingAdapter.mapClassName(map, m.getOwner()), n, DexMappingAdapter.mapClassNames(map, m.getParameterTypes()), DexMappingAdapter.mapClassName(map, m.getReturnType()));
    }

    private static Method mapMethodNameAndOwner(Mapper map, Method m) {
        String owner;
        String n = map.mapMethodName(m.getOwner(), m.getName(), m.getParameterTypes(), m.getReturnType());
        if (n == null) {
            n = m.getName();
        }
        if ((owner = map.mapMethodOwner(m.getOwner(), m.getName(), m.getParameterTypes(), m.getReturnType())) == null) {
            owner = m.getOwner();
        }
        return new Method(owner, n, DexMappingAdapter.mapClassNames(map, m.getParameterTypes()), DexMappingAdapter.mapClassName(map, m.getReturnType()));
    }

    static Object mapObject(Mapper map, Object value) {
        if (value instanceof DexType) {
            value = new DexType(DexMappingAdapter.mapClassName(map, ((DexType)value).desc));
        } else if (value instanceof Field) {
            Field f = (Field)value;
            value = DexMappingAdapter.mapField(map, f);
        } else if (value instanceof Method) {
            Method m = (Method)value;
            value = DexMappingAdapter.mapMethod(map, m);
        }
        return value;
    }

    public DexClassVisitor visit(int access_flags, String className, String superClass, String[] interfaceNames) {
        DexClassVisitor dcv = super.visit(access_flags, DexMappingAdapter.mapClassName(this.mapper, className), DexMappingAdapter.mapClassName(this.mapper, superClass), DexMappingAdapter.mapClassNames(this.mapper, interfaceNames));
        if (dcv != null) {
            return new MappingCV(this.mapper, className, dcv);
        }
        return dcv;
    }

    static Object[] remapSignature(Mapper mapper, Object[] vs, boolean isType) {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = vs;
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            Object v0 = objectArray[n2];
            sb.append(v0);
            ++n2;
        }
        return Types.buildDexStyleSignature((String)DexMappingAdapter.remapSignature(mapper, sb.toString(), isType));
    }

    static String remapSignature(final Mapper mapper, String sig, boolean isType) {
        SignatureWriter w = new SignatureWriter(){
            String clzName;

            public void visitClassType(String name) {
                super.visitClassType(DexMappingAdapter.mapClassName(mapper, name));
                this.clzName = name;
            }

            public void visitInnerClassType(String simpleName) {
                String value = simpleName;
                if (simpleName != null) {
                    if (this.clzName.endsWith("$" + simpleName + ";")) {
                        String internalNameOwner;
                        String nNameDesc = DexMappingAdapter.mapClassName(mapper, this.clzName);
                        String containd = DexMappingAdapter.mapClassName(mapper, String.valueOf(this.clzName.substring(0, this.clzName.length() - 2 - simpleName.length())) + ";");
                        String internalNameWitherOwner = nNameDesc.substring(1, nNameDesc.length() - 1);
                        value = internalNameWitherOwner.startsWith(String.valueOf(internalNameOwner = containd.substring(1, containd.length() - 1)) + "$") ? internalNameWitherOwner.substring(1 + internalNameOwner.length()) : null;
                    } else {
                        value = null;
                    }
                }
                super.visitInnerClassType(value);
            }
        };
        if (isType) {
            new SignatureReader(sig).acceptType((SignatureVisitor)w);
        } else {
            new SignatureReader(sig).accept((SignatureVisitor)w);
        }
        return w.toString();
    }

    public static class MappingAV
    extends DexAnnotationVisitor {
        protected Mapper mapper;
        protected String oldAnnotationClassName;

        public MappingAV(String oldAnnotationClassName, Mapper mapper, DexAnnotationVisitor visitor) {
            super(visitor);
            this.mapper = mapper;
            this.oldAnnotationClassName = oldAnnotationClassName;
        }

        public void visit(String name, Object value) {
            if (name != null && this.oldAnnotationClassName != null) {
                name = DexMappingAdapter.mapAnnotationElementName(this.mapper, this.oldAnnotationClassName, name);
            }
            super.visit(name, DexMappingAdapter.mapObject(this.mapper, value));
        }

        public DexAnnotationVisitor visitAnnotation(String name, String desc) {
            DexAnnotationVisitor dav;
            if (name != null && this.oldAnnotationClassName != null) {
                name = DexMappingAdapter.mapAnnotationElementName(this.mapper, this.oldAnnotationClassName, name);
            }
            if ((dav = super.visitAnnotation(name, DexMappingAdapter.mapClassName(this.mapper, desc))) != null) {
                return new MappingAV(desc, this.mapper, dav);
            }
            return dav;
        }

        public DexAnnotationVisitor visitArray(String name) {
            DexAnnotationVisitor dav;
            if (name != null && this.oldAnnotationClassName != null) {
                name = DexMappingAdapter.mapAnnotationElementName(this.mapper, this.oldAnnotationClassName, name);
            }
            if ((dav = super.visitArray(name)) != null) {
                return new MappingAV(null, this.mapper, dav);
            }
            return dav;
        }

        public void visitEnum(String name, String desc, String value) {
            String fn = DexMappingAdapter.mapFieldName(this.mapper, desc, value, desc);
            if (name != null && this.oldAnnotationClassName != null) {
                name = DexMappingAdapter.mapAnnotationElementName(this.mapper, this.oldAnnotationClassName, name);
            }
            super.visitEnum(name, DexMappingAdapter.mapClassName(this.mapper, desc), fn);
        }
    }

    public static class MappingCV
    extends DexClassVisitor {
        protected String clzName;
        protected Mapper mapper;

        public MappingCV(Mapper mapper, String clzName, DexClassVisitor dcv) {
            super(dcv);
            this.mapper = mapper;
            this.clzName = clzName;
        }

        public DexAnnotationVisitor visitAnnotation(String name, Visibility visibility) {
            DexAnnotationVisitor dav;
            block16: {
                dav = super.visitAnnotation(DexMappingAdapter.mapClassName(this.mapper, name), visibility);
                if (dav == null) break block16;
                switch (name) {
                    case "Ldalvik/annotation/Signature;": {
                        return new DexAnnotationNode(name, visibility){

                            public void visitEnd() {
                                super.visitEnd();
                                DexAnnotationNode.Item p = (DexAnnotationNode.Item)this.items.get(0);
                                Object[] newVs = DexMappingAdapter.remapSignature(MappingCV.this.mapper, (Object[])p.value, false);
                                dav.visit(p.name, (Object)newVs);
                                dav.visitEnd();
                            }
                        };
                    }
                    case "Ldalvik/annotation/InnerClass;": {
                        return new DexAnnotationVisitor(dav){

                            public void visit(String name, Object value) {
                                String simpleName;
                                if (name.equals("name") && (simpleName = (String)value) != null) {
                                    if (MappingCV.this.clzName.endsWith("$" + simpleName + ";")) {
                                        String internalNameOwner;
                                        String nNameDesc = DexMappingAdapter.mapClassName(MappingCV.this.mapper, MappingCV.this.clzName);
                                        String containd = DexMappingAdapter.mapClassName(MappingCV.this.mapper, String.valueOf(MappingCV.this.clzName.substring(0, MappingCV.this.clzName.length() - 2 - simpleName.length())) + ";");
                                        String internalNameWitherOwner = nNameDesc.substring(1, nNameDesc.length() - 1);
                                        value = internalNameWitherOwner.startsWith(String.valueOf(internalNameOwner = containd.substring(1, containd.length() - 1)) + "$") ? internalNameWitherOwner.substring(1 + internalNameOwner.length()) : null;
                                    } else {
                                        value = null;
                                    }
                                }
                                super.visit(name, value);
                            }
                        };
                    }
                    case "Ldalvik/annotation/EnclosingClass;": {
                        return new DexAnnotationVisitor(dav){

                            public void visit(String name, Object value) {
                                if (name.equals("value")) {
                                    super.visit(name, (Object)new DexType(DexMappingAdapter.mapClassName(MappingCV.this.mapper, ((DexType)value).desc)));
                                } else {
                                    super.visit(name, value);
                                }
                            }
                        };
                    }
                    case "Ldalvik/annotation/EnclosingMethod;": {
                        return new DexAnnotationVisitor(dav){

                            public void visit(String name, Object value) {
                                if (name.equals("value")) {
                                    Method m = (Method)value;
                                    super.visit(name, (Object)DexMappingAdapter.mapMethod(MappingCV.this.mapper, m));
                                } else {
                                    super.visit(name, value);
                                }
                            }
                        };
                    }
                }
                return new MappingAV(name, this.mapper, dav);
            }
            return dav;
        }

        public DexFieldVisitor visitField(int accessFlags, Field field, Object value) {
            DexFieldVisitor dfv = super.visitField(accessFlags, DexMappingAdapter.mapField(this.mapper, field), DexMappingAdapter.mapObject(this.mapper, value));
            if (dfv != null) {
                return new MappingFV(this.mapper, dfv);
            }
            return null;
        }

        public DexMethodVisitor visitMethod(int accessFlags, Method method) {
            DexMethodVisitor dmv = super.visitMethod(accessFlags, DexMappingAdapter.mapMethod(this.mapper, method));
            if (dmv != null) {
                return new MappingMV(this.mapper, dmv);
            }
            return dmv;
        }
    }

    public static class MappingCode
    extends DexCodeVisitor {
        protected Mapper mapper;

        public MappingCode(Mapper mapper, DexCodeVisitor dcv) {
            super(dcv);
            this.mapper = mapper;
        }

        public DexDebugVisitor visitDebug() {
            DexDebugVisitor v = super.visitDebug();
            if (v != null) {
                return new DexDebugVisitor(v){

                    public void visitStartLocal(int reg, DexLabel label, String name, String type, String signature) {
                        if (signature != null) {
                            signature = DexMappingAdapter.remapSignature(MappingCode.this.mapper, signature, true);
                        }
                        super.visitStartLocal(reg, label, name, DexMappingAdapter.mapClassName(MappingCode.this.mapper, type), signature);
                    }
                };
            }
            return v;
        }

        public void visitConstStmt(Op op, int ra, Object value) {
            super.visitConstStmt(op, ra, DexMappingAdapter.mapObject(this.mapper, value));
        }

        public void visitFieldStmt(Op op, int a, int b, Field field) {
            super.visitFieldStmt(op, a, b, DexMappingAdapter.mapFieldNameAndOwner(this.mapper, field));
        }

        public void visitFilledNewArrayStmt(Op op, int[] args, String type) {
            super.visitFilledNewArrayStmt(op, args, DexMappingAdapter.mapClassName(this.mapper, type));
        }

        public void visitMethodStmt(Op op, int[] args, Method method) {
            switch (op) {
                case INVOKE_DIRECT: 
                case INVOKE_STATIC: 
                case INVOKE_INTERFACE: 
                case INVOKE_DIRECT_RANGE: 
                case INVOKE_STATIC_RANGE: 
                case INVOKE_INTERFACE_RANGE: {
                    super.visitMethodStmt(op, args, DexMappingAdapter.mapMethodNameAndOwner(this.mapper, method));
                    break;
                }
                default: {
                    super.visitMethodStmt(op, args, DexMappingAdapter.mapMethod(this.mapper, method));
                }
            }
        }

        public void visitTryCatch(DexLabel start, DexLabel end, DexLabel[] handler, String[] type) {
            super.visitTryCatch(start, end, handler, DexMappingAdapter.mapClassNames(this.mapper, type));
        }

        public void visitTypeStmt(Op op, int a, int b, String type) {
            super.visitTypeStmt(op, a, b, DexMappingAdapter.mapClassName(this.mapper, type));
        }
    }

    public static class MappingFV
    extends DexFieldVisitor {
        protected Mapper mapper;

        public MappingFV(Mapper mapper, DexFieldVisitor dfv) {
            super(dfv);
            this.mapper = mapper;
        }

        public DexAnnotationVisitor visitAnnotation(String name, Visibility visibility) {
            final DexAnnotationVisitor dav = super.visitAnnotation(DexMappingAdapter.mapClassName(this.mapper, name), visibility);
            if (dav != null) {
                if ("Ldalvik/annotation/Signature;".equals(name)) {
                    return new DexAnnotationNode(name, visibility){

                        public void visitEnd() {
                            super.visitEnd();
                            DexAnnotationNode.Item p = (DexAnnotationNode.Item)this.items.get(0);
                            Object[] newVs = DexMappingAdapter.remapSignature(MappingFV.this.mapper, (Object[])p.value, true);
                            dav.visit(p.name, (Object)newVs);
                            dav.visitEnd();
                        }
                    };
                }
                return new MappingAV(name, this.mapper, dav);
            }
            return dav;
        }
    }

    public static class MappingMV
    extends DexMethodVisitor {
        protected Mapper mapper;

        public MappingMV(Mapper mapper, DexMethodVisitor dmv) {
            super(dmv);
            this.mapper = mapper;
        }

        public DexAnnotationVisitor visitAnnotation(String name, Visibility visibility) {
            final DexAnnotationVisitor dav = super.visitAnnotation(DexMappingAdapter.mapClassName(this.mapper, name), visibility);
            if (dav != null) {
                if ("Ldalvik/annotation/Signature;".equals(name)) {
                    return new DexAnnotationNode(name, visibility){

                        public void visitEnd() {
                            super.visitEnd();
                            DexAnnotationNode.Item p = (DexAnnotationNode.Item)this.items.get(0);
                            Object[] newVs = DexMappingAdapter.remapSignature(MappingMV.this.mapper, (Object[])p.value, false);
                            dav.visit(p.name, (Object)newVs);
                            dav.visitEnd();
                        }
                    };
                }
                return new MappingAV(name, this.mapper, dav);
            }
            return dav;
        }

        public DexCodeVisitor visitCode() {
            DexCodeVisitor dcv = super.visitCode();
            if (dcv != null) {
                return new MappingCode(this.mapper, dcv);
            }
            return dcv;
        }

        public DexAnnotationAble visitParameterAnnotation(int index) {
            final DexAnnotationAble a = super.visitParameterAnnotation(index);
            if (a != null) {
                return new DexAnnotationAble(){

                    public DexAnnotationVisitor visitAnnotation(String name, Visibility visibility) {
                        DexAnnotationVisitor dav = a.visitAnnotation(DexMappingAdapter.mapClassName(MappingMV.this.mapper, name), visibility);
                        if (dav != null) {
                            return new MappingAV(name, MappingMV.this.mapper, dav);
                        }
                        return dav;
                    }
                };
            }
            return a;
        }
    }
}

