/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssFontVariantNumeric
extends org.w3c.css.properties.css.CssFontVariantNumeric {
    public static final CssIdent normal;
    public static final CssIdent slashedZero;
    public static final CssIdent ordinal;
    public static final CssIdent[] numericFigValues;
    public static final CssIdent[] numericSpaValues;
    public static final CssIdent[] numericFraValues;

    public static final CssIdent getNumericFigValues(CssIdent ident) {
        for (CssIdent id : numericFigValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getNumericSpaValues(CssIdent ident) {
        for (CssIdent id : numericSpaValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getNumericFraValues(CssIdent ident) {
        for (CssIdent id : numericFraValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getAllowedValue(CssIdent ident) {
        if (slashedZero.equals(ident)) {
            return slashedZero;
        }
        if (ordinal.equals(ident)) {
            return ordinal;
        }
        CssIdent id = CssFontVariantNumeric.getNumericFigValues(ident);
        if (id == null && (id = CssFontVariantNumeric.getNumericFraValues(ident)) == null) {
            id = CssFontVariantNumeric.getNumericSpaValues(ident);
        }
        return id;
    }

    public CssFontVariantNumeric() {
        this.value = initial;
    }

    public CssFontVariantNumeric(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 5) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssIdent fraValue = null;
        CssIdent figValue = null;
        CssIdent spaValue = null;
        CssIdent zerValue = null;
        CssIdent ordValue = null;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() == 0) {
                CssIdent ident = (CssIdent)val;
                if (inherit.equals(ident)) {
                    if (expression.getCount() != 1) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    this.value = inherit;
                } else if (normal.equals(ident)) {
                    if (expression.getCount() != 1) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    this.value = normal;
                } else {
                    boolean match = false;
                    if (figValue == null) {
                        figValue = CssFontVariantNumeric.getNumericFigValues(ident);
                        boolean bl = match = figValue != null;
                    }
                    if (!match && fraValue == null) {
                        fraValue = CssFontVariantNumeric.getNumericFraValues(ident);
                        boolean bl = match = fraValue != null;
                    }
                    if (!match && spaValue == null) {
                        spaValue = CssFontVariantNumeric.getNumericSpaValues(ident);
                        boolean bl = match = spaValue != null;
                    }
                    if (!match && zerValue == null && (match = slashedZero.equals(ident))) {
                        zerValue = slashedZero;
                    }
                    if (!match && ordValue == null && (match = ordinal.equals(ident))) {
                        ordValue = ordinal;
                    }
                    if (!match) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                }
            } else {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", new Character(op).toString(), ac);
            }
            expression.next();
        }
        if (expression.getCount() == 1) {
            if (figValue != null) {
                this.value = figValue;
            } else if (fraValue != null) {
                this.value = fraValue;
            } else if (spaValue != null) {
                this.value = spaValue;
            } else if (zerValue != null) {
                this.value = zerValue;
            } else if (ordValue != null) {
                this.value = ordValue;
            }
        } else {
            ArrayList<CssValue> v = new ArrayList<CssValue>();
            if (figValue != null) {
                v.add(figValue);
            }
            if (fraValue != null) {
                v.add(fraValue);
            }
            if (spaValue != null) {
                v.add(spaValue);
            }
            if (zerValue != null) {
                v.add(zerValue);
            }
            if (ordValue != null) {
                v.add(ordValue);
            }
            this.value = new CssValueList(v);
        }
    }

    public CssFontVariantNumeric(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        String[] _numericFigValues = new String[]{"lining-nums", "oldstyle-nums"};
        String[] _numericSpaValues = new String[]{"proportional-nums", "tabular-nums"};
        String[] _numericFraValues = new String[]{"diagonal-fractions", "stacked-fractions"};
        normal = CssIdent.getIdent("normal");
        slashedZero = CssIdent.getIdent("slashed-zero");
        ordinal = CssIdent.getIdent("ordinal");
        numericFigValues = new CssIdent[_numericFigValues.length];
        int i = 0;
        for (String s : _numericFigValues) {
            CssFontVariantNumeric.numericFigValues[i++] = CssIdent.getIdent(s);
        }
        numericSpaValues = new CssIdent[_numericSpaValues.length];
        i = 0;
        for (String s : _numericSpaValues) {
            CssFontVariantNumeric.numericSpaValues[i++] = CssIdent.getIdent(s);
        }
        numericFraValues = new CssIdent[_numericFraValues.length];
        i = 0;
        for (String s : _numericFraValues) {
            CssFontVariantNumeric.numericFraValues[i++] = CssIdent.getIdent(s);
        }
    }
}

