/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.encoding;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import nu.validator.encoding.Decoder;

class ReplacementDecoder
extends Decoder {
    private boolean haveEmitted = false;

    ReplacementDecoder(Charset cs) {
        super(cs, 1.0f, 1.0f);
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        while (in.hasRemaining()) {
            if (this.haveEmitted) {
                in.position(in.limit());
                return CoderResult.UNDERFLOW;
            }
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            in.position(in.limit());
            this.haveEmitted = true;
            if (this.report) {
                return CoderResult.malformedForLength(1);
            }
            out.put('\ufffd');
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected CoderResult implFlush(CharBuffer out) {
        return super.implFlush(out);
    }

    @Override
    protected void implReset() {
        super.implReset();
    }
}

