/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec2(-0.1lf, -1.2lf) * dmat2(1.6lf, 1.53lf, 0.76lf, -1.0lf)) => dvec2(-1.996lf, 1.1239999999999999lf)
 * (dvec2(-0.1lf, -1.2lf) * dmat2(-0.13lf, -1.4lf, -0.87lf, 1.4lf)) => dvec2(1.6929999999999998lf, -1.5929999999999997lf)
 * (dvec2(-0.42lf, 0.48lf) * dmat2(1.6lf, 1.53lf, 0.76lf, -1.0lf)) => dvec2(0.062399999999999976lf, -0.7992lf)
 * (dvec2(-0.42lf, 0.48lf) * dmat2(-0.13lf, -1.4lf, -0.87lf, 1.4lf)) => dvec2(-0.6174lf, 1.0373999999999999lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dvec2(-0.1lf, -1.2lf) * dmat2(1.6lf, 1.53lf, 0.76lf, -1.0lf)), dvec2(-1.996lf, 1.1239999999999999lf)) <= 2.2907186645243016e-05lf ? 1 : -1] array0;
  double[distance((dvec2(-0.1lf, -1.2lf) * dmat2(-0.13lf, -1.4lf, -0.87lf, 1.4lf)), dvec2(1.6929999999999998lf, -1.5929999999999997lf)) <= 2.3246285724820642e-05lf ? 1 : -1] array1;
  double[distance((dvec2(-0.42lf, 0.48lf) * dmat2(1.6lf, 1.53lf, 0.76lf, -1.0lf)), dvec2(0.062399999999999976lf, -0.7992lf)) <= 8.016323346771886e-06lf ? 1 : -1] array2;
  double[distance((dvec2(-0.42lf, 0.48lf) * dmat2(-0.13lf, -1.4lf, -0.87lf, 1.4lf)), dvec2(-0.6174lf, 1.0373999999999999lf)) <= 1.2072205763653963e-05lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
