/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * abs(dvec4(-1.5lf, -0.75lf, 0.0lf, 0.75lf)) => dvec4(1.5lf, 0.75lf, 0.0lf, 0.75lf)
 * abs(dvec4(1.5lf, -1.5lf, -0.75lf, 0.0lf)) => dvec4(1.5lf, 1.5lf, 0.75lf, 0.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(abs(dvec4(-1.5lf, -0.75lf, 0.0lf, 0.75lf)), dvec4(1.5lf, 0.75lf, 0.0lf, 0.75lf)) <= 1.837117307087384e-05lf ? 1 : -1] array0;
  double[distance(abs(dvec4(1.5lf, -1.5lf, -0.75lf, 0.0lf)), dvec4(1.5lf, 1.5lf, 0.75lf, 0.0lf)) <= 2.2500000000000005e-05lf ? 1 : -1] array1;
  gl_Position = vec4(array0.length() + array1.length());
}
