/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.jboss.logging.Logger;

public class DatabaseMetadata {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DatabaseMetaData.class.getName());
    private final Map tables = new HashMap();
    private final Set sequences = new HashSet();
    private final boolean extras;
    private DatabaseMetaData meta;
    private SQLExceptionConverter sqlExceptionConverter;
    private final String[] types;

    @Deprecated
    public DatabaseMetadata(Connection connection, Dialect dialect) throws SQLException {
        this(connection, dialect, null, true);
    }

    @Deprecated
    public DatabaseMetadata(Connection connection, Dialect dialect, boolean extras) throws SQLException {
        this(connection, dialect, null, extras);
    }

    public DatabaseMetadata(Connection connection, Dialect dialect, Configuration config) throws SQLException {
        this(connection, dialect, config, true);
    }

    public DatabaseMetadata(Connection connection, Dialect dialect, Configuration config, boolean extras) throws SQLException {
        this.sqlExceptionConverter = dialect.buildSQLExceptionConverter();
        this.meta = connection.getMetaData();
        this.extras = extras;
        this.initSequences(connection, dialect);
        this.types = config != null && ConfigurationHelper.getBoolean("hibernate.synonyms", config.getProperties(), false) ? new String[]{"TABLE", "VIEW", "SYNONYM"} : new String[]{"TABLE", "VIEW"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TableMetadata getTableMetadata(String name, String schema, String catalog, boolean isQuoted) throws HibernateException {
        Object identifier = this.identifier(catalog, schema, name);
        TableMetadata table = (TableMetadata)this.tables.get(identifier);
        if (table != null) {
            return table;
        }
        try {
            ResultSet rs = null;
            try {
                rs = isQuoted && this.meta.storesMixedCaseQuotedIdentifiers() ? this.meta.getTables(catalog, schema, name, this.types) : (isQuoted && this.meta.storesUpperCaseQuotedIdentifiers() || !isQuoted && this.meta.storesUpperCaseIdentifiers() ? this.meta.getTables(catalog != null ? catalog.toUpperCase(Locale.ROOT) : null, schema != null ? schema.toUpperCase(Locale.ROOT) : null, name.toUpperCase(Locale.ROOT), this.types) : (isQuoted && this.meta.storesLowerCaseQuotedIdentifiers() || !isQuoted && this.meta.storesLowerCaseIdentifiers() ? this.meta.getTables(catalog != null ? catalog.toLowerCase(Locale.ROOT) : null, schema != null ? schema.toLowerCase(Locale.ROOT) : null, name.toLowerCase(Locale.ROOT), this.types) : this.meta.getTables(catalog, schema, name, this.types)));
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    if (!name.equalsIgnoreCase(tableName)) continue;
                    table = new TableMetadata(rs, this.meta, this.extras);
                    this.tables.put(identifier, table);
                    TableMetadata tableMetadata = table;
                    return tableMetadata;
                }
                LOG.tableNotFound(name);
                TableMetadata tableMetadata = null;
                return tableMetadata;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException sqlException) {
            throw new SqlExceptionHelper(this.sqlExceptionConverter).convert(sqlException, "could not get table metadata: " + name);
        }
    }

    private Object identifier(String catalog, String schema, String name) {
        return Table.qualify(catalog, schema, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSequences(Connection connection, Dialect dialect) throws SQLException {
        String sql;
        if (dialect.supportsSequences() && (sql = dialect.getQuerySequencesString()) != null) {
            Statement statement = null;
            ResultSet rs = null;
            try {
                statement = connection.createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    this.sequences.add(rs.getString(1).toLowerCase(Locale.ROOT).trim());
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    public boolean isSequence(Object key) {
        if (key instanceof String) {
            String[] strings = StringHelper.split(".", (String)key);
            return this.sequences.contains(strings[strings.length - 1].toLowerCase(Locale.ROOT));
        }
        return false;
    }

    public boolean isTable(Object key) throws HibernateException {
        if (key instanceof String) {
            Table tbl = new Table((String)key);
            if (this.getTableMetadata(tbl.getName(), tbl.getSchema(), tbl.getCatalog(), tbl.isQuoted()) != null) {
                return true;
            }
            String[] strings = StringHelper.split(".", (String)key);
            if (strings.length == 3) {
                tbl = new Table(strings[2]);
                tbl.setCatalog(strings[0]);
                tbl.setSchema(strings[1]);
                return this.getTableMetadata(tbl.getName(), tbl.getSchema(), tbl.getCatalog(), tbl.isQuoted()) != null;
            }
            if (strings.length == 2) {
                tbl = new Table(strings[1]);
                tbl.setSchema(strings[0]);
                return this.getTableMetadata(tbl.getName(), tbl.getSchema(), tbl.getCatalog(), tbl.isQuoted()) != null;
            }
        }
        return false;
    }

    public String toString() {
        return "DatabaseMetadata" + this.tables.keySet().toString() + this.sequences.toString();
    }
}

