/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy.frames;

import java.util.Arrays;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.frames.SpdyFrame;
import org.glassfish.grizzly.spdy.frames.SpdyHeader;

public class SettingsFrame
extends SpdyFrame {
    private static final ThreadCache.CachedTypeIndex<SettingsFrame> CACHE_IDX = ThreadCache.obtainIndex(SettingsFrame.class, 8);
    private static final String[] OPTION_TEXT = new String[]{"UPLOAD_BANDWIDTH", "DOWNLOAD_BANDWIDTH", "ROUND_TRIP_TIME", "MAX_CONCURRENT_STREAMS", "CURRENT_CWND", "DOWNLOAD_RETRANS_RATE", "INITIAL_WINDOW_SIZE", "CLIENT_CERTIFICATE_VECTOR_SIZE"};
    public static final int TYPE = 4;
    public static final byte FLAG_SETTINGS_CLEAR_SETTINGS = 1;
    public static final int MAX_DEFINED_SETTINGS = 8;
    public static final int SETTINGS_UPLOAD_BANDWIDTH = 0;
    public static final int SETTINGS_DOWNLOAD_BANDWIDTH = 1;
    public static final int SETTINGS_ROUND_TRIP_TIME = 2;
    public static final int SETTINGS_MAX_CONCURRENT_STREAMS = 3;
    public static final int SETTINGS_CURRENT_CWND = 4;
    public static final int SETTINGS_DOWNLOAD_RETRANS_RATE = 5;
    public static final int SETTINGS_INITIAL_WINDOW_SIZE = 6;
    public static final int SETTINGS_CLIENT_CERTIFICATE_VECTOR_SIZE = 7;
    private int numberOfSettings;
    private final int[] settingSlots = new int[8];
    private byte setSettings = 0;

    private SettingsFrame() {
        Arrays.fill(this.settingSlots, -1);
    }

    static SettingsFrame create() {
        SettingsFrame frame = ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new SettingsFrame();
        }
        return frame;
    }

    static SettingsFrame create(SpdyHeader header) {
        SettingsFrame frame = SettingsFrame.create();
        frame.initialize(header);
        return frame;
    }

    public static SettingsFrameBuilder builder() {
        return new SettingsFrameBuilder();
    }

    public int getNumberOfSettings() {
        return this.numberOfSettings;
    }

    public int getSetting(int slotId) {
        return this.settingSlots[slotId];
    }

    public byte getSetSettings() {
        return this.setSettings;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SettingsFrame");
        sb.append("{numberOfSettings=").append(this.numberOfSettings);
        if (this.numberOfSettings > 0) {
            int numberOfSettingsLocal = this.numberOfSettings;
            sb.append(", {");
            for (int i = 0; i < 8 && numberOfSettingsLocal > 0; ++i) {
                if ((this.setSettings & 1 << i) == 0) continue;
                sb.append(' ');
                sb.append(OPTION_TEXT[i]).append('=').append(this.settingSlots[i]);
                --numberOfSettingsLocal;
            }
        }
        sb.append(" }}");
        return sb.toString();
    }

    @Override
    public void recycle() {
        this.numberOfSettings = 0;
        this.setSettings = 0;
        Arrays.fill(this.settingSlots, -1);
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    public Buffer toBuffer(MemoryManager memoryManager) {
        int length = 4 + this.numberOfSettings * 8;
        Object buffer = memoryManager.allocate(8 + length);
        buffer.putInt(-2147287036);
        buffer.putInt(length);
        buffer.putInt(this.numberOfSettings);
        if (this.numberOfSettings > 0) {
            for (int i = 0; i < 8 && this.numberOfSettings > 0; ++i) {
                if ((this.setSettings & 1 << i) == 0) continue;
                buffer.putInt(i + 1);
                buffer.putInt(this.settingSlots[i]);
            }
        }
        buffer.trim();
        return buffer;
    }

    @Override
    protected void initialize(SpdyHeader header) {
        super.initialize(header);
        this.numberOfSettings = header.buffer.getInt();
        if (this.numberOfSettings > 0) {
            Buffer settings = header.buffer;
            int actualNumberOfSettings = 0;
            for (int i = 0; i < this.numberOfSettings; ++i) {
                int eHeader = settings.getInt();
                int eId = (eHeader & 0xFFFFFF) - 1;
                if ((this.setSettings & 1 << eId) != 0) continue;
                this.setSettings = (byte)(this.setSettings | 1 << eId);
                ++actualNumberOfSettings;
                this.settingSlots[eId] = settings.getInt();
            }
            this.numberOfSettings = actualNumberOfSettings;
        }
    }

    public static class SettingsFrameBuilder
    extends SpdyFrame.SpdyFrameBuilder<SettingsFrameBuilder> {
        private final SettingsFrame settingsFrame;

        protected SettingsFrameBuilder() {
            super(SettingsFrame.create());
            this.settingsFrame = (SettingsFrame)this.frame;
        }

        public SettingsFrameBuilder setting(int slotId, int value) {
            if ((this.settingsFrame.setSettings & 1 << slotId) == 0) {
                this.settingsFrame.setSettings = (byte)(this.settingsFrame.setSettings | 1 << slotId);
                ((SettingsFrame)this.settingsFrame).settingSlots[slotId] = value;
                this.settingsFrame.numberOfSettings++;
            }
            return this;
        }

        public SettingsFrame build() {
            return this.settingsFrame;
        }

        @Override
        protected SettingsFrameBuilder getThis() {
            return this;
        }
    }
}

