/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseReason;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.ICloseType;
import org.glassfish.grizzly.OutputSink;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.spdy.Constants;
import org.glassfish.grizzly.spdy.PushResource;
import org.glassfish.grizzly.spdy.SpdySession;
import org.glassfish.grizzly.spdy.SpdyStreamException;
import org.glassfish.grizzly.spdy.StreamInputBuffer;
import org.glassfish.grizzly.spdy.StreamOutputSink;
import org.glassfish.grizzly.utils.DataStructures;
import org.glassfish.grizzly.utils.Futures;

public class SpdyStream
implements AttributeStorage,
OutputSink,
Closeable {
    public static final String SPDY_STREAM_ATTRIBUTE = SpdyStream.class.getName();
    private static final Attribute<SpdyStream> HTTP_RQST_SPDY_STREAM_ATTR = AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("http.request.spdy.stream");
    private final HttpRequestPacket spdyRequest;
    private final int streamId;
    private final int associatedToStreamId;
    private final int priority;
    private final int slot;
    private final boolean isUnidirectional;
    private final SpdySession spdySession;
    private final AttributeHolder attributes = AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER.createSafeAttributeHolder();
    final StreamInputBuffer inputBuffer;
    final StreamOutputSink outputSink;
    final AtomicReference<CloseReason> closeReasonRef = new AtomicReference();
    private final Queue<CloseListener> closeListeners = new ConcurrentLinkedQueue<CloseListener>();
    private volatile GrizzlyFuture<CloseReason> closeFuture;
    private final AtomicInteger completeFinalizationCounter = new AtomicInteger();
    volatile boolean isProcessingComplete;
    private boolean isSynFrameRcv;
    private Map<String, PushResource> associatedResourcesToPush;
    private Set<SpdyStream> associatedSpdyStreams;
    private Buffer cachedInputBuffer;
    private boolean cachedIsLast;

    public static SpdyStream getSpdyStream(HttpHeader httpHeader) {
        HttpRequestPacket request;
        if (httpHeader.isRequest()) {
            assert (httpHeader instanceof HttpRequestPacket);
            request = (HttpRequestPacket)httpHeader;
        } else {
            assert (httpHeader instanceof HttpResponsePacket);
            request = ((HttpResponsePacket)httpHeader).getRequest();
        }
        if (request != null) {
            return HTTP_RQST_SPDY_STREAM_ATTR.get(request);
        }
        return null;
    }

    protected SpdyStream(SpdySession spdySession, HttpRequestPacket spdyRequest, int streamId, int associatedToStreamId, int priority, int slot, boolean isUnidirectional) {
        this.spdySession = spdySession;
        this.spdyRequest = spdyRequest;
        this.streamId = streamId;
        this.associatedToStreamId = associatedToStreamId;
        this.priority = priority;
        this.slot = slot;
        this.isUnidirectional = isUnidirectional;
        this.inputBuffer = new StreamInputBuffer(this);
        this.outputSink = new StreamOutputSink(this);
        HTTP_RQST_SPDY_STREAM_ATTR.set(spdyRequest, this);
    }

    SpdySession getSpdySession() {
        return this.spdySession;
    }

    public int getPeerWindowSize() {
        return this.spdySession.getPeerStreamWindowSize();
    }

    public int getLocalWindowSize() {
        return this.spdySession.getLocalStreamWindowSize();
    }

    public int getUnflushedWritesCount() {
        return this.outputSink.getUnflushedWritesCount();
    }

    public HttpRequestPacket getSpdyRequest() {
        return this.spdyRequest;
    }

    public HttpResponsePacket getSpdyResponse() {
        return this.spdyRequest.getResponse();
    }

    public PushResource addPushResource(String url, PushResource pushResource) {
        if (this.associatedResourcesToPush == null) {
            this.associatedResourcesToPush = new HashMap<String, PushResource>();
        }
        return this.associatedResourcesToPush.put(url, pushResource);
    }

    public PushResource removePushResource(String url) {
        if (this.associatedResourcesToPush == null) {
            return null;
        }
        return this.associatedResourcesToPush.remove(url);
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getAssociatedToStreamId() {
        return this.associatedToStreamId;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isUnidirectional() {
        return this.isUnidirectional;
    }

    public boolean isLocallyInitiatedStream() {
        assert (this.streamId > 0);
        return this.spdySession.isServer() ^ this.streamId % 2 != 0;
    }

    @Override
    public boolean isOpen() {
        return this.completeFinalizationCounter.get() < 2;
    }

    @Override
    public void assertOpen() throws IOException {
        if (!this.isOpen()) {
            CloseReason closeReason = this.closeReasonRef.get();
            assert (closeReason != null);
            throw new IOException("closed", closeReason.getCause());
        }
    }

    @Override
    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    @Override
    @Deprecated
    public boolean canWrite(int length) {
        return this.canWrite();
    }

    @Override
    public boolean canWrite() {
        return this.outputSink.canWrite();
    }

    @Override
    @Deprecated
    public void notifyCanWrite(WriteHandler handler, int length) {
        this.notifyCanWrite(handler);
    }

    @Override
    public void notifyCanWrite(WriteHandler writeHandler) {
        this.outputSink.notifyWritePossible(writeHandler);
    }

    StreamOutputSink getOutputSink() {
        return this.outputSink;
    }

    @Override
    public GrizzlyFuture<Closeable> terminate() {
        FutureImpl<Closeable> future = Futures.createSafeFuture();
        this.close0(Futures.toCompletionHandler(future), CloseType.LOCALLY, null, false);
        return future;
    }

    @Override
    public void terminateSilently() {
        this.close0(null, CloseType.LOCALLY, null, false);
    }

    @Override
    public void terminateWithReason(IOException cause) {
        this.close0(null, CloseType.LOCALLY, cause, false);
    }

    @Override
    public GrizzlyFuture<Closeable> close() {
        FutureImpl<Closeable> future = Futures.createSafeFuture();
        this.close0(Futures.toCompletionHandler(future), CloseType.LOCALLY, null, true);
        return future;
    }

    @Override
    public void closeSilently() {
        this.close0(null, CloseType.LOCALLY, null, true);
    }

    @Override
    public void close(CompletionHandler<Closeable> completionHandler) {
        this.close0(completionHandler, CloseType.LOCALLY, null, true);
    }

    @Override
    public void closeWithReason(IOException cause) {
        this.close0(null, CloseType.LOCALLY, cause, false);
    }

    void close0(CompletionHandler<Closeable> completionHandler, CloseType closeType, IOException cause, boolean isCloseOutputGracefully) {
        if (this.closeReasonRef.get() != null) {
            return;
        }
        if (this.closeReasonRef.compareAndSet(null, new CloseReason(closeType, cause))) {
            Termination termination = closeType == CloseType.LOCALLY ? Constants.LOCAL_CLOSE_TERMINATION : Constants.PEER_CLOSE_TERMINATION;
            this.inputBuffer.terminate(termination);
            if (isCloseOutputGracefully) {
                this.outputSink.close();
            } else {
                this.outputSink.terminate(termination);
            }
            this.notifyCloseListeners();
            if (completionHandler != null) {
                completionHandler.completed(this);
            }
        }
    }

    void closedRemotely() {
        this.inputBuffer.close(new Termination(TerminationType.PEER_CLOSE, "Closed by peer"){

            @Override
            public void doTask() {
                SpdyStream.this.close0(null, CloseType.REMOTELY, null, false);
            }
        });
    }

    void resetRemotely() {
        if (this.closeReasonRef.compareAndSet(null, new CloseReason(CloseType.REMOTELY, null))) {
            this.inputBuffer.close(Constants.RESET_TERMINATION);
            this.outputSink.terminate(Constants.RESET_TERMINATION);
        }
        this.rstAssociatedStreams();
    }

    void onProcessingComplete() {
        this.isProcessingComplete = true;
        if (this.closeReasonRef.compareAndSet(null, new CloseReason(CloseType.LOCALLY, null))) {
            Termination termination = Constants.LOCAL_CLOSE_TERMINATION;
            this.inputBuffer.terminate(termination);
            this.outputSink.close();
            this.notifyCloseListeners();
        }
    }

    @Override
    public void addCloseListener(CloseListener closeListener) {
        CloseReason closeReason = this.closeReasonRef.get();
        if (closeReason == null) {
            this.closeListeners.add(closeListener);
            closeReason = this.closeReasonRef.get();
            if (closeReason != null && this.closeListeners.remove(closeListener)) {
                try {
                    closeListener.onClosed(this, closeReason.getType());
                }
                catch (IOException ignored) {}
            }
        } else {
            try {
                closeListener.onClosed(this, closeReason.getType());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean removeCloseListener(CloseListener closeListener) {
        return this.closeListeners.remove(closeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GrizzlyFuture<CloseReason> closeFuture() {
        if (this.closeFuture == null) {
            SpdyStream spdyStream = this;
            synchronized (spdyStream) {
                if (this.closeFuture == null) {
                    CloseReason cr = this.closeReasonRef.get();
                    if (cr == null) {
                        final FutureImpl<CloseReason> f = Futures.createSafeFuture();
                        this.addCloseListener(new CloseListener(){

                            public void onClosed(Closeable closeable, ICloseType type) throws IOException {
                                CloseReason cr = SpdyStream.this.closeReasonRef.get();
                                assert (cr != null);
                                f.result(cr);
                            }
                        });
                        this.closeFuture = f;
                    } else {
                        this.closeFuture = Futures.createReadyFuture(cr);
                    }
                }
            }
        }
        return this.closeFuture;
    }

    void onInputClosed() {
        if (this.completeFinalizationCounter.incrementAndGet() == 2) {
            this.closeStream();
        }
    }

    void onOutputClosed() {
        if (this.completeFinalizationCounter.incrementAndGet() == 2) {
            this.closeStream();
        }
    }

    void onSynFrameRcv() throws SpdyStreamException {
        if (this.isSynFrameRcv) {
            this.inputBuffer.close(Constants.UNEXPECTED_FRAME_TERMINATION);
            throw new SpdyStreamException(this.getStreamId(), 1, "Only one syn frame is allowed");
        }
        this.isSynFrameRcv = true;
    }

    SpdyStreamException assertCanAcceptData() {
        if (this.isUnidirectional() && this.isLocallyInitiatedStream()) {
            return new SpdyStreamException(this.getStreamId(), 1, "Data frame received on unidirectional stream");
        }
        if (!this.isSynFrameRcv) {
            this.close0(null, CloseType.LOCALLY, new IOException("DataFrame came before Syn frame"), false);
            return new SpdyStreamException(this.getStreamId(), 1, "DataFrame came before Syn frame");
        }
        return null;
    }

    void offerInputData(Buffer data, boolean isLast) throws SpdyStreamException {
        boolean isFirstBufferCached = this.cachedInputBuffer == null;
        this.cachedIsLast |= isLast;
        this.cachedInputBuffer = Buffers.appendBuffers(this.spdySession.getMemoryManager(), this.cachedInputBuffer, data);
        if (isFirstBufferCached) {
            this.spdySession.streamsToFlushInput.add(this);
        }
    }

    void flushInputData() {
        Buffer cachedInputBufferLocal = this.cachedInputBuffer;
        boolean cachedIsLastLocal = this.cachedIsLast;
        this.cachedInputBuffer = null;
        this.cachedIsLast = false;
        if (cachedInputBufferLocal != null) {
            if (cachedInputBufferLocal.isComposite()) {
                ((CompositeBuffer)cachedInputBufferLocal).allowInternalBuffersDispose(true);
                cachedInputBufferLocal.allowBufferDispose(true);
                ((CompositeBuffer)cachedInputBufferLocal).disposeOrder(CompositeBuffer.DisposeOrder.LAST_TO_FIRST);
            }
            int size = cachedInputBufferLocal.remaining();
            if (!this.inputBuffer.offer(cachedInputBufferLocal, cachedIsLastLocal)) {
                this.spdySession.sendWindowUpdate(size);
            }
        }
    }

    HttpContent pollInputData() throws IOException {
        return this.inputBuffer.poll();
    }

    private void closeStream() {
        this.spdySession.deregisterStream(this);
    }

    HttpHeader getInputHttpHeader() {
        return this.isLocallyInitiatedStream() ^ this.isUnidirectional() ? this.spdyRequest.getResponse() : this.spdyRequest;
    }

    HttpHeader getOutputHttpHeader() {
        return !this.isLocallyInitiatedStream() ^ this.isUnidirectional() ? this.spdyRequest.getResponse() : this.spdyRequest;
    }

    final Map<String, PushResource> getAssociatedResourcesToPush() {
        return this.associatedResourcesToPush;
    }

    final void addAssociatedStream(SpdyStream spdyStream) throws SpdyStreamException {
        if (this.associatedSpdyStreams == null) {
            this.associatedSpdyStreams = Collections.newSetFromMap(DataStructures.getConcurrentMap(8));
        }
        this.associatedSpdyStreams.add(spdyStream);
        if (!this.isOpen() && this.associatedSpdyStreams.remove(spdyStream)) {
            throw new SpdyStreamException(spdyStream.getStreamId(), 3, "The parent stream is closed");
        }
    }

    final void rstAssociatedStreams() {
        if (this.associatedSpdyStreams != null) {
            Iterator<SpdyStream> it = this.associatedSpdyStreams.iterator();
            while (it.hasNext()) {
                SpdyStream associatedStream = it.next();
                it.remove();
                try {
                    associatedStream.resetRemotely();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void notifyCloseListeners() {
        CloseListener closeListener;
        CloseReason closeReason = this.closeReasonRef.get();
        while ((closeListener = this.closeListeners.poll()) != null) {
            try {
                closeListener.onClosed(this, closeReason.getType());
            }
            catch (IOException iOException) {}
        }
    }

    protected static class Termination {
        private final TerminationType type;
        private final String description;

        public Termination(TerminationType type, String description) {
            this.type = type;
            this.description = description;
        }

        public TerminationType getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public void doTask() {
        }
    }

    protected static enum TerminationType {
        FIN,
        RST,
        LOCAL_CLOSE,
        PEER_CLOSE,
        FORCED;

    }

    private static enum CompletionUnit {
        Input,
        Output,
        Complete;

    }
}

