/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.grizzly.spdy.SpdyStream;
import org.glassfish.grizzly.utils.Charsets;

public class Constants {
    public static final int SPDY_VERSION = 3;
    public static final int DEFAULT_MAX_CONCURRENT_STREAMS = 100;
    public static final int DEFAULT_INITIAL_WINDOW_SIZE = 65536;
    public static final int DEFAULT_MAX_FRAME_SIZE = 0x1000000;
    static final byte[] HOST_HEADER_BYTES = ":host".getBytes(Charsets.ASCII_CHARSET);
    static final byte[] METHOD_HEADER_BYTES = ":method".getBytes(Charsets.ASCII_CHARSET);
    static final byte[] PATH_HEADER_BYTES = ":path".getBytes(Charsets.ASCII_CHARSET);
    static final byte[] SCHEMA_HEADER_BYTES = ":scheme".getBytes(Charsets.ASCII_CHARSET);
    static final byte[] VERSION_HEADER_BYTES = ":version".getBytes(Charsets.ASCII_CHARSET);
    static final byte[] STATUS_HEADER_BYTES = ":status".getBytes(Charsets.ASCII_CHARSET);
    static final SpdyStream.Termination IN_FIN_TERMINATION = new SpdyStream.Termination(SpdyStream.TerminationType.FIN, "End of input");
    static final SpdyStream.Termination OUT_FIN_TERMINATION = new SpdyStream.Termination(SpdyStream.TerminationType.FIN, "The output stream has been closed");
    static final String CLOSED_BY_PEER_STRING = "Closed by peer";
    static final SpdyStream.Termination LOCAL_CLOSE_TERMINATION = new SpdyStream.Termination(SpdyStream.TerminationType.LOCAL_CLOSE, "Closed locally");
    static final SpdyStream.Termination PEER_CLOSE_TERMINATION = new SpdyStream.Termination(SpdyStream.TerminationType.PEER_CLOSE, "Closed by peer");
    static final SpdyStream.Termination RESET_TERMINATION = new SpdyStream.Termination(SpdyStream.TerminationType.RST, "Reset by peer");
    static final SpdyStream.Termination UNEXPECTED_FRAME_TERMINATION = new SpdyStream.Termination(SpdyStream.TerminationType.LOCAL_CLOSE, "Unexpected SPDY frame");
    static final SpdyStream.Termination FRAME_TOO_LARGE_TERMINATION = new SpdyStream.Termination(SpdyStream.TerminationType.LOCAL_CLOSE, "SpdyFrame sent by peer is too big");
    static final Set<Integer> CTRL_FRAMES_WITH_STREAM_ID = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(1, 2, 3, 8, 9)));
}

