/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.script.ScriptException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.compliance.CheckResult;
import onl.netfishers.netshot.compliance.Exemption;
import onl.netfishers.netshot.compliance.Rule;
import onl.netfishers.netshot.compliance.SoftwareRule;
import onl.netfishers.netshot.device.Config;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.DeviceGroup;
import onl.netfishers.netshot.device.Domain;
import onl.netfishers.netshot.device.Module;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.device.NetworkInterface;
import onl.netfishers.netshot.device.access.Cli;
import onl.netfishers.netshot.device.access.Ssh;
import onl.netfishers.netshot.device.access.Telnet;
import onl.netfishers.netshot.device.attribute.DeviceAttribute;
import onl.netfishers.netshot.device.credentials.DeviceCliAccount;
import onl.netfishers.netshot.device.credentials.DeviceCredentialSet;
import onl.netfishers.netshot.device.credentials.DeviceSshAccount;
import onl.netfishers.netshot.device.credentials.DeviceSshKeyAccount;
import onl.netfishers.netshot.device.credentials.DeviceTelnetAccount;
import onl.netfishers.netshot.work.tasks.CheckComplianceTask;
import onl.netfishers.netshot.work.tasks.RunDeviceScriptTask;
import onl.netfishers.netshot.work.tasks.TakeSnapshotTask;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Device {
    public static final String DEFAULTNAME = "[NONAME]";
    private static Logger logger = LoggerFactory.getLogger(Device.class);
    private Set<DeviceAttribute> attributes = new HashSet<DeviceAttribute>();
    protected boolean autoTryCredentials = true;
    protected Date changeDate;
    private int version;
    protected List<CheckComplianceTask> checkComplianceTasks = new ArrayList<CheckComplianceTask>();
    protected List<RunDeviceScriptTask> runDeviceScriptTasks = new ArrayList<RunDeviceScriptTask>();
    protected String comments = "";
    protected Set<CheckResult> complianceCheckResults = new HashSet<CheckResult>();
    protected Set<Exemption> complianceExemptions = new HashSet<Exemption>();
    protected List<Config> configs = new ArrayList<Config>();
    protected String contact = "";
    protected Date createdDate = new Date();
    private String creator;
    protected Set<DeviceCredentialSet> credentialSets = new HashSet<DeviceCredentialSet>();
    protected DeviceCredentialSet specificCredentialSet;
    protected String driver;
    protected Date eolDate = null;
    protected Module eolModule = null;
    protected Date eosDate = null;
    protected Module eosModule = null;
    protected String family = "";
    protected long id;
    protected Config lastConfig = null;
    protected String location = "";
    protected transient List<String> log = new ArrayList<String>();
    protected transient List<String> sessionDebugLog;
    protected Network4Address mgmtAddress;
    protected Domain mgmtDomain;
    protected List<Module> modules = new ArrayList<Module>();
    protected String name = "[NONAME]";
    protected NetworkClass networkClass = NetworkClass.UNKNOWN;
    protected List<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
    protected Set<DeviceGroup> ownerGroups = new HashSet<DeviceGroup>();
    protected String serialNumber = "";
    protected List<TakeSnapshotTask> snapshotTasks = new ArrayList<TakeSnapshotTask>();
    protected SoftwareRule.ConformanceLevel softwareLevel = SoftwareRule.ConformanceLevel.UNKNOWN;
    protected String softwareVersion = "";
    protected Status status = Status.INPRODUCTION;
    protected Set<String> virtualDevices = new HashSet<String>();
    protected Set<String> vrfInstances = new HashSet<String>();
    protected int sshPort = 0;
    protected int telnetPort = 0;
    protected Network4Address connectAddress;

    protected Device() {
    }

    public Device(String driver, Network4Address address, Domain domain, String creator) {
        this.driver = driver;
        this.mgmtAddress = address;
        this.mgmtDomain = domain;
        this.creator = creator;
    }

    public void addAttribute(DeviceAttribute attribute) {
        this.attributes.add(attribute);
    }

    public void addComplianceException(Rule rule, Date expiration) {
        Exemption exemption = new Exemption(rule, this, expiration);
        this.complianceExemptions.add(exemption);
    }

    public void addCredentialSet(DeviceCredentialSet credentialSet) {
        this.credentialSets.add(credentialSet);
    }

    public void addVirtualDevice(String virtualDevice) {
        this.virtualDevices.add(virtualDevice);
    }

    public void addVrfInstance(String vrfInstance) {
        this.vrfInstances.add(vrfInstance);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public void clearCredentialSets() {
        this.credentialSets.clear();
    }

    public void clearVirtualDevices() {
        this.virtualDevices.clear();
    }

    public void clearVrfInstance() {
        this.vrfInstances.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Device other = (Device)obj;
        return this.id == other.id;
    }

    @XmlElement
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="device", orphanRemoval=true)
    public Set<DeviceAttribute> getAttributes() {
        return this.attributes;
    }

    @Transient
    protected List<DeviceCredentialSet> getAutoCredentialSetList(Session session) throws HibernateException {
        return session.createQuery("from DeviceCredentialSet cs where (cs.mgmtDomain = :domain or cs.mgmtDomain is null) and (not (cs.deviceSpecific = :true))").setEntity("domain", (Object)this.getMgmtDomain()).setBoolean("true", true).list();
    }

    @XmlElement
    public Date getChangeDate() {
        return this.changeDate;
    }

    @Version
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="device")
    public List<CheckComplianceTask> getCheckComplianceTasks() {
        return this.checkComplianceTasks;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="device")
    public List<RunDeviceScriptTask> getRunDeviceScriptTasks() {
        return this.runDeviceScriptTasks;
    }

    @XmlElement
    public String getComments() {
        return this.comments;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="key.device", cascade={CascadeType.ALL}, orphanRemoval=true)
    public Set<CheckResult> getComplianceCheckResults() {
        return this.complianceCheckResults;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="key.device", cascade={CascadeType.ALL}, orphanRemoval=true)
    public Set<Exemption> getComplianceExemptions() {
        return this.complianceExemptions;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="device")
    public List<Config> getConfigs() {
        return this.configs;
    }

    @XmlElement
    public String getContact() {
        return this.contact;
    }

    @XmlElement
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @XmlElement
    public String getCreator() {
        return this.creator;
    }

    @XmlElement
    @Transient
    public List<Long> getCredentialSetIds() {
        ArrayList<Long> l = new ArrayList<Long>();
        for (DeviceCredentialSet credentialSet : this.credentialSets) {
            l.add(credentialSet.getId());
        }
        return l;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SELECT)
    public Set<DeviceCredentialSet> getCredentialSets() {
        return this.credentialSets;
    }

    @Transient
    public DeviceDriver getDeviceDriver() throws MissingDeviceDriverException {
        if (this.driver == null) {
            String message = String.format("The device with ID %d has no associated driver.", this.id);
            this.logIt(message, 1);
            throw new MissingDeviceDriverException(message);
        }
        DeviceDriver deviceDriver = DeviceDriver.getDriverByName(this.driver);
        if (deviceDriver == null) {
            String message = String.format("Unable to locate the driver %s for device %d.", this.driver, this.id);
            this.logIt(message, 1);
            throw new MissingDeviceDriverException(message);
        }
        return deviceDriver;
    }

    @XmlElement
    public String getDriver() {
        return this.driver;
    }

    @XmlElement
    public Date getEolDate() {
        return this.eolDate;
    }

    @XmlElement
    @OneToOne(fetch=FetchType.LAZY)
    public Module getEolModule() {
        return this.eolModule;
    }

    @XmlElement
    public Date getEosDate() {
        return this.eosDate;
    }

    @XmlElement
    @OneToOne(fetch=FetchType.LAZY)
    public Module getEosModule() {
        return this.eosModule;
    }

    @XmlElement
    public String getFamily() {
        return this.family;
    }

    @Id
    @GeneratedValue
    @XmlAttribute
    public long getId() {
        return this.id;
    }

    @OneToOne(fetch=FetchType.LAZY)
    public Config getLastConfig() {
        return this.lastConfig;
    }

    @XmlElement
    public String getLocation() {
        return this.location;
    }

    @Transient
    public List<String> getLog() {
        return this.log;
    }

    @Transient
    public List<String> getSessionDebugLog() {
        return this.sessionDebugLog;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="address", column=@Column(name="ipv4_address", unique=true)), @AttributeOverride(name="prefixLength", column=@Column(name="ipv4_pfxlen")), @AttributeOverride(name="addressUsage", column=@Column(name="ipv4_usage"))})
    @XmlElement
    public Network4Address getMgmtAddress() {
        return this.mgmtAddress;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @XmlElement
    public Domain getMgmtDomain() {
        return this.mgmtDomain;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="device", orphanRemoval=true)
    public List<Module> getModules() {
        return this.modules;
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    @XmlElement
    public NetworkClass getNetworkClass() {
        return this.networkClass;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="device", orphanRemoval=true)
    public List<NetworkInterface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    @XmlElement
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="cachedDevices")
    public Set<DeviceGroup> getOwnerGroups() {
        return this.ownerGroups;
    }

    @Transient
    public String getPlainLog() {
        StringBuffer buffer = new StringBuffer();
        for (String log : this.log) {
            buffer.append(log);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @Transient
    public String getPlainSessionDebugLog() {
        if (this.sessionDebugLog == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (String log : this.sessionDebugLog) {
            buffer.append(log);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @Transient
    @XmlElement
    public String getRealDeviceType() {
        try {
            DeviceDriver driver = this.getDeviceDriver();
            return driver.getDescription();
        }
        catch (MissingDeviceDriverException e) {
            return "Unknown driver";
        }
    }

    @XmlElement
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="device")
    public List<TakeSnapshotTask> getSnapshotTasks() {
        return this.snapshotTasks;
    }

    @XmlElement
    public SoftwareRule.ConformanceLevel getSoftwareLevel() {
        return this.softwareLevel;
    }

    @XmlElement
    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @XmlElement
    public Status getStatus() {
        return this.status;
    }

    @ElementCollection
    public Set<String> getVirtualDevices() {
        return this.virtualDevices;
    }

    @ElementCollection
    public Set<String> getVrfInstances() {
        return this.vrfInstances;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    @XmlElement
    public boolean isAutoTryCredentials() {
        return this.autoTryCredentials;
    }

    @XmlElement
    @Transient
    public boolean isCompliant() {
        for (CheckResult check : this.getComplianceCheckResults()) {
            if (!check.getResult().equals((Object)CheckResult.ResultOption.NONCONFORMING)) continue;
            return false;
        }
        return true;
    }

    @XmlElement
    @Transient
    public boolean isEndOfLife() {
        return this.eolDate != null && this.eolDate.before(new Date());
    }

    @XmlElement
    @Transient
    public boolean isEndOfSale() {
        return this.eosDate != null && this.eosDate.before(new Date());
    }

    public boolean isExempted(Rule rule) {
        Date now = new Date();
        for (Exemption exemption : this.getComplianceExemptions()) {
            if (!exemption.getRule().equals(rule) || !exemption.getExpirationDate().after(now)) continue;
            return true;
        }
        return false;
    }

    protected void logIt(String log, int level) {
        this.log.add("[" + level + "] " + log);
    }

    public void resetEoX() {
        this.eosDate = null;
        this.eosModule = null;
        this.eolDate = null;
        this.eolModule = null;
    }

    public void setAttributes(Set<DeviceAttribute> attributes) {
        this.attributes = attributes;
    }

    public void setAutoTryCredentials(boolean autoTryCredentials) {
        this.autoTryCredentials = autoTryCredentials;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public void setCheckComplianceTasks(List<CheckComplianceTask> checkComplianceTasks) {
        this.checkComplianceTasks = checkComplianceTasks;
    }

    public void setRunDeviceScriptTasks(List<RunDeviceScriptTask> tasks) {
        this.runDeviceScriptTasks = tasks;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    protected void setComplianceCheckResults(Set<CheckResult> complianceChecks) {
        this.complianceCheckResults = complianceChecks;
    }

    protected void setComplianceExemptions(Set<Exemption> complianceExemptions) {
        this.complianceExemptions = complianceExemptions;
    }

    public void setConfigs(List<Config> configs) {
        this.configs = configs;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    protected void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    protected void setCredentialSets(Set<DeviceCredentialSet> credentialSets) {
        this.credentialSets = credentialSets;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setEolDate(Date eolDate) {
        this.eolDate = eolDate;
    }

    public void setEolModule(Module eolModule) {
        this.eolModule = eolModule;
    }

    public void setEosDate(Date eosDate) {
        this.eosDate = eosDate;
    }

    public void setEosModule(Module eosModule) {
        this.eosModule = eosModule;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    protected void setId(long id) {
        this.id = id;
    }

    public void setLastConfig(Config lastConfig) {
        this.lastConfig = lastConfig;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setMgmtAddress(Network4Address mgmtAddress) {
        this.mgmtAddress = mgmtAddress;
    }

    public void setMgmtDomain(Domain mgmtDomain) {
        this.mgmtDomain = mgmtDomain;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNetworkClass(NetworkClass networkClass) {
        this.networkClass = networkClass;
    }

    public void setNetworkInterfaces(List<NetworkInterface> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
    }

    public void setOwnerGroups(Set<DeviceGroup> ownerGroups) {
        this.ownerGroups = ownerGroups;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    protected void setSnapshotTasks(List<TakeSnapshotTask> snapshotTaks) {
        this.snapshotTasks = snapshotTaks;
    }

    public void setSoftwareLevel(SoftwareRule.ConformanceLevel softwareLevel) {
        this.softwareLevel = softwareLevel;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setVirtualDevices(Set<String> virtualDevices) {
        this.virtualDevices = virtualDevices;
    }

    public void setVrfInstances(Set<String> vrfInstances) {
        this.vrfInstances = vrfInstances;
    }

    @XmlElement
    public int getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    @XmlElement
    public int getTelnetPort() {
        return this.telnetPort;
    }

    public void setTelnetPort(int telnetPort) {
        this.telnetPort = telnetPort;
    }

    @XmlElement
    @OneToOne(cascade={CascadeType.ALL})
    public DeviceCredentialSet getSpecificCredentialSet() {
        return this.specificCredentialSet;
    }

    public void setSpecificCredentialSet(DeviceCredentialSet specificCredentialSet) {
        this.specificCredentialSet = specificCredentialSet;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="address", column=@Column(name="connect_ipv4_address")), @AttributeOverride(name="prefixLength", column=@Column(name="connect_ipv4_pfxlen")), @AttributeOverride(name="addressUsage", column=@Column(name="connect_ipv4_usage"))})
    @XmlElement
    public Network4Address getConnectAddress() {
        return this.connectAddress;
    }

    public void setConnectAddress(Network4Address connectAddress) {
        this.connectAddress = connectAddress;
    }

    public void takeSnapshot(boolean debugSession) throws IOException, MissingDeviceDriverException, InvalidCredentialsException, ScriptException {
        this.execute(null, debugSession);
    }

    public void runScript(String script, boolean debugSession) throws IOException, MissingDeviceDriverException, InvalidCredentialsException, ScriptException {
        this.execute(script, debugSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute(String script, boolean debugSession) throws IOException, MissingDeviceDriverException, InvalidCredentialsException, ScriptException {
        boolean telnetOpened;
        boolean sshOpened;
        block53: {
            Cli cli;
            DeviceDriver deviceDriver = this.getDeviceDriver();
            sshOpened = true;
            telnetOpened = true;
            Network4Address address = this.mgmtAddress;
            if (this.connectAddress != null) {
                address = this.connectAddress;
            }
            Set<DeviceCredentialSet> credentialSets = this.credentialSets;
            if (this.specificCredentialSet != null) {
                credentialSets = new HashSet<DeviceCredentialSet>();
                credentialSets.add(this.specificCredentialSet);
            }
            if (deviceDriver.getProtocols().contains((Object)DeviceDriver.DriverProtocol.SSH)) {
                for (DeviceCredentialSet credentialSet : credentialSets) {
                    if (!(credentialSet instanceof DeviceSshAccount)) continue;
                    cli = credentialSet instanceof DeviceSshKeyAccount ? new Ssh(address, this.sshPort, ((DeviceSshKeyAccount)credentialSet).getUsername(), ((DeviceSshKeyAccount)credentialSet).getPublicKey(), ((DeviceSshKeyAccount)credentialSet).getPrivateKey(), ((DeviceSshKeyAccount)credentialSet).getPassword()) : new Ssh(address, this.sshPort, ((DeviceSshAccount)credentialSet).getUsername(), ((DeviceSshAccount)credentialSet).getPassword());
                    try {
                        cli.connect();
                        deviceDriver.runScript(this, cli, DeviceDriver.DriverProtocol.SSH, (DeviceCliAccount)credentialSet, script, debugSession);
                        return;
                    }
                    catch (InvalidCredentialsException e) {
                        this.logIt(String.format("Authentication failed using SSH credential set %s.", credentialSet.getName()), 1);
                    }
                    catch (ScriptException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        logger.warn("Unable to open an SSH connection to {}:{}.", address.getIp(), this.sshPort, e);
                        if (e.getMessage().contains("Auth fail")) {
                            this.logIt(String.format("Authentication failed using SSH credential set %s.", credentialSet.getName()), 1);
                            continue;
                        }
                        this.logIt("Unable to open an SSH socket to the device.", 2);
                        sshOpened = false;
                        break;
                    }
                    finally {
                        cli.disconnect();
                    }
                }
            }
            if (deviceDriver.getProtocols().contains((Object)DeviceDriver.DriverProtocol.TELNET)) {
                for (DeviceCredentialSet credentialSet : credentialSets) {
                    if (!(credentialSet instanceof DeviceTelnetAccount)) continue;
                    cli = new Telnet(address, this.telnetPort);
                    try {
                        cli.connect();
                        deviceDriver.runScript(this, cli, DeviceDriver.DriverProtocol.TELNET, (DeviceCliAccount)credentialSet, script, debugSession);
                        return;
                    }
                    catch (InvalidCredentialsException e) {
                        this.logIt(String.format("Authentication failed using Telnet credential set %s.", credentialSet.getName()), 1);
                    }
                    catch (ScriptException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        logger.warn("Unable to open a Telnet connection to {}:{}.", address.getIp(), this.telnetPort, e);
                        this.logIt("Unable to open a Telnet socket to the device.", 2);
                        telnetOpened = false;
                        break;
                    }
                    finally {
                        cli.disconnect();
                    }
                }
            }
            if (this.autoTryCredentials && (sshOpened || telnetOpened)) {
                Iterator<DeviceCredentialSet> ci;
                Cli cli2;
                Session session = Database.getSession();
                List<DeviceCredentialSet> globalCredentialSets = this.getAutoCredentialSetList(session);
                if (sshOpened) {
                    for (DeviceCredentialSet credentialSet : globalCredentialSets) {
                        if (!(credentialSet instanceof DeviceSshAccount)) continue;
                        this.logIt(String.format("Will try SSH credentials %s.", credentialSet.getName()), 5);
                        cli2 = credentialSet instanceof DeviceSshKeyAccount ? new Ssh(address, this.sshPort, ((DeviceSshKeyAccount)credentialSet).getUsername(), ((DeviceSshKeyAccount)credentialSet).getPublicKey(), ((DeviceSshKeyAccount)credentialSet).getPrivateKey(), ((DeviceSshKeyAccount)credentialSet).getPassword()) : new Ssh(address, this.sshPort, ((DeviceSshAccount)credentialSet).getUsername(), ((DeviceSshAccount)credentialSet).getPassword());
                        try {
                            cli2.connect();
                            deviceDriver.runScript(this, cli2, DeviceDriver.DriverProtocol.SSH, (DeviceCliAccount)credentialSet, script, debugSession);
                            ci = credentialSets.iterator();
                            while (ci.hasNext()) {
                                DeviceCredentialSet c = ci.next();
                                if (!(c instanceof DeviceCliAccount)) continue;
                                ci.remove();
                            }
                            credentialSets.add(credentialSet);
                            return;
                        }
                        catch (InvalidCredentialsException e) {
                            this.logIt(String.format("Authentication failed using Telnet credential set %s.", credentialSet.getName()), 1);
                        }
                        catch (ScriptException e) {
                            throw e;
                        }
                        catch (IOException e) {
                            logger.warn("Unable to open an SSH connection to {}:{}.", address.getIp(), this.sshPort, e);
                            if (e.getMessage().contains("Auth fail") || e.getMessage().contains("authentication failure")) {
                                this.logIt(String.format("Authentication failed using SSH credential set %s.", credentialSet.getName()), 1);
                                continue;
                            }
                            this.logIt("Unable to open an SSH socket to the device.", 2);
                            break;
                        }
                        finally {
                            cli2.disconnect();
                        }
                    }
                }
                if (!telnetOpened) break block53;
                for (DeviceCredentialSet credentialSet : globalCredentialSets) {
                    if (!(credentialSet instanceof DeviceTelnetAccount)) continue;
                    this.logIt(String.format("Will try Telnet credentials %s.", credentialSet.getName()), 5);
                    cli2 = new Telnet(address, this.telnetPort);
                    try {
                        cli2.connect();
                        deviceDriver.runScript(this, cli2, DeviceDriver.DriverProtocol.TELNET, (DeviceCliAccount)credentialSet, script, debugSession);
                        ci = credentialSets.iterator();
                        while (ci.hasNext()) {
                            DeviceCredentialSet c = ci.next();
                            if (!(c instanceof DeviceCliAccount)) continue;
                            ci.remove();
                        }
                        credentialSets.add(credentialSet);
                        return;
                    }
                    catch (InvalidCredentialsException e) {
                        try {
                            this.logIt(String.format("Authentication failed using Telnet credential set %s.", credentialSet.getName()), 1);
                            continue;
                            catch (ScriptException e2) {
                                throw e2;
                                catch (IOException e3) {
                                    logger.warn("Unable to open a Telnet connection to {}:{}.", address.getIp(), this.telnetPort, e3);
                                    this.logIt("Unable to open a Telnet socket to the device.", 2);
                                    telnetOpened = false;
                                    break block53;
                                }
                            }
                        }
                        catch (HibernateException e4) {
                            session.getTransaction().rollback();
                            this.logIt("Error while retrieving the global credentials.", 2);
                            logger.error("Error while retrieving the global credentials.", e4);
                            break block53;
                        }
                        finally {
                            cli2.disconnect();
                        }
                    }
                }
                break block53;
                finally {
                    session.close();
                }
            }
        }
        if (sshOpened) throw new InvalidCredentialsException("Couldn't find valid credentials.");
        if (telnetOpened) throw new InvalidCredentialsException("Couldn't find valid credentials.");
        throw new IOException("Couldn't open either SSH or Telnet socket with the device.");
    }

    public static enum Status {
        DISABLED,
        INPRODUCTION,
        PREPRODUCTION;

    }

    public static enum NetworkClass {
        FIREWALL,
        LOADBALANCER,
        ROUTER,
        SERVER,
        SWITCH,
        SWITCHROUTER,
        UNKNOWN;

    }

    public static class MissingDeviceDriverException
    extends Exception {
        private static final long serialVersionUID = -7286042265874166550L;

        public MissingDeviceDriverException(String message) {
            super(message);
        }
    }

    public static class InvalidCredentialsException
    extends Exception {
        private static final long serialVersionUID = 2762061771246688828L;

        public InvalidCredentialsException(String message) {
            super(message);
        }
    }
}

