/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import net.sf.ehcache.store.ElementValueComparator;

public class ElementValueComparatorConfiguration {
    private volatile String className = "net.sf.ehcache.store.DefaultElementValueComparator";
    private ElementValueComparator comparator;

    public String getClassName() {
        return this.className;
    }

    public void setClass(String className) {
        this.className = className;
    }

    public synchronized ElementValueComparator getElementComparatorInstance() {
        if (this.comparator == null) {
            Class<?> elementComparator = null;
            try {
                elementComparator = Class.forName(this.className);
                this.comparator = (ElementValueComparator)elementComparator.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Couldn't find the ElementValueComparator class!", e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Couldn't instantiate the ElementValueComparator instance!", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Couldn't instantiate the ElementValueComparator instance!", e);
            }
            catch (ClassCastException e) {
                throw new RuntimeException(elementComparator != null ? elementComparator.getSimpleName() + " doesn't implement net.sf.ehcache.store.ElementValueComparator" : "Error with ElementValueComparator", e);
            }
        }
        return this.comparator;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementValueComparatorConfiguration other = (ElementValueComparatorConfiguration)obj;
        return !(this.className == null ? other.className != null : !this.className.equals(other.className));
    }
}

