"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var util_1 = require("./util");
exports.AXIS_PARTS = ['domain', 'grid', 'labels', 'ticks', 'title'];
/**
 * A dictionary listing whether a certain axis property is applicable for only main axes or only grid axes.
 * (Properties not listed are applicable for both)
 */
exports.AXIS_PROPERTY_TYPE = {
    grid: 'grid',
    gridScale: 'grid',
    domain: 'main',
    labels: 'main',
    labelFlush: 'main',
    labelOverlap: 'main',
    minExtent: 'main',
    maxExtent: 'main',
    offset: 'main',
    ticks: 'main',
    title: 'main',
    values: 'both',
    scale: 'both',
    zindex: 'both' // this is actually set afterward, so it doesn't matter
};
var COMMON_AXIS_PROPERTIES_INDEX = {
    orient: 1,
    domain: 1,
    format: 1,
    grid: 1,
    labelBound: 1,
    labelFlush: 1,
    labelPadding: 1,
    labels: 1,
    labelOverlap: 1,
    maxExtent: 1,
    minExtent: 1,
    offset: 1,
    position: 1,
    tickCount: 1,
    ticks: 1,
    tickSize: 1,
    title: 1,
    titlePadding: 1,
    values: 1,
    zindex: 1,
};
var AXIS_PROPERTIES_INDEX = tslib_1.__assign({}, COMMON_AXIS_PROPERTIES_INDEX, { encoding: 1, labelAngle: 1, titleMaxLength: 1 });
var VG_AXIS_PROPERTIES_INDEX = tslib_1.__assign({ scale: 1 }, COMMON_AXIS_PROPERTIES_INDEX, { gridScale: 1, encode: 1 });
function isAxisProperty(prop) {
    return !!AXIS_PROPERTIES_INDEX[prop];
}
exports.isAxisProperty = isAxisProperty;
exports.VG_AXIS_PROPERTIES = util_1.flagKeys(VG_AXIS_PROPERTIES_INDEX);
// Export for dependent projects
exports.AXIS_PROPERTIES = util_1.flagKeys(AXIS_PROPERTIES_INDEX);
//# sourceMappingURL=data:application/json;base64,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