'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KuiFlexItem = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; } /*
                                                                                                                                                                                                                              * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                              * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                              * this work for additional information regarding copyright
                                                                                                                                                                                                                              * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                              * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                              * not use this file except in compliance with the License.
                                                                                                                                                                                                                              * You may obtain a copy of the License at
                                                                                                                                                                                                                              *
                                                                                                                                                                                                                              *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                              *
                                                                                                                                                                                                                              * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                              * software distributed under the License is distributed on an
                                                                                                                                                                                                                              * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                              * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                              * specific language governing permissions and limitations
                                                                                                                                                                                                                              * under the License.
                                                                                                                                                                                                                              */

var validGrowNumbers = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];

var KuiFlexItem = function KuiFlexItem(_ref) {
  var children = _ref.children,
      className = _ref.className,
      grow = _ref.grow,
      rest = _objectWithoutProperties(_ref, ['children', 'className', 'grow']);

  var classes = (0, _classnames2.default)('kuiFlexItem', _defineProperty({
    'kuiFlexItem--flexGrowZero': !grow
  }, 'kuiFlexItem--flexGrow' + grow, validGrowNumbers.indexOf(grow) >= 0), className);

  return _react2.default.createElement(
    'div',
    _extends({
      className: classes
    }, rest),
    children
  );
};

exports.KuiFlexItem = KuiFlexItem;
KuiFlexItem.propTypes = {
  children: _propTypes2.default.node,
  grow: growPropType
};

function growPropType(props, propName, componentName) {
  var value = props[propName];

  var validValues = [null, undefined, true, false].concat(validGrowNumbers);

  if (validValues.indexOf(value) === -1) {
    return new Error('Prop `' + propName + '` supplied to `' + componentName + '` must be a boolean or an integer between 1 and 10.');
  }
}

KuiFlexItem.defaultProps = {
  grow: true
};
