'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDatePickerRange = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _text = require('../text');

var _icon = require('../icon');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var EuiDatePickerRange = function EuiDatePickerRange(_ref) {
  var className = _ref.className,
      startDateControl = _ref.startDateControl,
      endDateControl = _ref.endDateControl,
      iconType = _ref.iconType,
      rest = _objectWithoutProperties(_ref, ['className', 'startDateControl', 'endDateControl', 'iconType']);

  var classes = (0, _classnames2.default)('euiDatePickerRange', className);

  // Set the icon for the entire group instead of per control
  var optionalIcon = void 0;
  if (iconType) {
    var icon = typeof iconType === 'string' ? iconType : 'calendar';
    optionalIcon = _react2.default.createElement(
      'span',
      { className: 'euiDatePickerRange__icon' },
      _react2.default.createElement(_icon.EuiIcon, { type: icon })
    );
  } else {
    optionalIcon = null;
  }

  var clonedStartDate = (0, _react.cloneElement)(startDateControl, {
    showIcon: false
  });

  var clonedEndDate = (0, _react.cloneElement)(endDateControl, {
    showIcon: false
  });

  return _react2.default.createElement(
    'div',
    _extends({
      className: classes
    }, rest),
    optionalIcon,
    clonedStartDate,
    _react2.default.createElement(
      _text.EuiText,
      { className: 'euiDatePickerRange__delimeter', size: 's', color: 'subdued' },
      '\u2192'
    ),
    clonedEndDate
  );
};

exports.EuiDatePickerRange = EuiDatePickerRange;
EuiDatePickerRange.propTypes = {
  /**
   * The start date `EuiDatePicker` element
   */
  startDateControl: _propTypes2.default.node.isRequired,
  /**
   * The end date `EuiDatePicker` element
   */
  endDateControl: _propTypes2.default.node.isRequired,
  /**
   * Pass either an icon type or set to `false` to remove icon entirely
   */
  iconType: _propTypes2.default.oneOfType([_propTypes2.default.bool, _propTypes2.default.oneOf(_icon.ICON_TYPES)])
};

EuiDatePickerRange.defaultProps = {
  iconType: true
};
EuiDatePickerRange.__docgenInfo = [{
  'description': '',
  'methods': [],
  'props': {
    'startDateControl': {
      'type': {
        'name': 'node'
      },
      'required': true,
      'description': 'The start date `EuiDatePicker` element'
    },
    'endDateControl': {
      'type': {
        'name': 'node'
      },
      'required': true,
      'description': 'The end date `EuiDatePicker` element'
    },
    'iconType': {
      'type': {
        'name': 'union',
        'value': [{
          'name': 'bool'
        }, {
          'name': 'enum',
          'computed': true,
          'value': 'ICON_TYPES'
        }]
      },
      'required': false,
      'description': 'Pass either an icon type or set to `false` to remove icon entirely',
      'defaultValue': {
        'value': 'true',
        'computed': false
      }
    }
  }
}];