/*
 * This file has been generated by the onto2vocabularyclass tool
 * copyright (C) 2007-2010 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _SOPRANO_NFO_H_
#define _SOPRANO_NFO_H_

#include <QtCore/QUrl>
#include "nepomuk_export.h"

namespace Nepomuk {
    namespace Vocabulary {
        namespace NFO {
            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#
             */
            NEPOMUK_EXPORT QUrl nfoNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#
             */
            NEPOMUK_EXPORT QUrl nrlOntologyGraph();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Application 
             * 
             * An application 
             */
            NEPOMUK_EXPORT QUrl Application();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Archive 
             * 
             * A compressed file. May contain other files or folder inside. 
             */
            NEPOMUK_EXPORT QUrl Archive();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#ArchiveItem 
             * 
             * A file entity inside an archive. 
             */
            NEPOMUK_EXPORT QUrl ArchiveItem();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Attachment 
             * 
             * A file attached to another data object. Many data formats allow 
             * for attachments: emails, vcards, ical events, id3 and exif... 
             */
            NEPOMUK_EXPORT QUrl Attachment();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Audio 
             * 
             * A file containing audio content 
             */
            NEPOMUK_EXPORT QUrl Audio();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Bookmark 
             * 
             * A bookmark of a webbrowser. Use nie:title for the name/label, 
             * nie:contentCreated to represent the date when the user added 
             * the bookmark, and nie:contentLastModified for modifications. 
             * nfo:bookmarks to store the link. 
             */
            NEPOMUK_EXPORT QUrl Bookmark();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#BookmarkFolder 
             * 
             * A folder with bookmarks of a webbrowser. Use nfo:containsBookmark 
             * to relate Bookmarks. Folders can contain subfolders, use containsBookmarkFolder 
             * to relate them. 
             */
            NEPOMUK_EXPORT QUrl BookmarkFolder();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#CompressionType 
             * 
             * Type of compression. Instances of this class represent the 
             * limited set of values allowed for the nfo:compressionType 
             * property. 
             */
            NEPOMUK_EXPORT QUrl CompressionType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Cursor 
             * 
             * A Cursor. 
             */
            NEPOMUK_EXPORT QUrl Cursor();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#DataContainer 
             * 
             * A superclass for all entities, whose primary purpose is to serve 
             * as containers for other data object. They usually don't have 
             * any "meaning" by themselves. Examples include folders, archives 
             * and optical disc images. 
             */
            NEPOMUK_EXPORT QUrl DataContainer();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#DeletedResource 
             * 
             * A file entity that has been deleted from the original source. 
             * Usually such entities are stored within various kinds of 'Trash' 
             * or 'Recycle Bin' folders. 
             */
            NEPOMUK_EXPORT QUrl DeletedResource();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Document 
             * 
             * A generic document. A common superclass for all documents on 
             * the desktop. 
             */
            NEPOMUK_EXPORT QUrl Document();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#EmbeddedFileDataObject 
             * 
             * A file embedded in another data object. There are many ways in 
             * which a file may be embedded in another one. Use this class directly 
             * only in cases if none of the subclasses gives a better description 
             * of your case. 
             */
            NEPOMUK_EXPORT QUrl EmbeddedFileDataObject();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#EncryptionStatus 
             * 
             * The status of the encryption of an InformationElement. nfo:encryptedStatus 
             * means that the InformationElement has been encrypted and couldn't 
             * be decrypted by the extraction software, thus no content is 
             * available. nfo:decryptedStatus means that decryption was 
             * successfull and the content is available. 
             */
            NEPOMUK_EXPORT QUrl EncryptionStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Executable 
             * 
             * An executable file. 
             */
            NEPOMUK_EXPORT QUrl Executable();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FileDataObject 
             * 
             * A resource containing a finite sequence of bytes with arbitrary 
             * information, that is available to a computer program and is 
             * usually based on some kind of durable storage. A file is durable 
             * in the sense that it remains available for programs to use after 
             * the current program has finished. 
             */
            NEPOMUK_EXPORT QUrl FileDataObject();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FileHash 
             * 
             * A fingerprint of the file, generated by some hashing function. 
             */
            NEPOMUK_EXPORT QUrl FileHash();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Filesystem 
             * 
             * A filesystem. Examples of filesystems include hard disk partitions, 
             * removable media, but also images thereof stored in files such 
             * as ISO. 
             */
            NEPOMUK_EXPORT QUrl Filesystem();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FilesystemImage 
             * 
             * An image of a filesystem. Instances of this class may include 
             * CD images, DVD images or hard disk partition images created 
             * by various pieces of software (e.g. Norton Ghost). Deprecated 
             * in favor of nfo:Filesystem. 
             */
            NEPOMUK_EXPORT QUrl FilesystemImage();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Folder 
             * 
             * A folder/directory. Examples of folders include folders on 
             * a filesystem and message folders in a mailbox. 
             */
            NEPOMUK_EXPORT QUrl Folder();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Font 
             * 
             * A font. 
             */
            NEPOMUK_EXPORT QUrl Font();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#HardDiskPartition 
             * 
             * A partition on a hard disk 
             */
            NEPOMUK_EXPORT QUrl HardDiskPartition();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#HtmlDocument 
             * 
             * A HTML document, may contain links to other files. 
             */
            NEPOMUK_EXPORT QUrl HtmlDocument();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Icon 
             * 
             * An Icon (regardless of whether it's a raster or a vector icon. 
             * A resource representing an icon could have two types (Icon and 
             * Raster, or Icon and Vector) if required. 
             */
            NEPOMUK_EXPORT QUrl Icon();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Image 
             * 
             * A file containing an image. 
             */
            NEPOMUK_EXPORT QUrl Image();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#LocalFileDataObject 
             * 
             * A local file data object which is stored on a local file system. 
             * Its nie:url always uses the file:/ protocol. The main use of 
             * this class is to distinguish local and non-local files. 
             */
            NEPOMUK_EXPORT QUrl LocalFileDataObject();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Media 
             * 
             * A piece of media content. This class may be used to express complex 
             * media containers with many streams of various media content 
             * (both aural and visual). 
             */
            NEPOMUK_EXPORT QUrl Media();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MediaFileListEntry 
             * 
             * A single node in the list of media files contained within an MediaList 
             * instance. This class is intended to provide a type all those 
             * links have. In valid NRL untyped resources cannot be linked. 
             * There are no properties defined for this class but the application 
             * may expect rdf:first and rdf:last links. The former points 
             * to the DataObject instance, interpreted as Media the latter 
             * points at another MediaFileListEntr. At the end of the list 
             * there is a link to rdf:nil. 
             */
            NEPOMUK_EXPORT QUrl MediaFileListEntry();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MediaList 
             * 
             * A file containing a list of media files.e.g. a playlist 
             */
            NEPOMUK_EXPORT QUrl MediaList();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MediaStream 
             * 
             * A stream of multimedia content, usually contained within a 
             * media container such as a movie (containing both audio and video) 
             * or a DVD (possibly containing many streams of audio and video). 
             * Most common interpretations for such a DataObject include 
             * Audio and Video. 
             */
            NEPOMUK_EXPORT QUrl MediaStream();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MindMap 
             * 
             * A MindMap, created by a mind-mapping utility. Examples might 
             * include FreeMind or mind mapper. 
             */
            NEPOMUK_EXPORT QUrl MindMap();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#OperatingSystem 
             * 
             * An OperatingSystem 
             */
            NEPOMUK_EXPORT QUrl OperatingSystem();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#PaginatedTextDocument 
             * 
             * A file containing a text document, that is unambiguously divided 
             * into pages. Examples might include PDF, DOC, PS, DVI etc. 
             */
            NEPOMUK_EXPORT QUrl PaginatedTextDocument();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#PlainTextDocument 
             * 
             * A file containing plain text (ASCII, Unicode or other encodings). 
             * Examples may include TXT, HTML, XML, program source code etc. 
             */
            NEPOMUK_EXPORT QUrl PlainTextDocument();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Presentation 
             * 
             * A Presentation made by some presentation software (Corel Presentations, 
             * OpenOffice Impress, MS Powerpoint etc.) 
             */
            NEPOMUK_EXPORT QUrl Presentation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RasterImage 
             * 
             * A raster image. 
             */
            NEPOMUK_EXPORT QUrl RasterImage();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RemoteDataObject 
             * 
             * A file data object stored at a remote location. Don't confuse 
             * this class with a RemotePortAddress. This one applies to a particular 
             * resource, RemotePortAddress applies to an address, that can 
             * have various interpretations. 
             */
            NEPOMUK_EXPORT QUrl RemoteDataObject();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RemotePortAddress 
             * 
             * An address specifying a remote host and port. Such an address 
             * can be interpreted in many ways (examples of such interpretations 
             * include mailboxes, websites, remote calendars or filesystems), 
             * depending on an interpretation, various kinds of data may be 
             * extracted from such an address. 
             */
            NEPOMUK_EXPORT QUrl RemotePortAddress();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Software 
             * 
             * A piece of software. Examples may include applications and 
             * the operating system. This interpretation most commonly applies 
             * to SoftwareItems. 
             */
            NEPOMUK_EXPORT QUrl Software();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SoftwareItem 
             * 
             * A DataObject representing a piece of software. Examples of 
             * interpretations of a SoftwareItem include an Application 
             * and an OperatingSystem. 
             */
            NEPOMUK_EXPORT QUrl SoftwareItem();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SoftwareService 
             * 
             * A service published by a piece of software, either by an operating 
             * system or an application. Examples of such services may include 
             * calendar, addressbook and mailbox managed by a PIM application. 
             * This category is introduced to distinguish between data available 
             * directly from the applications (Via some Interprocess Communication 
             * Mechanisms) and data available from files on a disk. In either 
             * case both DataObjects would receive a similar interpretation 
             * (e.g. a Mailbox) and wouldn't differ on the content level. 
             */
            NEPOMUK_EXPORT QUrl SoftwareService();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SourceCode 
             * 
             * Code in a compilable or interpreted programming language. 
             */
            NEPOMUK_EXPORT QUrl SourceCode();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Spreadsheet 
             * 
             * A spreadsheet, created by a spreadsheet application. Examples 
             * might include Gnumeric, OpenOffice Calc or MS Excel. 
             */
            NEPOMUK_EXPORT QUrl Spreadsheet();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#TextDocument 
             * 
             * A text document 
             */
            NEPOMUK_EXPORT QUrl TextDocument();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Trash 
             * 
             * Represents a container for deleted files, a feature common 
             * in modern operating systems. 
             */
            NEPOMUK_EXPORT QUrl Trash();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#VectorImage 
             */
            NEPOMUK_EXPORT QUrl VectorImage();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Video 
             * 
             * A video file. 
             */
            NEPOMUK_EXPORT QUrl Video();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Visual 
             * 
             * File containing visual content. 
             */
            NEPOMUK_EXPORT QUrl Visual();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#WebDataObject 
             * 
             * An information resources of which representations (files, 
             * streams) can be retrieved through a web server. They may be generated 
             * at retrieval time. Typical examples are pages served by PHP 
             * or AJAX or mp3 streams. 
             */
            NEPOMUK_EXPORT QUrl WebDataObject();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Website 
             * 
             * A website, usually a container for remote resources, that may 
             * be interpreted as HTMLDocuments, images or other types of content. 
             */
            NEPOMUK_EXPORT QUrl Website();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#aspectRatio 
             * 
             * Visual content aspect ratio. (Width divided by Height) 
             */
            NEPOMUK_EXPORT QUrl aspectRatio();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#averageBitrate 
             * 
             * The average overall bitrate of a media container. (i.e. the 
             * size of the piece of media in bits, divided by it's duration expressed 
             * in seconds). 
             */
            NEPOMUK_EXPORT QUrl averageBitrate();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#belongsToContainer 
             * 
             * Models the containment relations between Files and Folders 
             * (or CompressedFiles). 
             */
            NEPOMUK_EXPORT QUrl belongsToContainer();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#bitDepth 
             * 
             * A common superproperty for all properties signifying the amount 
             * of bits for an atomic unit of data. Examples of subproperties 
             * may include bitsPerSample and bitsPerPixel 
             */
            NEPOMUK_EXPORT QUrl bitDepth();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#bitrateType 
             * 
             * The type of the bitrate. Examples may include CBR and VBR. 
             */
            NEPOMUK_EXPORT QUrl bitrateType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#bitsPerSample 
             * 
             * Amount of bits in each audio sample. 
             */
            NEPOMUK_EXPORT QUrl bitsPerSample();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#bookmarks 
             * 
             * The address of the linked object. Usually a web URI. 
             */
            NEPOMUK_EXPORT QUrl bookmarks();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#channels 
             * 
             * Number of channels. This property is to be used directly if no 
             * detailed information is necessary. Otherwise use more detailed 
             * subproperties. 
             */
            NEPOMUK_EXPORT QUrl channels();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#characterCount 
             * 
             * The amount of characters in the document. 
             */
            NEPOMUK_EXPORT QUrl characterCount();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#characterPosition 
             * 
             * Character position of the bookmark. 
             */
            NEPOMUK_EXPORT QUrl characterPosition();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#codec 
             * 
             * The name of the codec necessary to decode a piece of media. 
             */
            NEPOMUK_EXPORT QUrl codec();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#colorCount 
             * 
             * The number of colors used/available in a raster image. 
             */
            NEPOMUK_EXPORT QUrl colorCount();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#colorDepth 
             * 
             * Amount of bits used to express the color of each pixel. 
             */
            NEPOMUK_EXPORT QUrl colorDepth();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#commentCharacterCount 
             * 
             * The amount of character in comments i.e. characters ignored 
             * by the compiler/interpreter. 
             */
            NEPOMUK_EXPORT QUrl commentCharacterCount();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#compressionType 
             * 
             * The type of the compression. Values include, 'lossy' and 'lossless'. 
             */
            NEPOMUK_EXPORT QUrl compressionType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#conflicts 
             * 
             * States that a piece of software is in conflict with another piece 
             * of software. 
             */
            NEPOMUK_EXPORT QUrl conflicts();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#containsBookmark 
             * 
             * The folder contains a bookmark. 
             */
            NEPOMUK_EXPORT QUrl containsBookmark();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#containsBookmarkFolder 
             * 
             * The folder contains a bookmark folder. 
             */
            NEPOMUK_EXPORT QUrl containsBookmarkFolder();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#count 
             * 
             * A common superproperty for all properties signifying the amount 
             * of atomic media data units. Examples of subproperties may include 
             * sampleCount and frameCount. 
             */
            NEPOMUK_EXPORT QUrl count();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#decryptedStatus 
             */
            NEPOMUK_EXPORT QUrl decryptedStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#definesClass 
             * 
             * Name of a class defined in the source code file. 
             */
            NEPOMUK_EXPORT QUrl definesClass();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#definesFunction 
             * 
             * A name of a function/method defined in the given source code 
             * file. 
             */
            NEPOMUK_EXPORT QUrl definesFunction();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#definesGlobalVariable 
             * 
             * Name of a global variable defined within the source code file. 
             */
            NEPOMUK_EXPORT QUrl definesGlobalVariable();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#deletionDate 
             * 
             * The date and time of the deletion. 
             */
            NEPOMUK_EXPORT QUrl deletionDate();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#depiction 
             * 
             * Relates an information element to an image which depicts said 
             * element. 
             */
            NEPOMUK_EXPORT QUrl depiction();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#depicts 
             * 
             * Relates an image to the information elements it depicts. 
             */
            NEPOMUK_EXPORT QUrl depicts();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#duration 
             * 
             * Duration of a media piece. 
             */
            NEPOMUK_EXPORT QUrl duration();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#encoding 
             * 
             * The encoding used for the Embedded File. Examples might include 
             * BASE64 or UUEncode 
             */
            NEPOMUK_EXPORT QUrl encoding();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#encryptedStatus 
             */
            NEPOMUK_EXPORT QUrl encryptedStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#encryptionStatus 
             * 
             * The status of the encryption of the InformationElement. 
             */
            NEPOMUK_EXPORT QUrl encryptionStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#fileCreated 
             * 
             * File creation date 
             */
            NEPOMUK_EXPORT QUrl fileCreated();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#fileLastAccessed 
             * 
             * Time when the file was last accessed. 
             */
            NEPOMUK_EXPORT QUrl fileLastAccessed();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#fileLastModified 
             * 
             * last modification date 
             */
            NEPOMUK_EXPORT QUrl fileLastModified();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#fileName 
             * 
             * Name of the file, together with the extension 
             */
            NEPOMUK_EXPORT QUrl fileName();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#fileOwner 
             * 
             * The owner of the file as defined by the file system access rights 
             * feature. 
             */
            NEPOMUK_EXPORT QUrl fileOwner();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#fileSize 
             * 
             * The size of the file in bytes. For compressed files it means the 
             * size of the packed file, not of the contents. For folders it means 
             * the aggregated size of all contained files and folders 
             */
            NEPOMUK_EXPORT QUrl fileSize();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#fileUrl 
             * 
             * URL of the file. It points at the location of the file. In cases 
             * where creating a simple file:// or http:// URL for a file is difficult 
             * (e.g. for files inside compressed archives) the applications 
             * are encouraged to use conventions defined by Apache Commons 
             * VFS Project at http://jakarta.apache.org/ commons/ vfs/ 
             * filesystems.html. 
             */
            NEPOMUK_EXPORT QUrl fileUrl();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#filesystemType 
             * 
             * Type of filesystem such as ext3 and ntfs. 
             */
            NEPOMUK_EXPORT QUrl filesystemType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#fontFamily 
             * 
             * The name of the font family. 
             */
            NEPOMUK_EXPORT QUrl fontFamily();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#foundry 
             * 
             * The foundry, the organization that created the font. 
             */
            NEPOMUK_EXPORT QUrl foundry();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#frameCount 
             * 
             * The amount of frames in a video sequence. 
             */
            NEPOMUK_EXPORT QUrl frameCount();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#frameRate 
             * 
             * Amount of video frames per second. 
             */
            NEPOMUK_EXPORT QUrl frameRate();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#freeSpace 
             * 
             * Unoccupied storage space of the filesystem. 
             */
            NEPOMUK_EXPORT QUrl freeSpace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#frontChannels 
             * 
             * Number of front channels. 
             */
            NEPOMUK_EXPORT QUrl frontChannels();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#hasHash 
             * 
             * Links the file with it's hash value. 
             */
            NEPOMUK_EXPORT QUrl hasHash();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#hasMediaFileListEntry 
             * 
             * This property is intended to point to an RDF list of MediaFiles. 
             */
            NEPOMUK_EXPORT QUrl hasMediaFileListEntry();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#hasMediaStream 
             * 
             * Connects a media container with a single media stream contained 
             * within. 
             */
            NEPOMUK_EXPORT QUrl hasMediaStream();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#hashAlgorithm 
             * 
             * Name of the algorithm used to compute the hash value. Examples 
             * might include CRC32, MD5, SHA, TTH etc. 
             */
            NEPOMUK_EXPORT QUrl hashAlgorithm();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#hashValue 
             * 
             * The actual value of the hash. 
             */
            NEPOMUK_EXPORT QUrl hashValue();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#height 
             * 
             * Visual content height in pixels. 
             */
            NEPOMUK_EXPORT QUrl height();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#horizontalResolution 
             * 
             * Horizontal resolution of an image (if printed). Expressed 
             * in DPI. 
             */
            NEPOMUK_EXPORT QUrl horizontalResolution();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#interlaceMode 
             * 
             * True if the image is interlaced, false if not. 
             */
            NEPOMUK_EXPORT QUrl interlaceMode();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#isPasswordProtected 
             * 
             * States if a given resource is password-protected. 
             */
            NEPOMUK_EXPORT QUrl isPasswordProtected();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#lfeChannels 
             * 
             * Number of Low Frequency Expansion (subwoofer) channels. 
             */
            NEPOMUK_EXPORT QUrl lfeChannels();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#lineCount 
             * 
             * The amount of lines in a text document 
             */
            NEPOMUK_EXPORT QUrl lineCount();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#losslessCompressionType 
             */
            NEPOMUK_EXPORT QUrl losslessCompressionType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#lossyCompressionType 
             */
            NEPOMUK_EXPORT QUrl lossyCompressionType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#occupiedSpace 
             * 
             * Occupied storage space of the filesystem. 
             */
            NEPOMUK_EXPORT QUrl occupiedSpace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#originalLocation 
             * 
             * The original location of the deleted resource. 
             */
            NEPOMUK_EXPORT QUrl originalLocation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#pageCount 
             * 
             * Number of pages. 
             */
            NEPOMUK_EXPORT QUrl pageCount();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#pageNumber 
             * 
             * Page linked by the bookmark. 
             */
            NEPOMUK_EXPORT QUrl pageNumber();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#paletteSize 
             * 
             * The number of colors defined in palette of the raster image. 
             */
            NEPOMUK_EXPORT QUrl paletteSize();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#permissions 
             * 
             * A string containing the permissions of a file. A feature common 
             * in many UNIX-like operating systems. 
             */
            NEPOMUK_EXPORT QUrl permissions();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#programmingLanguage 
             * 
             * Indicates the name of the programming language this source 
             * code file is written in. Examples might include 'C', 'C++', 
             * 'Java' etc. 
             */
            NEPOMUK_EXPORT QUrl programmingLanguage();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#rate 
             * 
             * A common superproperty for all properties specifying the media 
             * rate. Examples of subproperties may include frameRate for 
             * video and sampleRate for audio. This property is expressed 
             * in units per second. 
             */
            NEPOMUK_EXPORT QUrl rate();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#rearChannels 
             * 
             * Number of rear channels. 
             */
            NEPOMUK_EXPORT QUrl rearChannels();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#sampleCount 
             * 
             * The amount of samples in an audio clip. 
             */
            NEPOMUK_EXPORT QUrl sampleCount();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#sampleRate 
             * 
             * The amount of audio samples per second. 
             */
            NEPOMUK_EXPORT QUrl sampleRate();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#sideChannels 
             * 
             * Number of side channels 
             */
            NEPOMUK_EXPORT QUrl sideChannels();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#streamPosition 
             * 
             * Stream position of the bookmark, suitable for e.g. audio books. 
             * Expressed in milliseconds 
             */
            NEPOMUK_EXPORT QUrl streamPosition();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#supercedes 
             * 
             * States that a piece of software supercedes another piece of 
             * software. 
             */
            NEPOMUK_EXPORT QUrl supercedes();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#totalSpace 
             * 
             * Total storage space of the filesystem, which can be different 
             * from nie:contentSize because the latter includes filesystem 
             * format overhead. 
             */
            NEPOMUK_EXPORT QUrl totalSpace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#uncompressedSize 
             * 
             * Uncompressed size of the content of a compressed file. 
             */
            NEPOMUK_EXPORT QUrl uncompressedSize();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#uuid 
             * 
             * Universally unique identifier of the filesystem. In the future, 
             * this property may have its parent changed to a more generic class. 
             */
            NEPOMUK_EXPORT QUrl uuid();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#verticalResolution 
             * 
             * Vertical resolution of an Image (if printed). Expressed in 
             * DPI 
             */
            NEPOMUK_EXPORT QUrl verticalResolution();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#width 
             * 
             * Visual content width in pixels. 
             */
            NEPOMUK_EXPORT QUrl width();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#wordCount 
             * 
             * The amount of words in a text document. 
             */
            NEPOMUK_EXPORT QUrl wordCount();
        }
    }
}

#endif
