/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc2;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.net.Socket;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import openlink.util.Vector;
import openlink.util.VectorOfDouble;
import openlink.util.VectorOfFloat;
import openlink.util.VectorOfLong;
import virtuoso.jdbc2.VirtuosoBlob;
import virtuoso.jdbc2.VirtuosoConnection;
import virtuoso.jdbc2.VirtuosoException;
import virtuoso.jdbc2.VirtuosoExtendedString;
import virtuoso.jdbc2.VirtuosoFuture;
import virtuoso.jdbc2.VirtuosoOutputStream;
import virtuoso.jdbc2.VirtuosoRdfBox;

class VirtuosoInputStream
extends BufferedInputStream {
    private VirtuosoConnection connection;
    private byte[] tmp = new byte[16];
    private static final int DefaultBufferSize = 2048;
    static final int SPERDAY = 86400;
    static final int GREG_JDAYS = 577737;
    static final int GREG_LAST_DAY = 14;
    static final int GREG_FIRST_DAY = 5;
    static final int GREG_MONTH = 10;
    static final int GREG_YEAR = 1582;
    static final int DAY_LAST = 365;
    static final int DAY_MIN = 1;
    static final int MONTH_MIN = 1;
    static final int MONTH_MAX = 12;
    static final int MONTH_LAST = 31;
    static final int[] days_in_month = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public int read() throws IOException {
        int n = super.read();
        if (n == -1) {
            throw new IOException("Connection to the server lost");
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 == -1) {
            throw new IOException("Connection to the server lost");
        }
        return n3;
    }

    VirtuosoInputStream(VirtuosoConnection virtuosoConnection, InputStream inputStream) throws IOException {
        this(virtuosoConnection, inputStream, 2048);
    }

    VirtuosoInputStream(VirtuosoConnection virtuosoConnection, InputStream inputStream, int n) throws IOException {
        super(inputStream, n);
        this.connection = virtuosoConnection;
    }

    VirtuosoInputStream(VirtuosoConnection virtuosoConnection, Socket socket) throws IOException {
        this(virtuosoConnection, socket.getInputStream());
    }

    VirtuosoInputStream(VirtuosoConnection virtuosoConnection, Socket socket, int n) throws IOException {
        this(virtuosoConnection, socket.getInputStream(), n);
    }

    protected boolean isClosed() {
        return this.in == null;
    }

    protected Object read_object() throws IOException, EOFException, VirtuosoException {
        int n = this.read();
        try {
            switch (n) {
                case 180: {
                    return new Short(0);
                }
                case 204: {
                    return null;
                }
                case 193: 
                case 196: {
                    int n2 = this.readint();
                    Object[] objectArray = new Object[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        objectArray[n3] = this.read_object();
                        ++n3;
                    }
                    Vector vector = new Vector(objectArray);
                    return vector;
                }
                case 209: {
                    int n4 = this.readint();
                    Object[] objectArray = new Object[n4];
                    int n5 = 0;
                    while (n5 < n4) {
                        objectArray[n5] = new Long(this.readlongint());
                        ++n5;
                    }
                    VectorOfLong vectorOfLong = new VectorOfLong(objectArray);
                    return vectorOfLong;
                }
                case 194: {
                    int n6 = this.readint();
                    Object[] objectArray = new Object[n6];
                    int n7 = 0;
                    while (n7 < n6) {
                        objectArray[n7] = new Long(this.readlongint());
                        ++n7;
                    }
                    VectorOfLong vectorOfLong = new VectorOfLong(objectArray);
                    return vectorOfLong;
                }
                case 195: {
                    int n8 = this.readint();
                    Object[] objectArray = new Object[n8];
                    int n9 = 0;
                    while (n9 < n8) {
                        objectArray[n9] = new Double(this.readdouble());
                        ++n9;
                    }
                    VectorOfDouble vectorOfDouble = new VectorOfDouble(objectArray);
                    return vectorOfDouble;
                }
                case 202: {
                    int n10 = this.readint();
                    Object[] objectArray = new Object[n10];
                    int n11 = 0;
                    while (n11 < n10) {
                        objectArray[n11] = new Float(this.readfloat());
                        ++n11;
                    }
                    VectorOfFloat vectorOfFloat = new VectorOfFloat(objectArray);
                    return vectorOfFloat;
                }
                case 226: {
                    int n12 = this.readlongint();
                    byte[] byArray = new byte[n12];
                    int n13 = this.read(byArray, 0, n12);
                    while (n13 != n12) {
                        n13 += this.read(byArray, n13, n12 - n13);
                    }
                    return this.convByte2UTF(byArray);
                }
                case 225: {
                    int n14 = this.readshortint();
                    byte[] byArray = new byte[n14];
                    int n15 = this.read(byArray, 0, n14);
                    while (n15 != n14) {
                        n15 += this.read(byArray, n15, n14 - n15);
                    }
                    return this.convByte2UTF(byArray);
                }
                case 182: 
                case 183: 
                case 187: {
                    int n16 = this.readlongint();
                    byte[] byArray = new byte[n16];
                    int n17 = this.read(byArray, 0, n16);
                    while (n17 != n16) {
                        n17 += this.read(byArray, n17, n16 - n17);
                    }
                    if (this.connection.charset_utf8) {
                        return this.convByte2UTF(byArray);
                    }
                    return this.convByte2Ascii(byArray);
                }
                case 207: {
                    int n18 = this.readlongint();
                    Object object = this.read_object();
                    VirtuosoExtendedString virtuosoExtendedString = new VirtuosoExtendedString((String)object, n18);
                    return virtuosoExtendedString;
                }
                case 223: {
                    int n19 = this.readlongint();
                    byte[] byArray = new byte[n19];
                    int n20 = this.read(byArray, 0, n19);
                    while (n20 != n19) {
                        n20 += this.read(byArray, n20, n19 - n20);
                    }
                    return byArray;
                }
                case 181: 
                case 184: 
                case 186: {
                    int n21 = this.readshortint();
                    byte[] byArray = new byte[n21];
                    int n22 = this.read(byArray, 0, n21);
                    while (n22 != n21) {
                        n22 += this.read(byArray, n22, n21 - n22);
                    }
                    if (this.connection.charset_utf8) {
                        return this.convByte2UTF(byArray);
                    }
                    return this.convByte2Ascii(byArray);
                }
                case 222: {
                    int n23 = this.readshortint();
                    byte[] byArray = new byte[n23];
                    int n24 = this.read(byArray, 0, n23);
                    while (n24 != n23) {
                        n24 += this.read(byArray, n24, n23 - n24);
                    }
                    return byArray;
                }
                case 190: {
                    Float f = new Float(this.readfloat());
                    return f;
                }
                case 191: {
                    Double d = new Double(this.readdouble());
                    return d;
                }
                case 188: {
                    int n25 = this.readshortint();
                    if (n25 > 127) {
                        n25 -= 256;
                    }
                    Short s = new Short((short)n25);
                    return s;
                }
                case 189: {
                    Integer n26 = new Integer(this.readlongint());
                    return n26;
                }
                case 128: 
                case 129: 
                case 208: 
                case 210: 
                case 211: {
                    Object object = this.readDate(n);
                    return object;
                }
                case 126: 
                case 133: {
                    VirtuosoBlob virtuosoBlob = new VirtuosoBlob(this.connection, this.readlongint(), this.readlongint(), this.readlongint(), this.readlongint(), this.readlongint(), this.readlongint(), this.readlongint(), this.read_object(), n);
                    return virtuosoBlob;
                }
                case 219: {
                    BigDecimal bigDecimal = this.readNumeric();
                    return bigDecimal;
                }
                case 254: {
                    Object object = this.readObject();
                    return object;
                }
                case 185: {
                    int n27 = this.read();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    while (true) {
                        int n28;
                        int n29;
                        if ((n29 = this.read()) != 182 && n29 != 181) {
                            throw new VirtuosoException("Invalid data (tag=" + n29 + ") in deserializing a string session", "42000", -9);
                        }
                        int n30 = n28 = n29 == 182 ? this.readlongint() : this.read();
                        if (n28 <= 0) break;
                        byte[] byArray = new byte[n28];
                        int n31 = this.read(byArray, 0, n28);
                        while (n31 != n28) {
                            n31 += this.read(byArray, n31, n28 - n31);
                        }
                        byteArrayOutputStream.write(byArray, 0, n28);
                    }
                    String string = byteArrayOutputStream.toString((n27 & 1) != 0 ? "UTF-8" : "8859_1");
                    return string;
                }
                case 243: {
                    Integer n32 = new Integer(this.readlongint());
                    return n32;
                }
                case 244: 
                case 247: {
                    Long l = new Long(this.readlong());
                    return l;
                }
                case 246: {
                    VirtuosoRdfBox virtuosoRdfBox = this.readRdfBox();
                    return virtuosoRdfBox;
                }
            }
            throw new VirtuosoException("Tag " + n + " not defined.", -9);
        }
        catch (ClassCastException classCastException) {
            if (VirtuosoFuture.rpc_log != null) {
                PrintStream printStream = VirtuosoFuture.rpc_log;
                synchronized (printStream) {
                    VirtuosoFuture.rpc_log.println("(conn " + this.connection.hashCode() + ") **** runtime " + classCastException.getClass().getName() + " encountered while reading tag " + n);
                    classCastException.printStackTrace(VirtuosoFuture.rpc_log);
                }
            }
            throw new Error(classCastException.getClass().getName() + ":" + classCastException.getMessage());
        }
    }

    private final String convByte2UTF(byte[] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            n = byArray[n3] & 0xFF;
            if (n > 127) break;
            ++n3;
            cArray[n4++] = (char)n;
        }
        while (n3 < n2) {
            n = byArray[n3] & 0xFF;
            switch (n >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n3;
                    cArray[n4++] = (char)n;
                    break;
                }
                case 12: 
                case 13: {
                    if ((n3 += 2) > n2) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte by = byArray[n3 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + n3);
                    }
                    cArray[n4++] = (char)((n & 0x1F) << 6 | by & 0x3F);
                    break;
                }
                case 14: {
                    if ((n3 += 3) > n2) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte by = byArray[n3 - 2];
                    byte by2 = byArray[n3 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (n3 - 1));
                    }
                    cArray[n4++] = (char)((n & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException("malformed input around byte " + n3);
                }
            }
        }
        return new String(cArray, 0, n4);
    }

    private final String convByte2Ascii(byte[] byArray) throws IOException {
        int n = byArray.length;
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (char)(byArray[n2] & 0xFF);
            ++n2;
        }
        return new String(cArray, 0, n);
    }

    private int readint() throws IOException {
        return this.read() == 188 ? this.readshortint() : this.readlongint();
    }

    private int readshortint() throws IOException {
        return this.read();
    }

    private short readshort() throws IOException {
        int n = this.read(this.tmp, 0, 2);
        while (n != 2) {
            n += this.read(this.tmp, n, 2 - n);
        }
        int n2 = (this.tmp[0] & 0xFF) << 8;
        return (short)(n2 | this.tmp[1] & 0xFF);
    }

    private int readlongint() throws IOException {
        int n = this.read(this.tmp, 0, 4);
        while (n != 4) {
            n += this.read(this.tmp, n, 4 - n);
        }
        int n2 = (this.tmp[0] & 0xFF) << 24;
        n2 |= (this.tmp[1] & 0xFF) << 16;
        return (n2 |= (this.tmp[2] & 0xFF) << 8) | this.tmp[3] & 0xFF;
    }

    private long readlong() throws IOException {
        int n = this.read(this.tmp, 0, 8);
        while (n != 8) {
            n += this.read(this.tmp, n, 8 - n);
        }
        long l = ((long)this.tmp[0] & 0xFFL) << 56;
        l |= ((long)this.tmp[1] & 0xFFL) << 48;
        l |= ((long)this.tmp[2] & 0xFFL) << 40;
        l |= ((long)this.tmp[3] & 0xFFL) << 32;
        l |= ((long)this.tmp[4] & 0xFFL) << 24;
        l |= ((long)this.tmp[5] & 0xFFL) << 16;
        return (l |= ((long)this.tmp[6] & 0xFFL) << 8) | (long)this.tmp[7] & 0xFFL;
    }

    private float readfloat() throws IOException {
        return Float.intBitsToFloat(this.readlongint());
    }

    private double readdouble() throws IOException {
        return Double.longBitsToDouble(this.readlong());
    }

    private BigDecimal readNumeric() throws IOException, VirtuosoException {
        int n = this.readshortint();
        int n2 = 0;
        byte[] byArray = new byte[n + 2];
        byte[] byArray2 = new byte[n << 1];
        if (byArray != null && byArray2 != null) {
            byArray[0] = -37;
            byArray[1] = (byte)n;
            int n3 = this.read(byArray, 2, n);
            while (n3 != n) {
                n3 += this.read(byArray, n3 + 2, n - n3);
            }
        } else {
            return null;
        }
        byArray2[0] = 48;
        int n4 = byArray[3] << 1;
        int n5 = byArray[1] - byArray[3] - 2 << 1;
        boolean bl = (byArray[2] & 1) == 1;
        boolean bl2 = (byArray[2] & 0x18) == 24;
        switch (byArray[2] & 0x18) {
            case 8: {
                return new BigDecimal(Double.NaN);
            }
            case 16: {
                if (bl) {
                    return new BigDecimal(Double.NEGATIVE_INFINITY);
                }
                return new BigDecimal(Double.POSITIVE_INFINITY);
            }
        }
        int n6 = 4;
        int n7 = 2 + byArray[1];
        if ((byArray[2] & 4) == 4) {
            byArray2[n2++] = (byte)((byArray[n6++] & 0xF) + 48);
            --n4;
        }
        if ((byArray[2] & 2) == 2) {
            --n5;
        }
        while (n6 < n7) {
            if (n2 == n4) {
                byArray2[n2++] = 46;
            }
            byArray2[n2++] = (byte)((byArray[n6] >> 4 & 0xF) + 48);
            if (n2 == n4) {
                byArray2[n2++] = 46;
            }
            byArray2[n2++] = (byte)((byArray[n6++] & 0xF) + 48);
        }
        BigDecimal bigDecimal = new BigDecimal((bl ? "-" : "") + new String(byArray2, 0, n6 != 4 ? n2 - ((byArray[2] & 2) == 2 ? 1 : 0) : 1));
        return bigDecimal;
    }

    private VirtuosoRdfBox readRdfBox() throws IOException, VirtuosoException {
        Object object;
        int n = this.read();
        boolean bl = false;
        long l = 0L;
        if (0 != (n & 0x10)) {
            throw new VirtuosoException("Invalid rdf box received", "42000", -17);
        }
        if (0 != (n & 0x40)) {
            int n2 = this.readshortint();
            byte[] byArray = new byte[n2];
            int n3 = this.read(byArray, 0, n2);
            while (n3 != n2) {
                n3 += this.read(byArray, n3, n2 - n3);
            }
            object = this.connection.charset_utf8 ? this.convByte2UTF(byArray) : this.convByte2Ascii(byArray);
        } else {
            object = this.read_object();
        }
        if (0 != (n & 1)) {
            l = 0 != (n & 0x20) ? this.readlong() : (long)this.readlongint();
        }
        if (0 != (n & 2)) {
            bl = true;
        }
        short s = 0 != (n & 8) ? (short)this.readshort() : (short)257;
        short s2 = 0 != (n & 4) ? (short)this.readshort() : (short)257;
        VirtuosoRdfBox virtuosoRdfBox = new VirtuosoRdfBox(this.connection, object, bl, s, s2, l);
        return virtuosoRdfBox;
    }

    private Object readObject() throws IOException, VirtuosoException {
        int n = this.readlongint();
        Object object = this.read_object();
        if (object instanceof String) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes("8859_1"));
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                object = objectInputStream.readObject();
            }
            catch (Exception exception) {
                object = null;
            }
        }
        return object;
    }

    private Object readDate(int n) throws IOException {
        int n2;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n3 = this.read() << 16 | this.read() << 8 | this.read();
        int n4 = this.read();
        int n5 = this.read();
        int n6 = n5 >> 2;
        int n7 = (n5 & 3) << 4;
        n5 = this.read();
        int n8 = n7 | n5 >> 4;
        int n9 = (n5 & 0xF) << 16 | this.read() << 8 | this.read();
        int[] nArray = new int[]{this.read(), this.read()};
        int n10 = (nArray[0] & 7) << 8 | nArray[1];
        int n11 = nArray[0] >> 5;
        if ((nArray[0] & 4) != 0) {
            n2 = nArray[0] & 7;
            n2 |= 0xF8;
        } else {
            n2 = nArray[0] & 3;
        }
        n10 = n2 << 8 | nArray[1];
        if (n10 > Short.MAX_VALUE) {
            n10 -= 65536;
        }
        if (n10 != 0) {
            int n12 = VirtuosoInputStream.time_to_sec(0, n4, n6, n8);
            if ((n12 += 60 * n10) < 0) {
                n3 -= 1 + -n12 / 86400;
                if ((n12 %= 86400) == 0) {
                    ++n3;
                }
                n12 = 86400 + n12;
            } else {
                n3 += n12 / 86400;
                n12 %= 86400;
            }
            int n13 = n12 / 86400;
            n4 = (n12 - n13 * 86400) / 3600;
            n6 = (n12 - n13 * 86400 - n4 * 60 * 60) / 60;
            n8 = n12 % 60;
        }
        VirtuosoInputStream.num2date(n3, gregorianCalendar);
        gregorianCalendar.set(11, n4);
        gregorianCalendar.set(12, n6);
        gregorianCalendar.set(13, n8);
        switch (n11) {
            case 2: {
                return new Date(gregorianCalendar.getTime().getTime());
            }
            case 3: {
                return new Time(gregorianCalendar.getTime().getTime());
            }
        }
        Timestamp timestamp = new Timestamp(gregorianCalendar.getTime().getTime());
        timestamp.setNanos(n9 * 1000);
        return timestamp;
    }

    static int time_to_sec(int n, int n2, int n3, int n4) {
        return n * 86400 + n2 * 60 * 60 + n3 * 60 + n4;
    }

    public static void num2date(int n, Calendar calendar) {
        double d;
        int n2;
        if (n > 577737) {
            n += 10;
        }
        int n3 = (double)(n2 = (int)(d = (double)n / 365.25)) != d ? n2 + 1 : n2--;
        if (n > 577737) {
            n -= n3 / 400 - 3;
            d = (double)(n += n3 / 100 - 15) / 365.25;
            n2 = (int)d;
            if ((n3 = (double)n2 != d ? n2 + 1 : n2--) % 400 != 0 && n3 % 100 == 0) {
                --n;
            }
        }
        n2 = n - (int)((double)n2 * 365.25);
        if (n3 > 1582 && n3 % 400 != 0 && n3 % 100 == 0 && n2 < n3 / 100 - 15 - (n3 / 400 - 3)) {
            ++n2;
        }
        calendar.set(1, n3);
        VirtuosoInputStream.yearday2date(n2, VirtuosoOutputStream.days_in_february(n3) == 29, calendar);
    }

    static void yearday2date(int n, boolean bl, Calendar calendar) {
        boolean bl2;
        if (n > 365 + (bl ? 1 : 0) || n < 1) {
            return;
        }
        boolean bl3 = bl2 = bl && n > 59;
        if (bl2) {
            --n;
        }
        int n2 = 1;
        while (n2 < 12) {
            if ((n -= days_in_month[n2 - 1]) <= 0) {
                n += days_in_month[n2 - 1];
                break;
            }
            ++n2;
        }
        int n3 = n2;
        int n4 = n;
        if (bl2 && n3 == 2 && n4 == 28) {
            ++n4;
        }
        calendar.set(2, n3 - 1);
        calendar.set(5, n4);
    }
}

