# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

"""
setuptools script for the plugin.
"""

import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean, build_po


packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean, build_po=build_po)


setup(name='elisa-plugin-youtube',
    version='0.11',
    description='YouTube videos',
    long_description='Browse, search and play YouTube videos.',
    license='GPLv3',
    author='Moovida Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    install_requires=['elisa-plugin-poblesec'],
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.conf', 'icons/*'],
                  'elisa.plugins.youtube.i18n': ['*.po', '*/LC_MESSAGES/*.mo', '*.pot'],
                  },
    entry_points="""\
    [elisa.plugins.search.searchers]
    YoutubeSearcher = elisa.plugins.youtube.searcher:YoutubeSearcher

    [elisa.core.components.resource_provider]
    YoutubeResourceProvider = elisa.plugins.youtube.resource_provider:YoutubeResourceProvider

    [elisa.core.plugin_registry]
    use = elisa.plugins.youtube.controller:use_me_hook
    """,
    controller_mappings=[('/poblesec/youtube',
                          'elisa.plugins.youtube.controller:YoutubeListSwitcherController'),
                         ('/poblesec/search/results/YoutubeSearcher/videos',
                          'elisa.plugins.youtube.controller:YoutubeListSwitcherController'),
                         ],
    decorator_mappings=[('/poblesec/video/internet',
                         'elisa.plugins.youtube.controller:youtube_decorator'),
                        ('/poblesec/search/videos',
                         'elisa.plugins.youtube.searcher:video_search_result_decorator'),
                        ],
    cmdclass=cmdclass)
