/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;

public abstract class TransformerFactory {
    protected TransformerFactory() {
    }

    public static TransformerFactory newInstance() throws TransformerFactoryConfigurationError {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = TransformerFactory.class.getClassLoader();
        }
        String className = null;
        int count = 0;
        do {
            if ((className = TransformerFactory.getFactoryClassName(loader, count++)) == null) continue;
            try {
                Class<?> t = loader != null ? loader.loadClass(className) : Class.forName(className);
                return (TransformerFactory)t.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                className = null;
            }
            catch (Exception e) {
                throw new TransformerFactoryConfigurationError(e, "error instantiating class " + className);
            }
        } while (className == null && count < 3);
        try {
            Class<?> t = Class.forName("gnu.xml.transform.TransformerFactoryImpl");
            return (TransformerFactory)t.newInstance();
        }
        catch (Exception e) {
            throw new TransformerFactoryConfigurationError(e);
        }
    }

    private static String getFactoryClassName(ClassLoader loader, int attempt) {
        switch (attempt) {
            case 0: {
                return System.getProperty("javax.xml.transform.TransformerFactory");
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "jaxp.properties");
                    FileInputStream in = new FileInputStream(file);
                    Properties props = new Properties();
                    props.load(in);
                    ((InputStream)in).close();
                    return props.getProperty("javax.xml.transform.TransformerFactory");
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream in;
                    String serviceKey = "/META-INF/services/javax.xml.transform.TransformerFactory";
                    InputStream inputStream = in = loader != null ? loader.getResourceAsStream(serviceKey) : TransformerFactory.class.getResourceAsStream(serviceKey);
                    if (in != null) {
                        BufferedReader r = new BufferedReader(new InputStreamReader(in));
                        String ret = r.readLine();
                        r.close();
                        return ret;
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        return null;
    }

    public abstract Transformer newTransformer(Source var1) throws TransformerConfigurationException;

    public abstract Transformer newTransformer() throws TransformerConfigurationException;

    public abstract Templates newTemplates(Source var1) throws TransformerConfigurationException;

    public abstract Source getAssociatedStylesheet(Source var1, String var2, String var3, String var4) throws TransformerConfigurationException;

    public abstract void setURIResolver(URIResolver var1);

    public abstract URIResolver getURIResolver();

    public abstract void setFeature(String var1, boolean var2) throws TransformerConfigurationException;

    public abstract boolean getFeature(String var1);

    public abstract void setAttribute(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getAttribute(String var1) throws IllegalArgumentException;

    public abstract void setErrorListener(ErrorListener var1) throws IllegalArgumentException;

    public abstract ErrorListener getErrorListener();
}

