/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class MetalTabbedPaneUI
extends BasicTabbedPaneUI {
    protected int minTabWidth;
    protected Color selectColor;
    protected Color selectHighlight;
    protected Color tabAreaBackground;
    private Graphics hg;
    private boolean tabsOpaque;

    public static ComponentUI createUI(JComponent component) {
        return new MetalTabbedPaneUI();
    }

    protected LayoutManager createLayoutManager() {
        return this.tabPane.getTabLayoutPolicy() == 0 ? new TabbedPaneLayout() : super.createLayoutManager();
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int bottom = y + h - 1;
        int right = x + w - 1;
        switch (tabPlacement) {
            case 2: {
                this.paintLeftTabBorder(tabIndex, g, x, y, w, h, bottom, right, isSelected);
                break;
            }
            case 3: {
                this.paintBottomTabBorder(tabIndex, g, x, y, w, h, bottom, right, isSelected);
                break;
            }
            case 4: {
                this.paintRightTabBorder(tabIndex, g, x, y, w, h, bottom, right, isSelected);
                break;
            }
            default: {
                this.paintTopTabBorder(tabIndex, g, x, y, w, h, bottom, right, isSelected);
            }
        }
    }

    protected void paintTopTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int tabCount = this.tabPane.getTabCount();
        int currentRun = this.getRunForTab(tabCount, tabIndex);
        int right = w - 1;
        int bottom = h - 1;
        if (this.shouldFillGap(currentRun, tabIndex, x, y)) {
            g.translate(x, y);
            g.setColor(this.getColorForGap(currentRun, x, y + 1));
            g.fillRect(1, 0, 5, 3);
            g.fillRect(1, 3, 2, 2);
            g.translate(-x, -y);
        }
        g.translate(x, y);
        boolean isOcean = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme;
        Color oceanSelectedBorder = UIManager.getColor("TabbedPane.borderHightlightColor");
        if (isOcean && isSelected) {
            g.setColor(oceanSelectedBorder);
        } else {
            g.setColor(this.darkShadow);
        }
        g.drawLine(1, 5, 6, 0);
        g.drawLine(6, 0, right, 0);
        int lastIndex = this.lastTabInRun(tabCount, currentRun);
        if (tabIndex == lastIndex) {
            g.drawLine(right, 1, right, bottom);
        }
        int selectedIndex = this.tabPane.getSelectedIndex();
        if (isOcean && tabIndex - 1 == selectedIndex && currentRun == this.getRunForTab(tabCount, selectedIndex)) {
            g.setColor(oceanSelectedBorder);
        }
        if (tabIndex != this.tabRuns[this.runCount - 1]) {
            if (isOcean && isSelected) {
                g.drawLine(0, 6, 0, bottom);
                g.setColor(this.darkShadow);
                g.drawLine(0, 0, 0, 5);
            } else {
                g.drawLine(0, 0, 0, bottom);
            }
        } else {
            g.drawLine(0, 6, 0, bottom);
        }
        g.setColor(isSelected ? this.selectHighlight : this.highlight);
        g.drawLine(1, 6, 6, 1);
        g.drawLine(6, 1, right, 1);
        g.drawLine(1, 6, 1, bottom);
        int firstIndex = this.tabRuns[currentRun];
        if (tabIndex == firstIndex && tabIndex != this.tabRuns[this.runCount - 1]) {
            if (this.tabPane.getSelectedIndex() == this.tabRuns[currentRun + 1]) {
                g.setColor(this.selectHighlight);
            } else {
                g.setColor(this.highlight);
            }
            g.drawLine(1, 0, 1, 4);
        }
        g.translate(-x, -y);
    }

    protected void paintLeftTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        boolean isOcean;
        g.translate(x, y);
        int bottom = h - 1;
        int right = w - 1;
        int tabCount = this.tabPane.getTabCount();
        int currentRun = this.getRunForTab(tabCount, tabIndex);
        int firstIndex = this.tabRuns[currentRun];
        if (tabIndex != firstIndex && tabIndex > 0 && this.tabsOpaque) {
            Color c = this.tabPane.getSelectedIndex() == tabIndex - 1 ? this.selectColor : this.getUnselectedBackground(tabIndex - 1);
            g.setColor(c);
            g.fillRect(2, 0, 4, 3);
            g.drawLine(2, 3, 2, 3);
        }
        if (isOcean = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
            g.setColor(isSelected ? this.selectHighlight : MetalLookAndFeel.getWhite());
        } else {
            g.setColor(isSelected ? this.selectHighlight : this.highlight);
        }
        g.drawLine(1, 6, 6, 1);
        g.drawLine(1, 6, 1, bottom);
        g.drawLine(6, 1, right, 1);
        if (tabIndex != firstIndex) {
            if (isOcean) {
                g.setColor(MetalLookAndFeel.getWhite());
            }
            g.drawLine(1, 0, 1, 4);
        }
        Color oceanSelectedBorder = UIManager.getColor("TabbedPane.borderHightlightColor");
        if (isOcean && isSelected) {
            g.setColor(oceanSelectedBorder);
        } else {
            g.setColor(this.darkShadow);
        }
        g.drawLine(1, 5, 6, 0);
        g.drawLine(6, 0, right, 0);
        int lastIndex = this.lastTabInRun(tabCount, currentRun);
        if (tabIndex == lastIndex) {
            g.drawLine(0, bottom, right, bottom);
        }
        if (isOcean) {
            if (this.tabPane.getSelectedIndex() == tabIndex - 1) {
                g.drawLine(0, 6, 0, bottom);
                if (tabIndex != firstIndex) {
                    g.setColor(oceanSelectedBorder);
                    g.drawLine(0, 0, 0, 5);
                }
            } else if (isSelected) {
                g.drawLine(0, 5, 0, bottom);
                if (tabIndex != firstIndex) {
                    g.setColor(this.darkShadow);
                    g.drawLine(0, 0, 0, 5);
                }
            } else if (tabIndex != firstIndex) {
                g.drawLine(0, 0, 0, bottom);
            } else {
                g.drawLine(0, 6, 0, bottom);
            }
        } else if (tabIndex != firstIndex) {
            g.drawLine(0, 0, 0, bottom);
        } else {
            g.drawLine(0, 6, 0, bottom);
        }
        g.translate(-x, -y);
    }

    protected void paintRightTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        g.translate(x, y);
        int bottom = h - 1;
        int right = w - 1;
        int tabCount = this.tabPane.getTabCount();
        int currentRun = this.getRunForTab(tabCount, tabIndex);
        int firstIndex = this.tabRuns[currentRun];
        if (tabIndex != firstIndex && tabIndex > 0 && this.tabsOpaque) {
            Color c = this.tabPane.getSelectedIndex() == tabIndex - 1 ? this.selectColor : this.getUnselectedBackground(tabIndex - 1);
            g.setColor(c);
            g.fillRect(right - 5, 0, 5, 3);
            g.fillRect(right - 2, 3, 2, 2);
        }
        g.setColor(isSelected ? this.selectHighlight : this.highlight);
        g.drawLine(right - 6, 1, right - 1, 6);
        g.drawLine(0, 1, right - 6, 1);
        if (!isSelected) {
            g.drawLine(0, 1, 0, bottom);
        }
        boolean isOcean = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme;
        Color oceanSelectedBorder = UIManager.getColor("TabbedPane.borderHightlightColor");
        if (isOcean && isSelected) {
            g.setColor(oceanSelectedBorder);
        } else {
            g.setColor(this.darkShadow);
        }
        int lastIndex = this.lastTabInRun(tabCount, currentRun);
        if (tabIndex == lastIndex) {
            g.drawLine(0, bottom, right, bottom);
        }
        if (isOcean && this.tabPane.getSelectedIndex() == tabIndex - 1) {
            g.setColor(oceanSelectedBorder);
        }
        g.drawLine(right - 6, 0, right, 6);
        g.drawLine(0, 0, right - 6, 0);
        if (isOcean && isSelected) {
            g.drawLine(right, 6, right, bottom);
            if (tabIndex != firstIndex) {
                g.setColor(this.darkShadow);
                g.drawLine(right, 0, right, 5);
            }
        } else if (isOcean && this.tabPane.getSelectedIndex() == tabIndex - 1) {
            if (tabIndex != firstIndex) {
                g.setColor(oceanSelectedBorder);
                g.drawLine(right, 0, right, 6);
            }
            g.setColor(this.darkShadow);
            g.drawLine(right, 7, right, bottom);
        } else if (tabIndex != firstIndex) {
            g.drawLine(right, 0, right, bottom);
        } else {
            g.drawLine(right, 6, right, bottom);
        }
        g.translate(-x, -y);
    }

    protected void paintBottomTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int bottom = h - 1;
        int right = w - 1;
        int tabCount = this.tabPane.getTabCount();
        int currentRun = this.getRunForTab(tabCount, tabIndex);
        if (this.shouldFillGap(currentRun, tabIndex, x, y)) {
            g.translate(x, y);
            g.setColor(this.getColorForGap(currentRun, x, y));
            g.fillRect(1, bottom - 4, 3, 5);
            g.fillRect(4, bottom - 1, 2, 2);
            g.translate(-x, -y);
        }
        g.translate(x, y);
        boolean isOcean = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme;
        Color oceanSelectedBorder = UIManager.getColor("TabbedPane.borderHightlightColor");
        if (isOcean && isSelected) {
            g.setColor(oceanSelectedBorder);
        } else {
            g.setColor(this.darkShadow);
        }
        g.drawLine(1, bottom - 5, 6, bottom);
        g.drawLine(6, bottom, right, bottom);
        int lastIndex = this.lastTabInRun(tabCount, currentRun);
        if (tabIndex == lastIndex) {
            g.drawLine(right, 0, right, bottom);
        }
        if (isOcean && isSelected) {
            g.drawLine(0, 0, 0, bottom - 5);
            if (tabIndex != this.tabRuns[this.runCount - 1]) {
                g.setColor(this.darkShadow);
                g.drawLine(0, bottom - 5, 0, bottom);
            }
        } else {
            if (isOcean && tabIndex == this.tabPane.getSelectedIndex() + 1) {
                g.setColor(oceanSelectedBorder);
            }
            if (tabIndex != this.tabRuns[this.runCount - 1]) {
                g.drawLine(0, 0, 0, bottom);
            } else {
                g.drawLine(0, 0, 0, bottom - 6);
            }
        }
        g.setColor(isSelected ? this.selectHighlight : this.highlight);
        g.drawLine(1, bottom - 6, 6, bottom - 1);
        g.drawLine(1, 0, 1, bottom - 6);
        int firstIndex = this.tabRuns[currentRun];
        if (tabIndex == firstIndex && tabIndex != this.tabRuns[this.runCount - 1]) {
            if (this.tabPane.getSelectedIndex() == this.tabRuns[currentRun + 1]) {
                g.setColor(this.selectHighlight);
            } else {
                g.setColor(this.highlight);
            }
            g.drawLine(1, bottom - 4, 1, bottom);
        }
        g.translate(-x, -y);
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (isSelected) {
            g.setColor(this.selectColor);
        } else {
            g.setColor(this.getUnselectedBackground(tabIndex));
        }
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x + 5, y + 1, w - 5, h - 1);
                g.fillRect(x + 2, y + 4, 3, h - 4);
                break;
            }
            case 3: {
                g.fillRect(x + 2, y, w - 2, h - 3);
                g.fillRect(x + 5, y + h - 4, w - 5, 3);
                break;
            }
            case 4: {
                g.fillRect(x, y + 1, w - 4, h - 1);
                g.fillRect(x + w - 4, y + 5, 3, h - 5);
                break;
            }
            default: {
                g.fillRect(x + 4, y + 2, w - 4, h - 2);
                g.fillRect(x + 2, y + 5, 2, h - 5);
            }
        }
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (this.tabPane.hasFocus() && isSelected) {
            Rectangle rect = rects[tabIndex];
            g.setColor(this.focus);
            g.translate(rect.x, rect.y);
            switch (tabPlacement) {
                case 2: {
                    g.drawLine(7, 2, rect.width - 2, 2);
                    g.drawLine(rect.width - 1, 2, rect.width - 1, rect.height - 3);
                    g.drawLine(rect.width - 2, rect.height - 2, 3, rect.height - 2);
                    g.drawLine(2, rect.height - 3, 2, 7);
                    g.drawLine(2, 6, 6, 2);
                    break;
                }
                case 4: {
                    g.drawLine(1, 2, rect.width - 8, 2);
                    g.drawLine(rect.width - 7, 2, rect.width - 3, 6);
                    g.drawLine(rect.width - 3, 7, rect.width - 3, rect.height - 3);
                    g.drawLine(rect.width - 3, rect.height - 2, 2, rect.height - 2);
                    g.drawLine(1, rect.height - 2, 1, 2);
                    break;
                }
                case 3: {
                    g.drawLine(2, 1, rect.width - 2, 1);
                    g.drawLine(rect.width - 1, 2, rect.width - 1, rect.height - 3);
                    g.drawLine(7, rect.height - 3, rect.width - 2, rect.height - 3);
                    g.drawLine(6, rect.height - 3, 2, rect.height - 7);
                    g.drawLine(2, rect.height - 8, 2, 2);
                    break;
                }
                default: {
                    g.drawLine(6, 2, rect.width - 2, 2);
                    g.drawLine(rect.width - 1, 2, rect.width - 1, rect.height - 3);
                    g.drawLine(3, rect.height - 3, rect.width - 2, rect.height - 3);
                    g.drawLine(2, rect.height - 3, 2, 7);
                    g.drawLine(2, 6, 6, 2);
                }
            }
            g.translate(-rect.x, -rect.y);
        }
    }

    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return run < this.runCount - 1;
    }

    protected void installDefaults() {
        super.installDefaults();
        this.selectColor = UIManager.getColor("TabbedPane.selected");
        this.selectHighlight = UIManager.getColor("TabbedPane.selectHighlight");
        this.tabAreaBackground = UIManager.getColor("TabbedPane.tabAreaBackground");
        this.tabsOpaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
        this.minTabWidth = 0;
    }

    protected Color getColorForGap(int currentRun, int x, int y) {
        int index = this.tabForCoordinate(this.tabPane, x, y);
        int selected = this.tabPane.getSelectedIndex();
        if (selected == index) {
            return this.selectColor;
        }
        return this.tabAreaBackground;
    }

    protected boolean shouldFillGap(int currentRun, int tabIndex, int x, int y) {
        return false;
    }

    protected void paintHighlightBelowTab() {
        int selected = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        Rectangle bounds = this.getTabBounds(this.tabPane, selected);
        this.hg.setColor(this.selectColor);
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        if (tabPlacement == 1) {
            this.hg.fillRect(x, y + h - 2, w, 30);
        } else if (tabPlacement == 2) {
            this.hg.fillRect(x + w - 1, y, 20, h);
        } else if (tabPlacement == 3) {
            this.hg.fillRect(x, y - h + 2, w, 30);
        } else if (tabPlacement == 4) {
            this.hg.fillRect(x - 18, y, 20, h);
        } else {
            throw new AssertionError((Object)"Unrecognised 'tabPlacement' argument.");
        }
        this.hg = null;
    }

    protected boolean shouldRotateTabRuns(int tabPlacement, int selectedRun) {
        return false;
    }

    protected int calculateMaxTabHeight(int tabPlacement) {
        return super.calculateMaxTabHeight(tabPlacement);
    }

    protected int getTabRunOverlay(int tabPlacement) {
        int overlay = 0;
        if (tabPlacement == 2 || tabPlacement == 4) {
            this.calculateMaxTabHeight(tabPlacement);
            overlay = this.maxTabHeight / 2;
        }
        return overlay;
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle rect;
        Color oceanSelectedBorder = UIManager.getColor("TabbedPane.borderHightlightColor");
        boolean isOcean = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme;
        if (isOcean) {
            g.setColor(oceanSelectedBorder);
        } else {
            g.setColor(this.selectHighlight);
        }
        Rectangle rectangle = rect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (tabPlacement != 1 || selectedIndex < 0 || rect.y + rect.height + 1 < y || rect.x < x || rect.x > x + w) {
            g.drawLine(x, y, x + w - 2, y);
            if (isOcean && tabPlacement == 1) {
                g.setColor(MetalLookAndFeel.getWhite());
                g.drawLine(x, y + 1, x + w - 2, y + 1);
            }
        } else {
            boolean isLast = this.isLastTabInRun(selectedIndex);
            if (isLast) {
                g.drawLine(x, y, rect.x + 1, y);
            } else {
                g.drawLine(x, y, rect.x, y);
            }
            int right = x + w - 1;
            if (rect.x + rect.width < right - 1) {
                if (isLast) {
                    g.drawLine(rect.x + rect.width - 1, y, right - 1, y);
                } else {
                    g.drawLine(rect.x + rect.width, y, right - 1, y);
                }
            } else {
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, y, x + w - 2, y);
            }
            if (isOcean) {
                g.setColor(MetalLookAndFeel.getWhite());
                if (isLast) {
                    g.drawLine(x, y + 1, rect.x + 1, y + 1);
                } else {
                    g.drawLine(x, y + 1, rect.x, y + 1);
                }
                if (rect.x + rect.width < right - 1) {
                    if (isLast) {
                        g.drawLine(rect.x + rect.width - 1, y + 1, right - 1, y + 1);
                    } else {
                        g.drawLine(rect.x + rect.width, y + 1, right - 1, y + 1);
                    }
                } else {
                    g.setColor(this.shadow);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                }
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.darkShadow);
        Rectangle rect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        boolean isOcean = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme;
        Color oceanSelectedBorder = UIManager.getColor("TabbedPane.borderHightlightColor");
        if (tabPlacement != 3 || selectedIndex < 0 || rect.y - 1 > h || rect.x < x || rect.x > x + w) {
            if (isOcean && tabPlacement == 3) {
                g.setColor(oceanSelectedBorder);
            }
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        } else {
            boolean isLast = this.isLastTabInRun(selectedIndex);
            if (isOcean) {
                g.setColor(oceanSelectedBorder);
            }
            int bottom = y + h - 1;
            int right = x + w - 1;
            if (isLast) {
                g.drawLine(x, bottom, rect.x, bottom);
            } else {
                g.drawLine(x, bottom, rect.x - 1, bottom);
            }
            if (rect.x + rect.width < x + w - 2) {
                if (isLast) {
                    g.drawLine(rect.x + rect.width - 1, bottom, right, bottom);
                } else {
                    g.drawLine(rect.x + rect.width, bottom, right, bottom);
                }
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle rect;
        boolean isOcean = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme;
        Color oceanSelectedBorder = UIManager.getColor("TabbedPane.borderHightlightColor");
        Rectangle rectangle = rect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (isOcean) {
            g.setColor(oceanSelectedBorder);
        } else {
            g.setColor(this.selectHighlight);
        }
        if (tabPlacement != 2 || selectedIndex < 0 || rect.x + rect.width + 1 < x || rect.y < y || rect.y > y + h) {
            g.drawLine(x, y + 1, x, y + h - 2);
            if (isOcean && tabPlacement == 2) {
                g.setColor(MetalLookAndFeel.getWhite());
                g.drawLine(x, y + 1, x, y + h - 2);
            }
        } else {
            g.drawLine(x, y, x, rect.y + 1);
            if (rect.y + rect.height < y + h - 2) {
                g.drawLine(x, rect.y + rect.height + 1, x, y + h + 2);
            }
            if (isOcean) {
                g.setColor(MetalLookAndFeel.getWhite());
                g.drawLine(x + 1, y + 1, x + 1, rect.y + 1);
                if (rect.y + rect.height < y + h - 2) {
                    g.drawLine(x + 1, rect.y + rect.height + 1, x + 1, y + h + 2);
                }
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.darkShadow);
        Rectangle rect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        boolean isOcean = MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme;
        Color oceanSelectedBorder = UIManager.getColor("TabbedPane.borderHightlightColor");
        if (tabPlacement != 4 || selectedIndex < 0 || rect.x - 1 > w || rect.y < y || rect.y > y + h) {
            if (isOcean && tabPlacement == 4) {
                g.setColor(oceanSelectedBorder);
            }
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        } else {
            if (isOcean) {
                g.setColor(oceanSelectedBorder);
            }
            g.drawLine(x + w - 1, y, x + w - 1, rect.y);
            if (rect.y + rect.height < y + h - 2) {
                g.drawLine(x + w - 1, rect.y + rect.height, x + w - 1, y + h - 2);
            }
        }
    }

    private boolean isLastTabInRun(int tabIndex) {
        int run;
        int count = this.tabPane.getTabCount();
        int lastIndex = this.lastTabInRun(count, run = this.getRunForTab(count, tabIndex));
        return tabIndex == lastIndex;
    }

    private Color getUnselectedBackground(int tabIndex) {
        Color bg = this.tabPane.getBackgroundAt(tabIndex);
        Color unselectedBackground = UIManager.getColor("TabbedPane.unselectedBackground");
        if (bg instanceof UIResource && unselectedBackground != null) {
            bg = unselectedBackground;
        }
        return bg;
    }

    protected int getTabLabelShiftX(int tabPlacement, int index, boolean isSelected) {
        return 0;
    }

    protected int getTabLabelShiftY(int tabPlacement, int index, boolean isSelected) {
        return 0;
    }

    public class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        public TabbedPaneLayout() {
            super(MetalTabbedPaneUI.this);
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
        }

        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                super.normalizeTabRuns(tabPlacement, tabCount, start, max);
            }
        }
    }
}

