/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.basic.DefaultMenuLayout;
import javax.swing.plaf.basic.SharedUIDefaults;

public class BasicPopupMenuUI
extends PopupMenuUI {
    protected JPopupMenu popupMenu;
    private transient PopupMenuListener popupMenuListener = new PopupMenuHandler();
    TopWindowListener topWindowListener = new TopWindowListener();
    private static int numPopups;
    private static KeyboardHelper keyboardHelper;

    public static ComponentUI createUI(JComponent x) {
        return new BasicPopupMenuUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (numPopups == 0) {
            keyboardHelper = new KeyboardHelper();
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            msm.addChangeListener(keyboardHelper);
        }
        ++numPopups;
        this.popupMenu = (JPopupMenu)c;
        this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
        this.popupMenu.setBorderPainted(true);
        JPopupMenu.setDefaultLightWeightPopupEnabled(true);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void installDefaults() {
        LookAndFeel.installColorsAndFont(this.popupMenu, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu.border");
        this.popupMenu.setOpaque(true);
    }

    protected void installListeners() {
        this.popupMenu.addPopupMenuListener(this.popupMenuListener);
    }

    protected void installKeyboardActions() {
    }

    void installKeyboardActionsImpl() {
        Object[] bindings = this.popupMenu.getComponentOrientation().isLeftToRight() ? (Object[])SharedUIDefaults.get("PopupMenu.selectedWindowInputMapBindings") : (Object[])SharedUIDefaults.get("PopupMenu.selectedWindowInputMapBindings.RightToLeft");
        ComponentInputMap inputMap = LookAndFeel.makeComponentInputMap(this.popupMenu, bindings);
        SwingUtilities.replaceUIInputMap(this.popupMenu, 2, inputMap);
        SwingUtilities.replaceUIActionMap(this.popupMenu, this.getActionMap());
    }

    private ActionMap getActionMap() {
        ActionMap am = (ActionMap)UIManager.get("PopupMenu.actionMap");
        if (am == null) {
            am = this.createDefaultActions();
            UIManager.getLookAndFeelDefaults().put("PopupMenu.actionMap", am);
        }
        return am;
    }

    private ActionMap createDefaultActions() {
        ActionMapUIResource am = new ActionMapUIResource();
        NavigateAction action = new NavigateAction("selectNext");
        am.put(action.getValue("Name"), action);
        action = new NavigateAction("selectPrevious");
        am.put(action.getValue("Name"), action);
        action = new NavigateAction("selectParent");
        am.put(action.getValue("Name"), action);
        action = new NavigateAction("selectChild");
        am.put(action.getValue("Name"), action);
        action = new NavigateAction("return");
        am.put(action.getValue("Name"), action);
        action = new NavigateAction("cancel");
        am.put(action.getValue("Name"), action);
        return am;
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallKeyboardActions();
        this.popupMenu = null;
        if (--numPopups == 0) {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            msm.removeChangeListener(keyboardHelper);
        }
    }

    protected void uninstallDefaults() {
        this.popupMenu.setBackground(null);
        this.popupMenu.setBorder(null);
        this.popupMenu.setFont(null);
        this.popupMenu.setForeground(null);
    }

    protected void uninstallListeners() {
        this.popupMenu.removePopupMenuListener(this.popupMenuListener);
    }

    protected void uninstallKeyboardActions() {
    }

    void uninstallKeyboardActionsImpl() {
        SwingUtilities.replaceUIInputMap(this.popupMenu, 2, null);
        SwingUtilities.replaceUIActionMap(this.popupMenu, null);
    }

    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    public boolean isPopupTrigger(MouseEvent e) {
        return false;
    }

    private class KeyboardHelper
    implements ChangeListener {
        private MenuElement[] lastSelectedPath = new MenuElement[0];
        private Component lastFocused;
        private JRootPane invokerRootPane;

        private KeyboardHelper() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void stateChanged(ChangeEvent event) {
            block5: {
                block6: {
                    block9: {
                        block10: {
                            block7: {
                                block8: {
                                    msm = (MenuSelectionManager)event.getSource();
                                    p = msm.getSelectedPath();
                                    popup = this.getActivePopup(p);
                                    if (popup != null && !popup.isFocusable()) break block5;
                                    if (this.lastSelectedPath.length != 0 && p.length != 0 && !this.invokerEquals(p[0], this.lastSelectedPath[0])) {
                                        BasicPopupMenuUI.this.uninstallKeyboardActionsImpl();
                                        this.lastSelectedPath = new MenuElement[0];
                                    }
                                    if (this.lastSelectedPath.length != 0 || p.length <= 0) break block6;
                                    if (popup != null) break block7;
                                    if (p.length != 2 || !(p[0] instanceof JMenuBar) || !(p[1] instanceof JMenu)) break block8;
                                    invoker /* !! */  = (JComponent)p[1];
                                    popup = ((JMenu)invoker /* !! */ ).getPopupMenu();
                                    break block9;
                                }
                                return;
                            }
                            c = popup.getInvoker();
                            if (!(c instanceof JFrame)) break block10;
                            invoker /* !! */  = ((JFrame)c).getRootPane();
                            break block9;
                        }
                        if (!(c instanceof JApplet)) ** GOTO lbl28
                        invoker /* !! */  = ((JApplet)c).getRootPane();
                        break block9;
lbl-1000:
                        // 1 sources

                        {
                            if (c == null) {
                                return;
                            }
                            c = c.getParent();
lbl28:
                            // 2 sources

                            ** while (!(c instanceof JComponent))
                        }
lbl29:
                        // 1 sources

                        invoker /* !! */  = (JComponent)c;
                    }
                    this.lastFocused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    this.invokerRootPane = SwingUtilities.getRootPane(invoker /* !! */ );
                    if (this.invokerRootPane != null) {
                        this.invokerRootPane.requestFocus(true);
                        BasicPopupMenuUI.this.installKeyboardActionsImpl();
                    }
                    break block5;
                }
                if (this.lastSelectedPath.length != 0 && p.length == 0) {
                    BasicPopupMenuUI.this.uninstallKeyboardActionsImpl();
                }
            }
            this.lastSelectedPath = p;
        }

        private JPopupMenu getActivePopup(MenuElement[] path) {
            JPopupMenu active = null;
            int i = path.length - 1;
            while (i >= 0 && active == null) {
                MenuElement elem = path[i];
                if (elem instanceof JPopupMenu) {
                    active = (JPopupMenu)elem;
                }
                --i;
            }
            return active;
        }

        private boolean invokerEquals(MenuElement el1, MenuElement el2) {
            Component invoker1 = el1.getComponent();
            Component invoker2 = el2.getComponent();
            if (invoker1 instanceof JPopupMenu) {
                invoker1 = ((JPopupMenu)invoker1).getInvoker();
            }
            if (invoker2 instanceof JPopupMenu) {
                invoker2 = ((JPopupMenu)invoker2).getInvoker();
            }
            return invoker1 == invoker2;
        }
    }

    private static class NavigateAction
    extends AbstractAction {
        NavigateAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent event) {
            String name = (String)this.getValue("Name");
            if (name.equals("selectNext")) {
                this.navigateNextPrevious(true);
            } else if (name.equals("selectPrevious")) {
                this.navigateNextPrevious(false);
            } else if (name.equals("selectChild")) {
                this.navigateParentChild(true);
            } else if (name.equals("selectParent")) {
                this.navigateParentChild(false);
            } else if (name.equals("cancel")) {
                this.cancel();
            } else if (name.equals("return")) {
                this.doReturn();
            } else assert (false) : "Must not reach here";
        }

        private void navigateNextPrevious(boolean dir) {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] path = msm.getSelectedPath();
            int len = path.length;
            if (len >= 2) {
                if (path[0] instanceof JMenuBar && path[1] instanceof JMenu && len == 2) {
                    MenuElement[] newPath;
                    JPopupMenu popup = ((JMenu)path[1]).getPopupMenu();
                    MenuElement next = this.findEnabledChild(popup.getSubElements(), -1, true);
                    if (next != null) {
                        newPath = new MenuElement[4];
                        newPath[3] = next;
                    } else {
                        newPath = new MenuElement[3];
                    }
                    System.arraycopy(path, 0, newPath, 0, 2);
                    newPath[2] = popup;
                    msm.setSelectedPath(newPath);
                } else if (path[len - 1] instanceof JPopupMenu && path[len - 2] instanceof JMenu) {
                    JMenu menu = (JMenu)path[len - 2];
                    JPopupMenu popup = menu.getPopupMenu();
                    MenuElement next = this.findEnabledChild(popup.getSubElements(), -1, dir);
                    if (next != null) {
                        MenuElement[] newPath = new MenuElement[len + 1];
                        System.arraycopy(path, 0, newPath, 0, len);
                        newPath[len] = next;
                        msm.setSelectedPath(newPath);
                    } else if (len > 2 && path[len - 3] instanceof JPopupMenu && (next = this.findEnabledChild((popup = (JPopupMenu)path[len - 3]).getSubElements(), menu, dir)) != null && next != menu) {
                        MenuElement[] newPath = new MenuElement[len - 1];
                        System.arraycopy(path, 0, newPath, 0, len - 2);
                        newPath[len - 2] = next;
                        msm.setSelectedPath(newPath);
                    }
                } else {
                    MenuElement[] subs = path[len - 2].getSubElements();
                    MenuElement nextChild = this.findEnabledChild(subs, path[len - 1], dir);
                    if (nextChild == null) {
                        nextChild = this.findEnabledChild(subs, -1, dir);
                    }
                    if (nextChild != null) {
                        path[len - 1] = nextChild;
                        msm.setSelectedPath(path);
                    }
                }
            }
        }

        private MenuElement findEnabledChild(MenuElement[] children, MenuElement start, boolean dir) {
            MenuElement found = null;
            int i = 0;
            while (i < children.length && found == null) {
                if (children[i] == start) {
                    found = this.findEnabledChild(children, i, dir);
                }
                ++i;
            }
            return found;
        }

        private MenuElement findEnabledChild(MenuElement[] children, int start, boolean dir) {
            MenuElement result = null;
            if (dir) {
                result = this.findNextEnabledChild(children, start + 1, children.length - 1);
                if (result == null) {
                    result = this.findNextEnabledChild(children, 0, start - 1);
                }
            } else {
                result = this.findPreviousEnabledChild(children, start - 1, 0);
                if (result == null) {
                    result = this.findPreviousEnabledChild(children, children.length - 1, start + 1);
                }
            }
            return result;
        }

        private MenuElement findNextEnabledChild(MenuElement[] children, int start, int end) {
            MenuElement found = null;
            int i = start;
            while (i <= end && found == null) {
                Component comp;
                if (children[i] != null && (comp = children[i].getComponent()) != null && comp.isEnabled() && comp.isVisible()) {
                    found = children[i];
                }
                ++i;
            }
            return found;
        }

        private MenuElement findPreviousEnabledChild(MenuElement[] children, int start, int end) {
            MenuElement found = null;
            int i = start;
            while (i >= end && found == null) {
                Component comp;
                if (children[i] != null && (comp = children[i].getComponent()) != null && comp.isEnabled() && comp.isVisible()) {
                    found = children[i];
                }
                --i;
            }
            return found;
        }

        private void navigateParentChild(boolean selectChild) {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] path = msm.getSelectedPath();
            int len = path.length;
            if (selectChild) {
                if (len > 0 && path[len - 1] instanceof JMenu && !((JMenu)path[len - 1]).isTopLevelMenu()) {
                    MenuElement[] newPath;
                    JMenu menu = (JMenu)path[len - 1];
                    JPopupMenu popup = menu.getPopupMenu();
                    MenuElement[] subs = popup.getSubElements();
                    MenuElement item = this.findEnabledChild(subs, -1, true);
                    if (item == null) {
                        newPath = new MenuElement[len + 1];
                    } else {
                        newPath = new MenuElement[len + 2];
                        newPath[len + 1] = item;
                    }
                    System.arraycopy(path, 0, newPath, 0, len);
                    newPath[len] = popup;
                    msm.setSelectedPath(newPath);
                    return;
                }
            } else {
                int popupIndex = len - 1;
                if (len > 2 && (path[popupIndex] instanceof JPopupMenu || path[--popupIndex] instanceof JPopupMenu) && !((JMenu)path[popupIndex - 1]).isTopLevelMenu()) {
                    MenuElement[] newPath = new MenuElement[popupIndex];
                    System.arraycopy(path, 0, newPath, 0, popupIndex);
                    msm.setSelectedPath(newPath);
                    return;
                }
            }
            if (len > 1 && path[0] instanceof JMenuBar) {
                MenuElement currentMenu = path[1];
                MenuElement nextMenu = this.findEnabledChild(path[0].getSubElements(), currentMenu, selectChild);
                if (nextMenu != null && nextMenu != currentMenu) {
                    MenuElement[] newSelection = len == 2 ? new MenuElement[]{path[0], nextMenu} : new MenuElement[]{path[0], nextMenu, ((JMenu)nextMenu).getPopupMenu()};
                    msm.setSelectedPath(newSelection);
                }
            }
        }

        private void cancel() {
            JPopupMenu lastPopup = this.getLastPopup();
            EventListener[] ll = lastPopup.getListeners(PopupMenuListener.class);
            int i = 0;
            while (i < ll.length) {
                PopupMenuEvent ev = new PopupMenuEvent(lastPopup);
                ((PopupMenuListener)ll[i]).popupMenuCanceled(ev);
                ++i;
            }
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] path = msm.getSelectedPath();
            if (path.length > 4) {
                MenuElement[] newPath = new MenuElement[path.length - 2];
                System.arraycopy(path, 0, newPath, 0, path.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(newPath);
            } else {
                msm.clearSelectedPath();
            }
        }

        private JPopupMenu getLastPopup() {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] p = msm.getSelectedPath();
            JPopupMenu popup = null;
            int i = p.length - 1;
            while (popup == null && i >= 0) {
                if (p[i] instanceof JPopupMenu) {
                    popup = (JPopupMenu)p[i];
                }
                --i;
            }
            return popup;
        }

        private void doReturn() {
            MenuSelectionManager msm;
            MenuElement[] path;
            KeyboardFocusManager fmgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component focusOwner = fmgr.getFocusOwner();
            if ((focusOwner == null || focusOwner instanceof JRootPane) && (path = (msm = MenuSelectionManager.defaultManager()).getSelectedPath()).length > 0) {
                MenuElement lastElement = path[path.length - 1];
                if (lastElement instanceof JMenu) {
                    MenuElement[] newPath = new MenuElement[path.length + 1];
                    System.arraycopy(path, 0, newPath, 0, path.length);
                    newPath[path.length] = ((JMenu)lastElement).getPopupMenu();
                    msm.setSelectedPath(newPath);
                } else if (lastElement instanceof JMenuItem) {
                    JMenuItem mi = (JMenuItem)lastElement;
                    if (mi.getUI() instanceof BasicMenuItemUI) {
                        ((BasicMenuItemUI)mi.getUI()).doClick(msm);
                    } else {
                        msm.clearSelectedPath();
                        mi.doClick(0);
                    }
                }
            }
        }
    }

    private class PopupMenuHandler
    implements PopupMenuListener {
        private PopupMenuHandler() {
        }

        public void popupMenuCanceled(PopupMenuEvent event) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
            Component invoker = BasicPopupMenuUI.this.popupMenu.getInvoker();
            Component rootContainer = SwingUtilities.getRoot(invoker);
            if (rootContainer != null) {
                rootContainer.removeComponentListener(BasicPopupMenuUI.this.topWindowListener);
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
            MenuSelectionManager manager;
            Component invoker = BasicPopupMenuUI.this.popupMenu.getInvoker();
            Component rootContainer = SwingUtilities.getRoot(invoker);
            if (rootContainer != null) {
                rootContainer.addComponentListener(BasicPopupMenuUI.this.topWindowListener);
            }
            if ((manager = MenuSelectionManager.defaultManager()).getSelectedPath().length == 0) {
                MenuElement[] path = new MenuElement[2];
                path[0] = BasicPopupMenuUI.this.popupMenu;
                Component[] comps = BasicPopupMenuUI.this.popupMenu.getComponents();
                if (comps.length != 0 && comps[0] instanceof MenuElement) {
                    path[1] = (MenuElement)((Object)comps[0]);
                    manager.setSelectedPath(path);
                }
            }
        }
    }

    private class TopWindowListener
    implements ComponentListener {
        private TopWindowListener() {
        }

        public void componentResized(ComponentEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }

        public void componentMoved(ComponentEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }

        public void componentShown(ComponentEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }

        public void componentHidden(ComponentEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }
    }
}

