/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.util.Arrays;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class MBeanInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6451021435135161911L;
    private String description;
    private String className;
    private MBeanAttributeInfo[] attributes;
    private MBeanOperationInfo[] operations;
    private MBeanConstructorInfo[] constructors;
    private MBeanNotificationInfo[] notifications;
    private transient String string;

    public MBeanInfo(String name, String desc, MBeanAttributeInfo[] attribs, MBeanConstructorInfo[] cons, MBeanOperationInfo[] ops, MBeanNotificationInfo[] notifs) {
        this.className = name;
        this.description = desc;
        this.attributes = attribs == null ? new MBeanAttributeInfo[0] : (MBeanAttributeInfo[])attribs.clone();
        this.constructors = cons == null ? new MBeanConstructorInfo[0] : (MBeanConstructorInfo[])cons.clone();
        this.operations = ops == null ? new MBeanOperationInfo[0] : (MBeanOperationInfo[])ops.clone();
        this.notifications = notifs == null ? new MBeanNotificationInfo[0] : (MBeanNotificationInfo[])notifs.clone();
    }

    public Object clone() {
        MBeanInfo clone = null;
        try {
            clone = (MBeanInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MBeanInfo)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MBeanInfo o = (MBeanInfo)obj;
        MBeanAttributeInfo[] attr = o.getAttributes();
        int a = 0;
        while (a < this.attributes.length) {
            if (a == attr.length) {
                return true;
            }
            if (!this.attributes[a].equals(attr[a])) {
                return false;
            }
            ++a;
        }
        MBeanConstructorInfo[] cons = o.getConstructors();
        int a2 = 0;
        while (a2 < this.constructors.length) {
            if (a2 == cons.length) {
                return true;
            }
            if (!this.constructors[a2].equals(cons[a2])) {
                return false;
            }
            ++a2;
        }
        MBeanOperationInfo[] ops = o.getOperations();
        int a3 = 0;
        while (a3 < this.operations.length) {
            if (a3 == ops.length) {
                return true;
            }
            if (!this.operations[a3].equals(ops[a3])) {
                return false;
            }
            ++a3;
        }
        MBeanNotificationInfo[] notifs = o.getNotifications();
        int a4 = 0;
        while (a4 < this.notifications.length) {
            if (a4 == notifs.length) {
                return true;
            }
            if (!this.notifications[a4].equals(notifs[a4])) {
                return false;
            }
            ++a4;
        }
        return this.className.equals(o.getClassName()) && this.description.equals(o.getDescription());
    }

    public MBeanAttributeInfo[] getAttributes() {
        return (MBeanAttributeInfo[])this.attributes.clone();
    }

    public String getClassName() {
        return this.className;
    }

    public MBeanConstructorInfo[] getConstructors() {
        return (MBeanConstructorInfo[])this.constructors.clone();
    }

    public String getDescription() {
        return this.description;
    }

    public MBeanNotificationInfo[] getNotifications() {
        return (MBeanNotificationInfo[])this.notifications.clone();
    }

    public MBeanOperationInfo[] getOperations() {
        return (MBeanOperationInfo[])this.operations.clone();
    }

    public int hashCode() {
        return this.className.hashCode() + this.description.hashCode() + Arrays.hashCode(this.attributes) + Arrays.hashCode(this.constructors) + Arrays.hashCode(this.operations) + Arrays.hashCode(this.notifications);
    }

    public String toString() {
        if (this.string == null) {
            this.string = String.valueOf(this.getClass().getName()) + "[name=" + this.className + ",desc=" + this.description + ",attributes=" + Arrays.toString(this.attributes) + ",constructors=" + Arrays.toString(this.constructors) + ",operations=" + Arrays.toString(this.operations) + ",notifications=" + Arrays.toString(this.notifications) + "]";
        }
        return this.string;
    }
}

