/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.metadata.IIOMetadataFormatImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class IIOMetadataNode
implements Element,
NodeList {
    private String name;
    private HashMap attrs = new HashMap();
    private List children = new ArrayList();
    private IIOMetadataNode parent;
    private Object obj;

    public IIOMetadataNode() {
    }

    public IIOMetadataNode(String nodename) {
        this.name = nodename;
    }

    public Object getUserObject() {
        return this.obj;
    }

    public void setUserObject(Object o) {
        this.obj = o;
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return 32;
    }

    public String getAttribute(String name) {
        Attr anode = (Attr)this.attrs.get(name);
        return anode != null ? anode.getValue() : null;
    }

    public Attr getAttributeNode(String name) {
        String val = this.getAttribute(name);
        if (val != null) {
            return new IIOMetadataFormatImpl.IIOMetadataNodeAttr(this, name, val);
        }
        return null;
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.getAttributeNode(localName);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return this.getAttribute(localName);
    }

    public String getBaseURI() {
        return null;
    }

    private void getElementsRecurse(IIONodeList list2, String name) {
        int i = 0;
        while (i < this.children.size()) {
            if (((Node)this.children.get(i)).getNodeName().equals(name)) {
                list2.children.add(this.children.get(i));
            }
            this.getElementsRecurse(list2, name);
            ++i;
        }
    }

    public NodeList getElementsByTagName(String name) {
        IIONodeList list2 = new IIONodeList();
        this.getElementsRecurse(list2, name);
        return list2;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        IIONodeList list2 = new IIONodeList();
        this.getElementsRecurse(list2, this.name);
        return list2;
    }

    public String getTagName() {
        return this.name;
    }

    public boolean hasAttribute(String name) {
        return this.attrs.containsKey(name);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.attrs.containsKey(localName);
    }

    public void removeAttribute(String name) {
        this.attrs.remove(name);
    }

    public Attr removeAttributeNode(Attr oldAttr) {
        return (Attr)this.attrs.remove(oldAttr.getName());
    }

    public void removeAttributeNS(String namespaceURI, String localName) {
        this.removeAttribute(localName);
    }

    public void setAttribute(String name, String value) {
        Attr attr = this.getAttributeNode(name);
        if (attr != null) {
            attr.setValue(value);
        } else {
            this.attrs.put(name, new IIOMetadataFormatImpl.IIOMetadataNodeAttr(this, name, value));
        }
    }

    public Attr setAttributeNode(Attr newAttr) {
        return this.attrs.put(newAttr.getName(), newAttr);
    }

    public Attr setAttributeNodeNS(Attr newAttr) {
        return this.attrs.put(newAttr.getName(), newAttr);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        this.setAttribute(qualifiedName, value);
    }

    public int getLength() {
        return this.children.size();
    }

    public Node item(int index) {
        if (index < this.children.size()) {
            return (Node)this.children.get(index);
        }
        return null;
    }

    public Node appendChild(Node newChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("Child node is null");
        }
        IIOMetadataNode child = (IIOMetadataNode)newChild;
        this.children.add(child);
        child.parent = this;
        return this;
    }

    public Node cloneNode(boolean deep) {
        IIOMetadataNode newnode = new IIOMetadataNode(this.name);
        newnode.parent = null;
        newnode.obj = this.obj;
        if (deep) {
            int i = 0;
            while (i < this.children.size()) {
                newnode.children.add(((Node)this.children.get(i)).cloneNode(deep));
                ++i;
            }
        }
        for (IIOMetadataFormatImpl.IIOMetadataNodeAttr attr : this.attrs.values()) {
            newnode.attrs.put(attr.name, attr.cloneNode(deep));
            attr.owner = newnode;
        }
        return newnode;
    }

    public NamedNodeMap getAttributes() {
        return new IIONamedNodeMap(this.attrs);
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Object getFeature(String feature, String version) {
        return null;
    }

    public Node getFirstChild() {
        return this.children.size() > 0 ? (Node)this.children.get(0) : null;
    }

    public Node getLastChild() {
        return this.children.size() > 0 ? (Node)this.children.get(this.children.size() - 1) : null;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getNamespaceURI() {
        return null;
    }

    public Node getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        int idx = this.parent.children.indexOf(this);
        return idx == this.parent.children.size() - 1 ? null : (Node)this.parent.children.get(idx + 1);
    }

    public String getNodeName() {
        return this.name;
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeValue() {
        return null;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public String getPrefix() {
        return null;
    }

    public Node getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        int idx = this.parent.children.indexOf(this);
        return idx == 0 ? null : (Node)this.parent.children.get(idx - 1);
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public Object getUserData(String key) {
        return null;
    }

    public boolean hasAttributes() {
        return !this.attrs.isEmpty();
    }

    public boolean hasChildNodes() {
        return !this.children.isEmpty();
    }

    public Node insertBefore(Node newChild, Node refChild) {
        if (newChild == null) {
            throw new IllegalArgumentException();
        }
        int idx = this.children.indexOf(refChild);
        if (idx == -1) {
            this.children.add(newChild);
        } else {
            this.children.add(idx, newChild);
        }
        ((IIOMetadataNode)newChild).parent = this;
        return newChild;
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return true;
    }

    public boolean isEqualNode(Node arg) {
        return true;
    }

    public boolean isSameNode(Node other) {
        return this == other;
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    public void normalize() {
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException();
        }
        this.children.remove(oldChild);
        ((IIOMetadataNode)oldChild).parent = null;
        return oldChild;
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        if (newChild == null) {
            throw new IllegalArgumentException();
        }
        this.children.set(this.children.indexOf(oldChild), newChild);
        ((IIOMetadataNode)oldChild).parent = null;
        return oldChild;
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
    }

    public void setNodeValue(String nodeValue) throws DOMException {
    }

    public void setPrefix(String prefix) {
    }

    public void setTextContent(String textContent) throws DOMException {
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }

    private class IIONamedNodeMap
    implements NamedNodeMap {
        HashMap attrs;

        public IIONamedNodeMap(HashMap attrs) {
            this.attrs = attrs;
        }

        public Node getNamedItem(String name) {
            return (Node)this.attrs.get(name);
        }

        public Node setNamedItem(Node arg) throws DOMException {
            if (arg instanceof IIOMetadataFormatImpl.IIOMetadataNodeAttr) {
                IIOMetadataFormatImpl.IIOMetadataNodeAttr attr = (IIOMetadataFormatImpl.IIOMetadataNodeAttr)arg;
                if (attr.owner != null) {
                    throw new DOMException(10, "");
                }
                return this.attrs.put(attr.name, attr);
            }
            throw new DOMException(3, "");
        }

        public Node removeNamedItem(String name) throws DOMException {
            return (Node)this.attrs.remove(name);
        }

        public Node item(int index) {
            return (Node)this.attrs.values().toArray()[index];
        }

        public int getLength() {
            return this.attrs.size();
        }

        public Node getNamedItemNS(String namespaceURI, String localName) {
            return this.getNamedItem(localName);
        }

        public Node setNamedItemNS(Node arg) throws DOMException {
            return this.setNamedItem(arg);
        }

        public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
            return this.removeNamedItem(localName);
        }
    }

    private class IIONodeList
    implements NodeList {
        List children = new ArrayList();

        private IIONodeList() {
        }

        public Node item(int index) {
            return index < this.children.size() ? (Node)this.children.get(index) : null;
        }

        public int getLength() {
            return this.children.size();
        }
    }
}

