/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scanner
implements Iterator<String> {
    private static final String NOT_LONG = "\" is not a long";
    private static final String ERR_PREFIX = "\"";
    private static final String NOT_INT = "\" is not an integer";
    private static final String NOT_DOUBLE = "\" is not a double";
    private static final String NOT_BYTE = "\" is not a byte";
    private static final String NOT_BOOLEAN = "\" is not a boolean";
    private static final String IS_NOT = "\" is not ";
    private static final String DEFAULT_PATTERN_S = "\\p{javaWhitespace}+";
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("\\p{javaWhitespace}+");
    private static final String BIG_INTEGER = "BigInteger";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private IOException lastIOException = null;
    private InputStream bIS = null;
    private final int MaxBufferLen = 1000000;
    private final int MIN_BUF_LEN = 100;
    private final int MAX_PREFIX = 10000;
    private String actBuffer = new String();
    private int currentRadix = 10;
    private Locale actLocale = Locale.getDefault();
    private Pattern p = DEFAULT_PATTERN;
    private int actPos = 0;
    private final byte[] tmpBuffer = new byte[1000000];
    private String charsetName = null;
    private Matcher myMatcher = this.p.matcher(this.actBuffer);
    private MatchResult actResult = null;
    private Readable readableSource = null;
    private ReadableByteChannel rbcSource = null;
    private boolean isClosed = false;
    private String lastFound = null;
    private boolean lastFoundPresent = false;
    private int lastNextPos = 0;
    private int lastPatternHash = 0;
    private int last_RegionStart = 0;
    private int last_RegionEnd = 0;
    private boolean last_anchor = false;
    private boolean last_transparent = false;
    private MatchResult lastResult = null;
    private int procesedChars = 0;
    private boolean needInput = false;
    private boolean skipped = false;
    private boolean doSkipp = false;
    private boolean matchValid = false;
    private NumberFormat actFormat = NumberFormat.getInstance(this.actLocale);
    private DecimalFormat df = (DecimalFormat)this.actFormat;
    private boolean useLocale = true;
    private DecimalFormatSymbols dfs = new DecimalFormatSymbols(this.actLocale);

    public Scanner(File source) throws FileNotFoundException {
        this(source, null);
    }

    public Scanner(File source, String charsetName) throws FileNotFoundException {
        this(new FileInputStream(source), charsetName);
    }

    public Scanner(InputStream source) {
        this(source, null);
    }

    public Scanner(InputStream source, String charsetName) {
        this.bIS = new BufferedInputStream(source);
        this.charsetName = charsetName;
        this.myFillBuffer();
    }

    public Scanner(Readable source) {
        this.readableSource = source;
        this.myFillBuffer();
    }

    public Scanner(ReadableByteChannel source) {
        this(source, null);
    }

    public Scanner(ReadableByteChannel source, String charsetName) {
        this.charsetName = charsetName;
        this.rbcSource = source;
        this.myFillBuffer();
    }

    public Scanner(String source) {
        this.actBuffer = new String(source);
        this.myMatcher.reset(this.actBuffer);
    }

    public void close() {
        try {
            if (this.bIS != null) {
                this.bIS.close();
            }
            if (this.rbcSource != null) {
                this.rbcSource.close();
            }
            this.isClosed = true;
        }
        catch (IOException ioe) {
            this.lastIOException = ioe;
        }
    }

    public Pattern delimiter() {
        return this.p;
    }

    public String findInLine(Pattern pattern2) throws NoSuchElementException {
        String tmpStr = this.myNextLine(false);
        return this.myFindPInStr(pattern2, tmpStr, 0);
    }

    public String findInLine(String pattern2) {
        return this.findInLine(Pattern.compile(pattern2));
    }

    public String findWithinHorizon(Pattern pattern2, int horizon) throws IllegalArgumentException, IllegalStateException {
        if (horizon < 0) {
            throw new IllegalArgumentException(String.valueOf(horizon) + " is negative");
        }
        if (this.isClosed) {
            throw new IllegalStateException("Scanner is closed");
        }
        this.doSkipp = true;
        String rc = this.myFindPInStr(pattern2, this.actBuffer, horizon);
        if (rc != null) {
            this.actPos += rc.length();
        }
        return rc;
    }

    public String findWithinHorizon(String pattern2, int horizon) throws IllegalArgumentException, IllegalStateException {
        return this.findWithinHorizon(Pattern.compile(pattern2), horizon);
    }

    @Override
    public boolean hasNext() throws IllegalStateException {
        String tmpStr = null;
        try {
            tmpStr = this.myCoreNext(false, this.p);
        }
        catch (NoSuchElementException noSuchElementException) {}
        return tmpStr != null && tmpStr.length() > 0;
    }

    public boolean hasNext(Pattern pattern2) throws IllegalStateException {
        String tmpStr = this.myNext(pattern2, false);
        return tmpStr != null && tmpStr.length() > 0;
    }

    public boolean hasNext(String pattern2) throws IllegalStateException {
        return this.hasNext(Pattern.compile(pattern2));
    }

    public boolean hasNextBigDecimal() throws IllegalStateException {
        try {
            this.myBigDecimal(false);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public boolean hasNextBigInteger() throws IllegalStateException {
        return this.hasNextBigInteger(this.currentRadix);
    }

    public boolean hasNextBigInteger(int radix) throws IllegalStateException {
        try {
            this.myNextBigInteger(radix, false, BIG_INTEGER);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public boolean hasNextBoolean() throws IllegalStateException {
        try {
            this.myNextBoolean(false);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public boolean hasNextByte() throws IllegalStateException {
        return this.hasNextByte(this.currentRadix);
    }

    public boolean hasNextByte(int radix) throws IllegalStateException {
        try {
            this.myNextByte(radix, false);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public boolean hasNextDouble() throws IllegalStateException {
        try {
            this.myNextDouble(false);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public boolean hasNextFloat() throws IllegalStateException {
        try {
            this.myNextDouble(false);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public boolean hasNextInt() throws IllegalStateException {
        return this.hasNextInt(this.currentRadix);
    }

    public boolean hasNextInt(int radix) throws IllegalStateException {
        try {
            this.myNextInt(radix, false);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public boolean hasNextLine() throws IllegalStateException {
        return this.myNextLine(false) != null;
    }

    public boolean hasNextLong() throws IllegalStateException {
        return this.hasNextLong(this.currentRadix);
    }

    public boolean hasNextLong(int radix) throws IllegalStateException {
        try {
            this.myNextLong(radix, false);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public boolean hasNextShort() throws IllegalStateException {
        return this.hasNextShort(this.currentRadix);
    }

    public boolean hasNextShort(int radix) throws IllegalStateException {
        try {
            this.myNextShort(radix, false);
            return true;
        }
        catch (InputMismatchException inputMismatchException) {
            return false;
        }
    }

    public IOException ioException() {
        return this.lastIOException;
    }

    public boolean isUseLocale() {
        return this.useLocale;
    }

    public Locale locale() {
        return this.actLocale;
    }

    public MatchResult match() {
        return this.actResult;
    }

    @Override
    public String next() throws NoSuchElementException, IllegalStateException {
        return this.myCoreNext(true, this.p);
    }

    public String next(Pattern pattern2) throws NoSuchElementException, IllegalStateException {
        return this.myNext(pattern2, true);
    }

    public String next(String pattern2) throws NoSuchElementException, IllegalStateException {
        return this.next(Pattern.compile(pattern2));
    }

    public BigDecimal nextBigDecimal() throws NoSuchElementException, IllegalStateException {
        return this.myBigDecimal(true);
    }

    public BigInteger nextBigInteger() throws NoSuchElementException, IllegalStateException {
        return this.nextBigInteger(this.currentRadix);
    }

    public BigInteger nextBigInteger(int radix) throws NoSuchElementException, IllegalStateException {
        return this.myNextBigInteger(radix, true, BIG_INTEGER);
    }

    public boolean nextBoolean() throws NoSuchElementException, IllegalStateException {
        return this.myNextBoolean(true);
    }

    public byte nextByte() throws NoSuchElementException, IllegalStateException {
        return this.nextByte(this.currentRadix);
    }

    public byte nextByte(int radix) throws NoSuchElementException, IllegalStateException {
        return this.myNextByte(radix, true);
    }

    public double nextDouble() throws NoSuchElementException, IllegalStateException {
        return this.myNextDouble(true);
    }

    public float nextFloat() throws NoSuchElementException, IllegalStateException {
        return (float)this.myNextDouble(true);
    }

    public int nextInt() throws NoSuchElementException, IllegalStateException {
        return this.nextInt(this.currentRadix);
    }

    public int nextInt(int radix) throws NoSuchElementException, IllegalStateException {
        return this.myNextInt(radix, true);
    }

    public String nextLine() throws NoSuchElementException, IllegalStateException {
        return this.myNextLine(true);
    }

    public long nextLong() throws NoSuchElementException, IllegalStateException {
        return this.nextLong(this.currentRadix);
    }

    public long nextLong(int radix) throws NoSuchElementException, IllegalStateException {
        return this.myNextLong(radix, true);
    }

    public short nextShort() throws NoSuchElementException {
        return this.nextShort(this.currentRadix);
    }

    public short nextShort(int radix) throws NoSuchElementException {
        return this.myNextShort(radix, true);
    }

    public int radix() {
        return this.currentRadix;
    }

    @Override
    public void remove() {
    }

    public void setUseLocale(boolean useLocale) {
        this.useLocale = useLocale;
    }

    public Scanner skip(Pattern pattern2) throws NoSuchElementException {
        this.doSkipp = true;
        Matcher matcher = pattern2.matcher(this.actBuffer);
        matcher.region(this.actPos - 1, this.actBuffer.length());
        boolean found = matcher.find();
        found = this.myFillBuffer_loop(matcher, this.actPos - 1, found);
        int end = matcher.end();
        this.actPos = end + 1;
        this.doSkipp = false;
        this.skipped = true;
        this.actResult = null;
        if (!found) {
            throw new NoSuchElementException();
        }
        return this;
    }

    public Scanner skip(String pattern2) {
        return this.skip(Pattern.compile(pattern2));
    }

    public String toString() {
        String rc;
        String tmpStr2 = rc = this.getClass().getName();
        tmpStr2 = "[delimiters=" + this.p.pattern() + "]";
        rc = String.valueOf(rc) + tmpStr2;
        tmpStr2 = "[position=" + (this.procesedChars + this.actPos) + "]";
        rc = String.valueOf(rc) + tmpStr2;
        tmpStr2 = "[match valid=" + this.matchValid + "]";
        rc = String.valueOf(rc) + tmpStr2;
        tmpStr2 = "[need input=" + this.needInput + "]";
        rc = String.valueOf(rc) + tmpStr2;
        tmpStr2 = "[source closed=" + this.isClosed + "]";
        rc = String.valueOf(rc) + tmpStr2;
        tmpStr2 = "[skipped=" + this.skipped + "]";
        rc = String.valueOf(rc) + tmpStr2;
        tmpStr2 = "[group separator=\\" + this.dfs.getGroupingSeparator() + "]";
        rc = String.valueOf(rc) + tmpStr2;
        tmpStr2 = "[decimal separator=\\" + this.dfs.getDecimalSeparator() + "]";
        rc = String.valueOf(rc) + tmpStr2;
        tmpStr2 = "[positive prefix=" + this.myConvert(this.df.getPositivePrefix()) + "]";
        rc = String.valueOf(rc) + tmpStr2;
        tmpStr2 = "[negative prefix=" + this.myConvert(this.df.getNegativePrefix()) + "]";
        rc = String.valueOf(rc) + tmpStr2;
        tmpStr2 = "[positive suffix=" + this.myConvert(this.df.getPositiveSuffix()) + "]";
        rc = String.valueOf(rc) + tmpStr2;
        tmpStr2 = "[negative suffix=" + this.myConvert(this.df.getNegativeSuffix()) + "]";
        rc = String.valueOf(rc) + tmpStr2;
        tmpStr2 = "[NaN string=" + this.myConvert(this.dfs.getNaN()) + "]";
        rc = String.valueOf(rc) + tmpStr2;
        tmpStr2 = "[infinity string=" + this.myConvert(this.dfs.getInfinity()) + "]";
        rc = String.valueOf(rc) + tmpStr2;
        return rc;
    }

    public Scanner useDelimiter(Pattern pattern2) {
        if (pattern2 != null) {
            this.p = pattern2;
            this.myMatcher = this.p.matcher(this.actBuffer);
        }
        return this;
    }

    public Scanner useDelimiter(String pattern2) {
        return this.useDelimiter(Pattern.compile(pattern2));
    }

    public Scanner useLocale(Locale locale) {
        if (locale != null) {
            this.actLocale = locale;
            this.actFormat = NumberFormat.getInstance(this.actLocale);
            this.dfs = new DecimalFormatSymbols(this.actLocale);
            this.df = (DecimalFormat)this.actFormat;
        }
        return this;
    }

    public Scanner useRadix(int radix) throws IllegalArgumentException {
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException();
        }
        this.currentRadix = radix;
        return this;
    }

    private String myApplyLocale(String str, int radix) throws ParseException {
        if (this.useLocale && radix == 10) {
            String rc = this.actFormat.parse(str).toString();
            return rc;
        }
        return str;
    }

    private String myApplyLocaleBD(String str) throws ParseException {
        if (!this.useLocale || this.currentRadix != 10) {
            return str;
        }
        String negPrefix = this.df.getNegativePrefix();
        String negSuffix = this.df.getNegativeSuffix();
        String posPrefix = this.df.getPositivePrefix();
        String posSuffix = this.df.getPositiveSuffix();
        char d = this.dfs.getDecimalSeparator();
        boolean isNegativ = false;
        String parts = null;
        String tmpStr1 = "";
        int begin1 = str.indexOf(d);
        int begin2 = str.indexOf(d, begin1 + 1);
        if (begin2 > 0) {
            throw new ParseException("more than one Decimal seperators", begin2);
        }
        parts = str.substring(0, begin1);
        if (negPrefix.length() > 0 && str.substring(0, negPrefix.length()).equals(negPrefix) || negSuffix.length() > 0 && str.substring(str.length() - negSuffix.length()).equals(negSuffix)) {
            parts = String.valueOf(parts) + negSuffix;
            isNegativ = true;
        } else if (posPrefix.length() > 0 && str.substring(0, posPrefix.length()).equals(posPrefix) || posSuffix.length() > 0 && str.substring(str.length() - posSuffix.length()).equals(posSuffix)) {
            parts = String.valueOf(parts) + posSuffix;
        }
        tmpStr1 = this.actFormat.parse(parts).toString();
        tmpStr1 = isNegativ ? String.valueOf(tmpStr1) + "." + str.substring(str.indexOf(d) + 1, str.length() - negSuffix.length()) : String.valueOf(tmpStr1) + "." + str.substring(str.indexOf(d) + 1, str.length() - posSuffix.length());
        return tmpStr1;
    }

    private BigDecimal myBigDecimal(boolean delete) throws InputMismatchException {
        String tmp = this.myCoreNext(delete, this.p);
        try {
            tmp = this.myApplyLocaleBD(tmp);
        }
        catch (ParseException parseException) {
            throw new InputMismatchException(ERR_PREFIX + tmp + IS_NOT + "BigDecimal!!");
        }
        BigDecimal rc = new BigDecimal(tmp);
        return rc;
    }

    private String myConvert(String str) {
        if (str != null && str.length() > 0) {
            return "\\Q" + str + "\\E";
        }
        return str;
    }

    private String myCoreNext(boolean delete, Pattern pattern2) throws NoSuchElementException {
        int left;
        if (this.isClosed) {
            throw new IllegalStateException("Scanner closed");
        }
        if (this.shallUseLastFound(pattern2 != null ? pattern2 : this.p)) {
            if (this.last_RegionEnd != this.myMatcher.regionEnd()) {
                System.out.println(String.valueOf(this.last_RegionEnd) + " != " + this.myMatcher.regionEnd() + " (" + (this.last_RegionEnd - this.myMatcher.regionEnd()) + ")");
            }
            if (delete) {
                this.actPos = this.lastNextPos;
                this.lastFoundPresent = false;
                this.actResult = this.lastResult;
            }
            return this.lastFound;
        }
        boolean found = false;
        String tmp2 = null;
        if (this.actPos > 10000) {
            this.procesedChars += this.actPos;
            this.actBuffer = this.actBuffer.substring(this.actPos);
            this.actPos = 0;
            this.myMatcher = pattern2.matcher(this.actBuffer);
        }
        if ((left = this.actBuffer.length() - this.actPos) < 100) {
            this.myFillBuffer();
        }
        found = this.myMatcher.find(this.actPos);
        found = this.myFillBuffer_loop(this.myMatcher, this.actPos, found);
        this.needInput = false;
        if (found) {
            int endIndex = this.doSkipp ? this.myMatcher.end() : this.myMatcher.start();
            tmp2 = this.actBuffer.substring(this.actPos, endIndex);
            this.lastNextPos = this.myMatcher.end();
            if (delete) {
                this.actPos = this.lastNextPos;
            } else {
                this.lastFound = tmp2;
                this.lastFoundPresent = true;
                this.lastPatternHash = pattern2.hashCode();
            }
            this.last_RegionStart = this.myMatcher.regionStart();
            this.last_RegionEnd = this.myMatcher.regionEnd();
            this.last_anchor = this.myMatcher.hasAnchoringBounds();
            this.last_transparent = this.myMatcher.hasTransparentBounds();
        } else if (this.myMatcher.hitEnd()) {
            tmp2 = this.actBuffer.substring(this.actPos);
            if (tmp2.length() == 0) {
                tmp2 = null;
            }
            this.lastNextPos = this.actBuffer.length();
            if (delete) {
                this.actPos = this.lastNextPos;
            } else {
                this.lastFound = tmp2;
                this.lastFoundPresent = true;
                this.lastPatternHash = pattern2.hashCode();
            }
            this.last_RegionStart = this.myMatcher.regionStart();
            this.last_RegionEnd = this.myMatcher.regionEnd();
            this.last_anchor = this.myMatcher.hasAnchoringBounds();
            this.last_transparent = this.myMatcher.hasTransparentBounds();
        } else {
            throw new NoSuchElementException();
        }
        if (delete) {
            this.actResult = this.myMatcher.toMatchResult();
            this.matchValid = this.actResult != null;
        } else {
            this.lastResult = this.myMatcher.toMatchResult();
        }
        this.skipped = this.doSkipp;
        this.doSkipp = false;
        return tmp2;
    }

    private void myFillBuffer() {
        CharBuffer cb = null;
        ByteBuffer bb = null;
        if (this.bIS != null) {
            try {
                int len = this.bIS.read(this.tmpBuffer);
                if (len < 0) {
                    return;
                }
                String tmpStr = this.charsetName != null ? new String(this.tmpBuffer, 0, len, this.charsetName) : new String(this.tmpBuffer, 0, len);
                this.actBuffer = String.valueOf(this.actBuffer) + tmpStr;
            }
            catch (IOException e) {
                this.lastIOException = e;
            }
        } else if (this.readableSource != null) {
            try {
                cb = CharBuffer.allocate(1000);
                this.needInput = true;
                int len = this.readableSource.read(cb);
                if (len < 0) {
                    return;
                }
                this.needInput = false;
                String tmpStr = new String(cb.array());
                this.actBuffer = String.valueOf(this.actBuffer) + tmpStr;
            }
            catch (IOException e) {
                this.lastIOException = e;
            }
        } else if (this.rbcSource != null) {
            try {
                bb = ByteBuffer.allocate(1000);
                this.needInput = true;
                int len = this.rbcSource.read(bb);
                this.needInput = false;
                if (len < 0) {
                    return;
                }
                String tmpStr = this.charsetName != null ? new String(bb.array(), 0, len, this.charsetName) : new String(bb.array(), 0, len);
                this.actBuffer = String.valueOf(this.actBuffer) + tmpStr;
            }
            catch (IOException e) {
                this.lastIOException = e;
            }
        }
        this.myMatcher.reset(this.actBuffer);
    }

    private boolean myFillBuffer_loop(Matcher aktM, int pos, boolean found) {
        int tmp = this.actBuffer.length();
        while (aktM.hitEnd() && (this.bIS != null || this.readableSource != null || this.rbcSource != null)) {
            this.myFillBuffer();
            if (tmp == this.actBuffer.length()) break;
            found = aktM.find(pos);
            this.needInput = true;
        }
        return found;
    }

    private String myFindPInStr(Pattern pattern2, String str, int horizon) {
        String rc = null;
        int curPos = this.actPos;
        Matcher aktMatcher = this.myMatcher;
        this.myMatcher = pattern2.matcher(str);
        if (horizon > 0) {
            this.myMatcher.useAnchoringBounds(true);
            this.myMatcher.useTransparentBounds(true);
            this.myMatcher.region(this.actPos, this.actPos + horizon);
        }
        rc = this.myCoreNext(true, pattern2);
        this.myMatcher = aktMatcher;
        this.actPos = curPos;
        this.skipped = true;
        return rc;
    }

    private String myNext(Pattern pattern2, boolean delete) {
        Matcher aktMatcher = this.myMatcher;
        String currBuffer = this.actBuffer;
        String tmpStr = this.myCoreNext(delete, this.p);
        this.myMatcher = pattern2.matcher(tmpStr);
        this.actBuffer = tmpStr;
        int currAktPos = this.actPos;
        this.actPos = 0;
        String result = this.myCoreNext(delete, pattern2);
        this.actPos = currAktPos;
        this.actBuffer = currBuffer;
        this.myMatcher = aktMatcher;
        this.skipped = true;
        return result;
    }

    private BigInteger myNextBigInteger(int radix, boolean delete, String name) {
        String tmp = this.myPrepareForNext(this.p, delete);
        try {
            tmp = this.myApplyLocale(tmp, radix);
            BigInteger rc = new BigInteger(tmp, radix);
            return rc;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ParseException parseException) {}
        throw new InputMismatchException(ERR_PREFIX + tmp + IS_NOT + name);
    }

    private boolean myNextBoolean(boolean delete) throws InputMismatchException {
        String tmp = this.myPrepareForNext(this.p, delete);
        if (tmp.equalsIgnoreCase("true")) {
            return true;
        }
        if (tmp.equalsIgnoreCase("false")) {
            return false;
        }
        throw new InputMismatchException(ERR_PREFIX + tmp + NOT_BOOLEAN);
    }

    private byte myNextByte(int radix, boolean delete) throws InputMismatchException {
        String tmp = this.myPrepareForNext(this.p, delete);
        try {
            tmp = this.myApplyLocale(tmp, radix);
            byte rc = Byte.parseByte(tmp, radix);
            return rc;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ParseException parseException) {}
        throw new InputMismatchException(ERR_PREFIX + tmp + NOT_BYTE);
    }

    private double myNextDouble(boolean delete) throws InputMismatchException {
        String tmp = this.myPrepareForNext(this.p, delete);
        try {
            tmp = this.myApplyLocale(tmp, 10);
            double rc = Double.parseDouble(tmp);
            if (("" + rc).equals(tmp)) {
                return rc;
            }
        }
        catch (ParseException parseException) {}
        throw new InputMismatchException(ERR_PREFIX + tmp + NOT_DOUBLE);
    }

    private int myNextInt(int radix, boolean delete) throws InputMismatchException {
        String tmp = this.myPrepareForNext(this.p, delete);
        try {
            tmp = this.myApplyLocale(tmp, radix);
            int rc = Integer.parseInt(tmp, radix);
            return rc;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ParseException parseException) {}
        throw new InputMismatchException(ERR_PREFIX + tmp + NOT_INT);
    }

    private String myNextLine(boolean delete) {
        return this.myPrepareForNext(Pattern.compile(NEW_LINE), delete);
    }

    private long myNextLong(int radix, boolean delete) throws InputMismatchException {
        String tmp = this.myPrepareForNext(this.p, delete);
        try {
            tmp = this.myApplyLocale(tmp, radix);
            long rc = Long.parseLong(tmp, radix);
            return rc;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ParseException parseException) {}
        throw new InputMismatchException(ERR_PREFIX + tmp + NOT_LONG);
    }

    private short myNextShort(int radix, boolean delete) throws InputMismatchException {
        String tmp = this.myPrepareForNext(this.p, delete);
        try {
            tmp = this.myApplyLocale(tmp, radix);
            short rc = Short.parseShort(tmp, radix);
            return rc;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ParseException parseException) {}
        throw new InputMismatchException(ERR_PREFIX + tmp + "\" is not a short");
    }

    private String myPrepareForNext(Pattern aktPattern, boolean delete) {
        Pattern oldPattern = this.p;
        this.useDelimiter(aktPattern);
        String rc = this.myCoreNext(delete, aktPattern);
        this.useDelimiter(oldPattern);
        return rc;
    }

    private boolean shallUseLastFound(Pattern aktP) {
        if (this.lastFoundPresent && this.lastPatternHash == aktP.hashCode() && this.last_RegionStart == this.myMatcher.regionStart() && this.last_anchor == this.myMatcher.hasAnchoringBounds() && this.last_transparent == this.myMatcher.hasTransparentBounds()) {
            if (this.last_RegionEnd != this.myMatcher.regionEnd()) {
                int tmpVal = this.myMatcher.regionEnd() - this.last_RegionEnd - 10000;
                if (tmpVal > 0 && tmpVal < 20) {
                    this.last_RegionEnd = this.myMatcher.regionEnd();
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

