/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelectionKey;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelector
extends Selector {
    private boolean closed;
    private SelectorProvider provider;
    private HashSet<SelectionKey> cancelledKeys;

    protected AbstractSelector(SelectorProvider provider) {
        this.provider = provider;
        this.cancelledKeys = new HashSet();
    }

    @Override
    public final synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.implCloseSelector();
        this.closed = true;
    }

    @Override
    public final boolean isOpen() {
        return !this.closed;
    }

    protected final void begin() {
    }

    protected final void end() {
    }

    @Override
    public final SelectorProvider provider() {
        return this.provider;
    }

    protected final Set<SelectionKey> cancelledKeys() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        return this.cancelledKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cancelKey(AbstractSelectionKey key) {
        HashSet<SelectionKey> hashSet = this.cancelledKeys;
        synchronized (hashSet) {
            this.cancelledKeys.add(key);
        }
    }

    protected abstract void implCloseSelector() throws IOException;

    protected abstract SelectionKey register(AbstractSelectableChannel var1, int var2, Object var3);

    protected final void deregister(AbstractSelectionKey key) {
        ((AbstractSelectableChannel)key.channel()).removeSelectionKey(key);
    }
}

