/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.ArrayList;

public class RenderableImageProducer
implements ImageProducer,
Runnable {
    private RenderableImage image;
    private RenderContext context;
    private ArrayList consumers = new ArrayList();

    public RenderableImageProducer(RenderableImage image, RenderContext context) {
        this.image = image;
        this.context = context;
    }

    public void setRenderContext(RenderContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(ImageConsumer consumer) {
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            if (!this.consumers.contains(consumer)) {
                this.consumers.add(consumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConsumer(ImageConsumer consumer) {
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            return this.consumers.contains(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(ImageConsumer consumer) {
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            this.consumers.remove(consumer);
        }
    }

    public void startProduction(ImageConsumer consumer) {
        this.addConsumer(consumer);
        Thread t = new Thread(this, "RenderableImageProducerWorker");
        t.start();
    }

    public void requestTopDownLeftRightResend(ImageConsumer consumer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            RenderedImage newImage = this.context == null ? this.image.createDefaultRendering() : this.image.createRendering(this.context);
            Raster newData = newImage.getData();
            ColorModel colorModel = newImage.getColorModel();
            if (colorModel == null) {
                colorModel = ColorModel.getRGBdefault();
            }
            SampleModel sampleModel = newData.getSampleModel();
            DataBuffer dataBuffer = newData.getDataBuffer();
            int width = newData.getWidth();
            int height = newData.getHeight();
            for (ImageConsumer target : this.consumers) {
                target.setHints(30);
                target.setDimensions(width, height);
            }
            int[] newLine = new int[width];
            int[] bands = new int[sampleModel.getNumBands()];
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    sampleModel.getPixel(x, y, bands, dataBuffer);
                    newLine[x] = colorModel.getDataElement(bands, 0);
                    ++x;
                }
                for (ImageConsumer target : this.consumers) {
                    target.setPixels(0, y, width, 1, colorModel, newLine, 0, width);
                }
                ++y;
            }
            for (ImageConsumer target : this.consumers) {
                target.imageComplete(3);
            }
        }
    }
}

