/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ReplicateScaleFilter;

public class AreaAveragingScaleFilter
extends ReplicateScaleFilter {
    public AreaAveragingScaleFilter(int width, int height) {
        super(width, height);
    }

    public void setHints(int flags) {
        if (this.consumer != null) {
            this.consumer.setHints(flags);
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        double rx = (double)this.srcWidth / (double)this.destWidth;
        double ry = (double)this.srcHeight / (double)this.destHeight;
        int destScansize = (int)Math.round((double)scansize / rx);
        byte[] destPixels = this.averagePixels(x, y, w, h, model, pixels, offset, scansize, rx, ry, destScansize);
        if (this.consumer != null) {
            this.consumer.setPixels((int)Math.floor((double)x / rx), (int)Math.floor((double)y / ry), (int)Math.ceil((double)w / rx), (int)Math.ceil((double)h / ry), model, destPixels, 0, destScansize);
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        double rx = (double)this.srcWidth / (double)this.destWidth;
        double ry = (double)this.srcHeight / (double)this.destHeight;
        int destScansize = (int)Math.round((double)scansize / rx);
        int[] destPixels = this.averagePixels(x, y, w, h, model, pixels, offset, scansize, rx, ry, destScansize);
        if (this.consumer != null) {
            this.consumer.setPixels((int)Math.floor((double)x / rx), (int)Math.floor((double)y / ry), (int)Math.ceil((double)w / rx), (int)Math.ceil((double)h / ry), model, destPixels, 0, destScansize);
        }
    }

    private byte[] averagePixels(int srcx, int srcy, int srcw, int srch, ColorModel model, byte[] srcPixels, int srcOffset, int srcScansize, double rx, double ry, int destScansize) {
        int destW = (int)Math.ceil((double)srcw / rx);
        int destH = (int)Math.ceil((double)srch / ry);
        byte[] destPixels = new byte[destW * destH];
        int w = (int)Math.ceil(rx);
        int h = (int)Math.ceil(ry);
        int x = 0;
        while (x < destW) {
            int y = 0;
            while (y < destH) {
                int sx = (int)((double)x * rx);
                int sy = (int)((double)y * ry);
                int a = 0;
                int b = 0;
                int g = 0;
                int r = 0;
                int i = 0;
                while (i < w) {
                    int j = 0;
                    while (j < h) {
                        int idx = srcx + sx + i + (srcy + sy + j) * srcScansize;
                        r += model.getRed(srcPixels[idx]);
                        g += model.getGreen(srcPixels[idx]);
                        b += model.getBlue(srcPixels[idx]);
                        a += model.getAlpha(srcPixels[idx]);
                        ++j;
                    }
                    ++i;
                }
                destPixels[x + destScansize * y] = (byte)model.getDataElement(new int[]{r /= w * h, g /= w * h, b /= w * h, a /= w * h}, 0);
                ++y;
            }
            ++x;
        }
        return destPixels;
    }

    private int[] averagePixels(int srcx, int srcy, int srcw, int srch, ColorModel model, int[] srcPixels, int srcOffset, int srcScansize, double rx, double ry, int destScansize) {
        int destW = (int)Math.ceil((double)srcw / rx);
        int destH = (int)Math.ceil((double)srch / ry);
        int[] destPixels = new int[destW * destH];
        int w = (int)Math.ceil(rx);
        int h = (int)Math.ceil(ry);
        int x = 0;
        while (x < destW) {
            int y = 0;
            while (y < destH) {
                int sx = (int)((double)x * rx);
                int sy = (int)((double)y * ry);
                int a = 0;
                int b = 0;
                int g = 0;
                int r = 0;
                int i = 0;
                while (i < w) {
                    int j = 0;
                    while (j < h) {
                        int idx = srcx + sx + i + (srcy + sy + j) * srcScansize;
                        r += model.getRed(srcPixels[idx]);
                        g += model.getGreen(srcPixels[idx]);
                        b += model.getBlue(srcPixels[idx]);
                        a += model.getAlpha(srcPixels[idx]);
                        ++j;
                    }
                    ++i;
                }
                destPixels[x + destScansize * y] = model.getDataElement(new int[]{r /= w * h, g /= w * h, b /= w * h, a /= w * h}, 0);
                ++y;
            }
            ++x;
        }
        return destPixels;
    }
}

