/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.css;

import gnu.javax.swing.text.html.css.CSSParserCallback;
import gnu.javax.swing.text.html.css.CSSParserException;
import gnu.javax.swing.text.html.css.CSSScanner;
import gnu.javax.swing.text.html.css.Selector;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.StringTokenizer;

public class CSSParser {
    private CSSScanner scanner;
    private CSSParserCallback callback;
    private int lookahead;
    private String error;

    public CSSParser(Reader in, CSSParserCallback cb) {
        this.scanner = new CSSScanner(in);
        this.callback = cb;
        this.lookahead = -1;
    }

    public void parse() throws IOException {
        boolean success = this.parseStylesheet();
        if (!success) {
            throw new CSSParserException(this.error);
        }
    }

    private boolean parseStylesheet() throws IOException {
        int token = this.peekToken();
        while (token != -1 && (token == 12 || token == 11 || token == 18 || this.parseStatement())) {
            if (token == 12 || token == 11 || token == 18) {
                this.readToken();
            }
            token = this.peekToken();
        }
        return token == -1;
    }

    private boolean parseStatement() throws IOException {
        return this.parseRuleset() || this.parseAtRule();
    }

    private boolean parseRuleset() throws IOException {
        int token;
        StringBuilder selector = new StringBuilder();
        this.parseSelector(selector);
        StringTokenizer selSplitter = new StringTokenizer(selector.toString(), ",");
        Selector[] sels = new Selector[selSplitter.countTokens()];
        int i = 0;
        while (selSplitter.hasMoreTokens()) {
            String sel = selSplitter.nextToken().trim();
            sels[i] = new Selector(sel);
            ++i;
        }
        this.callback.startStatement(sels);
        while ((token = this.readToken()) == 18) {
        }
        boolean ret = true;
        if (token == 14) {
            while ((token = this.readToken()) == 18) {
            }
            this.lookahead = token;
            this.parseDeclaration();
            token = this.peekToken();
            while (token == 13) {
                this.readToken();
                while ((token = this.readToken()) == 18) {
                }
                this.lookahead = token;
                this.parseDeclaration();
                token = this.peekToken();
            }
            if (token != 15) {
                this.error = "Expected right curly brace";
                ret = false;
            } else {
                this.readToken();
                while ((token = this.readToken()) == 18) {
                }
                this.lookahead = token;
                this.callback.endStatement();
            }
        } else {
            ret = false;
            this.error = "Expected left curly brace";
        }
        return ret;
    }

    private boolean parseDeclaration() throws IOException {
        int token = this.readToken();
        if (token == 23) {
            token = this.readToken();
        }
        boolean ret = true;
        String property = null;
        if (token == 1) {
            property = new String(this.scanner.parseBuffer, 0, this.scanner.tokenEnd);
            while ((token = this.readToken()) == 18) {
            }
            if (token == 23 && this.scanner.parseBuffer[0] == ':') {
                while ((token = this.readToken()) == 18) {
                }
                this.lookahead = token;
                StringBuilder value = new StringBuilder();
                if (this.parseValue(value)) {
                    this.callback.declaration(property, value.toString().trim());
                } else {
                    ret = false;
                    this.error = "Error while reading the property value";
                }
            } else {
                ret = false;
                this.error = "Expected colon to separate property and value";
            }
        } else {
            this.lookahead = token;
            ret = false;
            this.error = "Expected IDENT token for property";
        }
        return ret;
    }

    private boolean parseValue(StringBuilder s) throws IOException {
        boolean success = this.parseAny(s);
        while (this.parseAny(s)) {
        }
        return success;
    }

    private boolean parseSelector(StringBuilder sel) throws IOException {
        boolean ret = this.parseAny(sel);
        if (ret) {
            while (this.parseAny(sel)) {
            }
        }
        return ret;
    }

    private boolean parseAny(StringBuilder s) throws IOException {
        int token = this.peekToken();
        boolean ret = false;
        if (token == 1 || token == 6 || token == 7 || token == 8 || token == 3 || token == 23 || token == 9 || token == 5 || token == 10 || token == 21 || token == 22) {
            if (s != null) {
                s.append(this.scanner.parseBuffer, 0, this.scanner.tokenEnd);
            }
            this.readToken();
            ret = true;
        } else if (token == 20) {
            System.err.println("Implement parseAny for FUNCTION");
        } else if (token == 16) {
            System.err.println("Implement parseAny for (");
        } else if (token == 16) {
            System.err.println("Implement parseAny for [");
        }
        token = this.peekToken();
        while (token == 18) {
            if (s != null) {
                s.append(this.scanner.parseBuffer, 0, this.scanner.tokenEnd);
            }
            this.readToken();
            token = this.peekToken();
        }
        return ret;
    }

    private boolean parseAtRule() throws IOException {
        return false;
    }

    private int readToken() throws IOException {
        int token;
        if (this.lookahead == -1) {
            while ((token = this.scanner.nextToken()) == 19) {
            }
        } else {
            token = this.lookahead;
            this.lookahead = -1;
        }
        return token;
    }

    private int peekToken() throws IOException {
        int token;
        if (this.lookahead == -1) {
            while ((token = this.scanner.nextToken()) == 19) {
            }
            this.lookahead = token;
        } else {
            token = this.lookahead;
        }
        return token;
    }

    public static void main(String[] args) {
        try {
            InputStream in;
            if (args.length > 0) {
                File file = new File(args[0]);
                in = new FileInputStream(file);
            } else {
                String name = "/javax/swing/text/html/default.css";
                in = CSSScanner.class.getResourceAsStream(name);
            }
            BufferedInputStream bin = new BufferedInputStream(in);
            InputStreamReader r = new InputStreamReader(bin);
            CSSParserCallback cb = new CSSParserCallback(){

                public void startStatement(Selector[] selector) {
                    System.out.print("startStatement: ");
                    int i = 0;
                    while (i < selector.length) {
                        System.out.print(selector[i]);
                        if (i < selector.length - 1) {
                            System.out.print(',');
                        } else {
                            System.out.println();
                        }
                        ++i;
                    }
                }

                public void endStatement() {
                    System.out.println("endStatement");
                }

                public void declaration(String property, String value) {
                    System.out.println("declaration: " + property + ", " + value);
                }
            };
            CSSParser p = new CSSParser(r, cb);
            p.parse();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

