/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPEncoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public class EncodeRLE4
extends BMPEncoder {
    protected BMPInfoHeader infoHeader;
    protected BMPFileHeader fileHeader;
    protected long offset;
    private static final byte ESCAPE = 0;
    private static final byte EOL = 0;
    private static final byte EOB = 1;
    private static final byte DELTA = 2;

    public EncodeRLE4(BMPFileHeader fh, BMPInfoHeader ih) {
        this.fileHeader = fh;
        this.infoHeader = ih;
        this.offset = 54L;
    }

    public void encode(ImageOutputStream o, IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        int rowIndex;
        int size = this.infoHeader.biWidth * this.infoHeader.biHeight - 1;
        int rowCount = 1;
        int lastRowIndex = rowIndex = size - this.infoHeader.biWidth;
        ByteBuffer buf = ByteBuffer.allocate(size);
        try {
            int[] bitmap = new int[this.infoHeader.biWidth * this.infoHeader.biHeight];
            PixelGrabber pg = new PixelGrabber((BufferedImage)image.getRenderedImage(), 0, 0, this.infoHeader.biWidth, this.infoHeader.biHeight, bitmap, 0, this.infoHeader.biWidth);
            pg.grabPixels();
            int j = 0;
            while (j < size) {
                int value = bitmap[rowIndex];
                buf.put((byte)(value & 0xFF));
                if (rowCount == this.infoHeader.biWidth) {
                    rowCount = 1;
                    lastRowIndex = rowIndex = lastRowIndex - this.infoHeader.biWidth;
                } else {
                    ++rowCount;
                }
                ++rowIndex;
                ++j;
            }
            buf.flip();
            o.write(this.uncompress(this.infoHeader.biWidth, this.infoHeader.biHeight, buf));
        }
        catch (Exception wb) {
            wb.printStackTrace();
        }
    }

    private byte[] uncompress(int w, int h, ByteBuffer buf) throws IOException {
        byte[] cmd = new byte[2];
        byte[] data = new byte[w * h >> 1];
        int x = 0;
        int y = 0;
        w += w & 1;
        w >>= 1;
        try {
            while ((x >> 1) + y * w < w * h) {
                int i;
                try {
                    buf.get(cmd);
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    throw new IOException("Error reading compressed data.");
                }
                if (cmd[0] == 0) {
                    switch (cmd[1]) {
                        case 1: {
                            return data;
                        }
                        case 0: {
                            x = 0;
                            ++y;
                            break;
                        }
                        case 2: {
                            try {
                                buf.get(cmd);
                            }
                            catch (BufferUnderflowException bufferUnderflowException) {
                                throw new IOException("Error reading compressed data.");
                            }
                            int dx = cmd[0] & 0xFF;
                            int dy = cmd[1] & 0xFF;
                            x += dx;
                            y += dy;
                            break;
                        }
                        default: {
                            int length;
                            int bytesize = length = cmd[1] & 0xFF;
                            bytesize += bytesize & 1;
                            bytesize >>= 1;
                            bytesize += bytesize & 1;
                            byte[] run = new byte[bytesize];
                            try {
                                buf.get(run);
                            }
                            catch (BufferUnderflowException bufferUnderflowException) {
                                throw new IOException("Error reading compressed data.");
                            }
                            if ((x & 1) == 0) {
                                length += length & 1;
                                System.arraycopy(run, 0, data, (x >> 1) + w * (h - y - 1), length >>= 1);
                            } else {
                                int i2 = 0;
                                while (i2 < length) {
                                    if ((i2 & 1) == 0) {
                                        int n = (x + i2 >> 1) + w * (h - y - 1);
                                        data[n] = (byte)(data[n] | (run[i2 >> 1] & 0xF0) >> 4);
                                    } else {
                                        int n = (x + i2 >> 1) + w * (h - y - 1);
                                        data[n] = (byte)(data[n] | (run[i2 >> 1] & 0xF) << 4);
                                    }
                                    ++i2;
                                }
                            }
                            x += cmd[1] & 0xFF;
                            break;
                        }
                    }
                    continue;
                }
                int length = cmd[0] & 0xFF;
                if ((x & 1) == 0) {
                    length += length & 1;
                    length >>= 1;
                    i = 0;
                    while (i < length) {
                        data[(h - y - 1) * w + i + (x >> 1)] = cmd[1];
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < length) {
                        if ((i & 1) == 0) {
                            int n = (x + i >> 1) + w * (h - y - 1);
                            data[n] = (byte)(data[n] | (cmd[1] & 0xF0) >> 4);
                        } else {
                            int n = (x + i >> 1) + w * (h - y - 1);
                            data[n] = (byte)(data[n] | (cmd[1] & 0xF) << 4);
                        }
                        ++i;
                    }
                }
                x += cmd[0] & 0xFF;
            }
            return data;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BMPException("Invalid RLE data.");
        }
    }
}

