/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.util.Date;

public class PrivateKeyUsagePeriod
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.16");
    private final Date notBefore;
    private final Date notAfter;

    public PrivateKeyUsagePeriod(byte[] encoded) throws IOException {
        super(encoded);
        DERReader der = new DERReader(encoded);
        DERValue val = der.read();
        if (!val.isConstructed()) {
            throw new IOException("malformed PrivateKeyUsagePeriod");
        }
        if (val.getLength() > 0) {
            val = der.read();
        }
        if (val.getTagClass() == 64 || val.getTag() == 0) {
            this.notBefore = (Date)val.getValueAs(24);
            val = der.read();
        } else {
            this.notBefore = null;
        }
        this.notAfter = val.getTagClass() == 64 || val.getTag() == 1 ? (Date)val.getValueAs(24) : null;
    }

    public Date getNotBefore() {
        return this.notBefore != null ? (Date)this.notBefore.clone() : null;
    }

    public Date getNotAfter() {
        return this.notAfter != null ? (Date)this.notAfter.clone() : null;
    }

    public String toString() {
        return String.valueOf(PrivateKeyUsagePeriod.class.getName()) + " [ notBefore=" + this.notBefore + " notAfter=" + this.notAfter + " ]";
    }
}

