/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.dss;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.key.dss.DSSPrivateKey;
import gnu.java.security.util.DerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.logging.Logger;

public class DSSKeyPairPKCS8Codec
implements IKeyPairCodec {
    private static final Logger log = Logger.getLogger(DSSKeyPairPKCS8Codec.class.getName());
    private static final OID DSA_ALG_OID = new OID("1.2.840.10040.4.1");

    public int getFormatID() {
        return 3;
    }

    public byte[] encodePublicKey(PublicKey key) {
        throw new InvalidParameterException("Wrong format for public keys");
    }

    public byte[] encodePrivateKey(PrivateKey key) {
        byte[] result;
        if (!(key instanceof DSSPrivateKey)) {
            throw new InvalidParameterException("Wrong key type");
        }
        DERValue derVersion = new DERValue(2, BigInteger.ZERO);
        DERValue derOID = new DERValue(6, DSA_ALG_OID);
        DSSPrivateKey pk = (DSSPrivateKey)key;
        BigInteger p = pk.getParams().getP();
        BigInteger q = pk.getParams().getQ();
        BigInteger g = pk.getParams().getG();
        BigInteger x = pk.getX();
        ArrayList<DERValue> params = new ArrayList<DERValue>(3);
        params.add(new DERValue(2, p));
        params.add(new DERValue(2, q));
        params.add(new DERValue(2, g));
        DERValue derParams = new DERValue(48, params);
        ArrayList<DERValue> algorithmID = new ArrayList<DERValue>(2);
        algorithmID.add(derOID);
        algorithmID.add(derParams);
        DERValue derAlgorithmID = new DERValue(48, algorithmID);
        DERValue derX = new DERValue(2, x);
        DERValue derPrivateKey = new DERValue(4, derX.getEncoded());
        ArrayList<DERValue> pki = new ArrayList<DERValue>(3);
        pki.add(derVersion);
        pki.add(derAlgorithmID);
        pki.add(derPrivateKey);
        DERValue derPKI = new DERValue(48, pki);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DERWriter.write(baos, derPKI);
            result = baos.toByteArray();
        }
        catch (IOException e) {
            InvalidParameterException y = new InvalidParameterException(e.getMessage());
            y.initCause(e);
            throw y;
        }
        return result;
    }

    public PublicKey decodePublicKey(byte[] input) {
        throw new InvalidParameterException("Wrong format for public keys");
    }

    public PrivateKey decodePrivateKey(byte[] input) {
        BigInteger x;
        BigInteger g;
        BigInteger q;
        BigInteger p;
        if (input == null) {
            throw new InvalidParameterException("Input bytes MUST NOT be null");
        }
        DERReader der = new DERReader(input);
        try {
            DERValue derPKI = der.read();
            DerUtil.checkIsConstructed(derPKI, "Wrong PrivateKeyInfo field");
            DERValue derVersion = der.read();
            if (!(derVersion.getValue() instanceof BigInteger)) {
                throw new InvalidParameterException("Wrong Version field");
            }
            BigInteger version = (BigInteger)derVersion.getValue();
            if (version.compareTo(BigInteger.ZERO) != 0) {
                throw new InvalidParameterException("Unexpected Version: " + version);
            }
            DERValue derAlgoritmID = der.read();
            DerUtil.checkIsConstructed(derAlgoritmID, "Wrong AlgorithmIdentifier field");
            DERValue derOID = der.read();
            OID algOID = (OID)derOID.getValue();
            if (!algOID.equals(DSA_ALG_OID)) {
                throw new InvalidParameterException("Unexpected OID: " + algOID);
            }
            DERValue derParams = der.read();
            DerUtil.checkIsConstructed(derParams, "Wrong DSS Parameters field");
            DERValue val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong P field");
            p = (BigInteger)val.getValue();
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong Q field");
            q = (BigInteger)val.getValue();
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong G field");
            g = (BigInteger)val.getValue();
            val = der.read();
            byte[] xBytes = (byte[])val.getValue();
            DERReader der2 = new DERReader(xBytes);
            val = der2.read();
            DerUtil.checkIsBigInteger(val, "Wrong X field");
            x = (BigInteger)val.getValue();
        }
        catch (IOException e) {
            InvalidParameterException y = new InvalidParameterException(e.getMessage());
            y.initCause(e);
            throw y;
        }
        return new DSSPrivateKey(3, p, q, g, x);
    }
}

