/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.VolatileImageGraphics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;

public class GtkVolatileImage
extends VolatileImage {
    int width;
    int height;
    private ImageCapabilities caps;
    final GtkComponentPeer component;
    static ColorModel gdkColorModel = new DirectColorModel(32, 255, 65280, 0xFF0000, -16777216);
    long nativePointer;

    native long init(GtkComponentPeer var1, int var2, int var3);

    native void destroy(long var1);

    native int[] nativeGetPixels(long var1);

    public int[] getPixels() {
        return this.nativeGetPixels(this.nativePointer);
    }

    native void nativeCopyArea(long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    public void copyArea(int x, int y, int w, int h, int dx, int dy) {
        this.nativeCopyArea(this.nativePointer, x, y, w, h, dx, dy);
    }

    native void nativeDrawVolatile(long var1, long var3, int var5, int var6, int var7, int var8);

    public void drawVolatile(long srcPtr, int x, int y, int w, int h) {
        this.nativeDrawVolatile(this.nativePointer, srcPtr, x, y, w, h);
    }

    public GtkVolatileImage(GtkComponentPeer component, int width, int height, ImageCapabilities caps) {
        this.width = width;
        this.height = height;
        this.caps = caps;
        this.component = component;
        this.nativePointer = this.init(component, width, height);
    }

    public GtkVolatileImage(int width, int height, ImageCapabilities caps) {
        this(null, width, height, caps);
    }

    public GtkVolatileImage(int width, int height) {
        this(null, width, height, null);
    }

    public void finalize() {
        this.dispose();
    }

    public void dispose() {
        this.destroy(this.nativePointer);
    }

    public BufferedImage getSnapshot() {
        WritableRaster raster = Raster.createWritableRaster(GtkVolatileImage.createGdkSampleModel(this.width, this.height), new Point(0, 0));
        raster.setDataElements(0, 0, this.getPixels());
        return new BufferedImage(gdkColorModel, raster, gdkColorModel.isAlphaPremultiplied(), null);
    }

    public Graphics getGraphics() {
        return this.createGraphics();
    }

    public Graphics2D createGraphics() {
        return new VolatileImageGraphics(this);
    }

    public int validate(GraphicsConfiguration gc) {
        return 0;
    }

    public boolean contentsLost() {
        return false;
    }

    public ImageCapabilities getCapabilities() {
        return this.caps;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth(ImageObserver observer) {
        return this.width;
    }

    public int getHeight(ImageObserver observer) {
        return this.height;
    }

    public Object getProperty(String name, ImageObserver observer) {
        return null;
    }

    protected static SampleModel createGdkSampleModel(int w, int h) {
        return new SinglePixelPackedSampleModel(3, w, h, new int[]{255, 65280, 0xFF0000, -16777216});
    }
}

