/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import gnu.java.math.Fixed;

final class PolyEdge
implements Comparable {
    public int x0;
    public int y0;
    public int x1;
    public int y1;
    private int slope;
    int xIntersection;
    boolean isClip;
    PolyEdge poolNext;
    PolyEdge scanlineNext;

    PolyEdge() {
    }

    PolyEdge(int n, int x0, int y0, int x1, int y1, boolean clip) {
        this.init(n, x0, y0, x1, y1, clip);
    }

    void init(int n, int x0, int y0, int x1, int y1, boolean clip) {
        this.isClip = clip;
        if (y0 < y1) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
        } else {
            this.x0 = x1;
            this.y0 = y1;
            this.x1 = x0;
            this.y1 = y0;
        }
        this.slope = Fixed.div(n, this.x1 - this.x0, this.y1 - this.y0);
    }

    public int compareTo(Object o) {
        PolyEdge other = (PolyEdge)o;
        int comp = 0;
        if (this.x0 < other.x0) {
            comp = -1;
        } else if (this.x0 > other.x0) {
            comp = 1;
        }
        return comp;
    }

    void intersect(int n, int y) {
        int dy = y - this.y0;
        int dx = Fixed.mul(n, this.slope, dy);
        this.xIntersection = this.x0 + dx;
    }

    public String toString() {
        return "Edge: " + this.x0 + ", " + this.y0 + ", " + this.x1 + ", " + this.y1 + ", slope: " + this.slope + ", xIntersection: " + this.xIntersection + ", isClip: " + this.isClip;
    }
}

