/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath;

import java.util.Properties;

public class SystemProperties {
    private static Properties properties;
    private static final Properties defaultProperties;

    static {
        defaultProperties = new Properties();
        SystemProperties.insertSystemProperties(defaultProperties);
        defaultProperties.put("gnu.classpath.version", "0.98");
        if (defaultProperties.get("gnu.classpath.home.url") == null) {
            defaultProperties.put("gnu.classpath.home.url", "file://" + defaultProperties.get("gnu.classpath.home") + "/lib");
        }
        if (defaultProperties.get("gnu.classpath.vm.shortname") == null) {
            String value = defaultProperties.getProperty("java.vm.name");
            int index = value.lastIndexOf(32);
            if (index != -1) {
                value = value.substring(index + 1);
            }
            defaultProperties.put("gnu.classpath.vm.shortname", value);
        }
        if (defaultProperties.get("http.agent") == null) {
            String userAgent = "gnu-classpath/" + defaultProperties.getProperty("gnu.classpath.version") + " (" + defaultProperties.getProperty("gnu.classpath.vm.shortname") + "/" + defaultProperties.getProperty("java.vm.version") + ")";
            defaultProperties.put("http.agent", userAgent);
        }
        defaultProperties.put("gnu.cpu.endian", SystemProperties.isWordsBigEndian() ? "big" : "little");
        if (defaultProperties.get("java.io.tmpdir") == null) {
            defaultProperties.put("java.io.tmpdir", defaultProperties.get("java.tmpdir"));
        }
        properties = (Properties)defaultProperties.clone();
    }

    private static native void insertSystemProperties(Properties var0);

    public static String getProperty(String name) {
        return properties.getProperty(name);
    }

    public static String getProperty(String name, String defaultValue) {
        return properties.getProperty(name, defaultValue);
    }

    public static String setProperty(String name, String value) {
        return (String)properties.setProperty(name, value);
    }

    public static Properties getProperties() {
        return properties;
    }

    public static void setProperties(Properties properties) {
        if (properties == null) {
            properties = (Properties)defaultProperties.clone();
        }
        SystemProperties.properties = properties;
    }

    private static native boolean isWordsBigEndian();

    public static String remove(String name) {
        return (String)properties.remove(name);
    }
}

