/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.objectweb.asm.util.CheckAnnotationAdapter;
import org.objectweb.asm.util.CheckFieldAdapter;
import org.objectweb.asm.util.CheckMethodAdapter;
import org.objectweb.asm.util.TraceMethodVisitor;

public class CheckClassAdapter
extends ClassAdapter {
    private boolean start;
    private boolean source;
    private boolean outer;
    private boolean end;

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Verifies the given class.");
            System.err.println("Usage: CheckClassAdapter <fully qualified class name or class file name>");
            return;
        }
        ClassReader cr = args[0].endsWith(".class") ? new ClassReader(new FileInputStream(args[0])) : new ClassReader(args[0]);
        CheckClassAdapter.verify(cr, false, new PrintWriter(System.err));
    }

    public static void verify(ClassReader cr, boolean dump, PrintWriter pw) {
        ClassNode cn = new ClassNode();
        cr.accept(new CheckClassAdapter(cn), true);
        List methods = cn.methods;
        int i = 0;
        while (i < methods.size()) {
            block12: {
                MethodNode method = (MethodNode)methods.get(i);
                if (method.instructions.size() > 0) {
                    Analyzer a;
                    block11: {
                        a = new Analyzer(new SimpleVerifier(Type.getType("L" + cn.name + ";"), Type.getType("L" + cn.superName + ";"), (cn.access & 0x200) != 0));
                        try {
                            a.analyze(cn.name, method);
                            if (dump) break block11;
                            break block12;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Frame[] frames = a.getFrames();
                    TraceMethodVisitor mv = new TraceMethodVisitor();
                    pw.println(String.valueOf(method.name) + method.desc);
                    int j = 0;
                    while (j < method.instructions.size()) {
                        ((AbstractInsnNode)method.instructions.get(j)).accept(mv);
                        StringBuffer s = new StringBuffer();
                        Frame f = frames[j];
                        if (f == null) {
                            s.append('?');
                        } else {
                            int k = 0;
                            while (k < f.getLocals()) {
                                s.append(CheckClassAdapter.getShortName(f.getLocal(k).toString())).append(' ');
                                ++k;
                            }
                            s.append(" : ");
                            k = 0;
                            while (k < f.getStackSize()) {
                                s.append(CheckClassAdapter.getShortName(f.getStack(k).toString())).append(' ');
                                ++k;
                            }
                        }
                        while (s.length() < method.maxStack + method.maxLocals + 1) {
                            s.append(' ');
                        }
                        pw.print(Integer.toString(j + 100000).substring(1));
                        pw.print(" " + s + " : " + mv.buf);
                        ++j;
                    }
                    j = 0;
                    while (j < method.tryCatchBlocks.size()) {
                        ((TryCatchBlockNode)method.tryCatchBlocks.get(j)).accept(mv);
                        pw.print(" " + mv.buf);
                        ++j;
                    }
                    pw.println();
                }
            }
            ++i;
        }
    }

    private static String getShortName(String name) {
        int n = name.lastIndexOf(47);
        int k = name.length();
        if (name.charAt(k - 1) == ';') {
            --k;
        }
        return n == -1 ? name : name.substring(n + 1, k);
    }

    public CheckClassAdapter(ClassVisitor cv) {
        super(cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.start) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.start = true;
        this.checkState();
        CheckClassAdapter.checkAccess(access, 161329);
        CheckMethodAdapter.checkInternalName(name, "class name");
        if ("java/lang/Object".equals(name)) {
            if (superName != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else {
            CheckMethodAdapter.checkInternalName(superName, "super class name");
        }
        if ((access & 0x200) != 0 && !"java/lang/Object".equals(superName)) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (interfaces != null) {
            int i = 0;
            while (i < interfaces.length) {
                CheckMethodAdapter.checkInternalName(interfaces[i], "interface name at index " + i);
                ++i;
            }
        }
        this.cv.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitSource(String file, String debug) {
        this.checkState();
        if (this.source) {
            throw new IllegalStateException("visitSource can be called only once.");
        }
        this.source = true;
        this.cv.visitSource(file, debug);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.checkState();
        if (this.outer) {
            throw new IllegalStateException("visitSource can be called only once.");
        }
        this.outer = true;
        if (owner == null) {
            throw new IllegalArgumentException("Illegal outer class owner");
        }
        if (desc != null) {
            CheckMethodAdapter.checkMethodDesc(desc);
        }
        this.cv.visitOuterClass(owner, name, desc);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(name, "class name");
        if (outerName != null) {
            CheckMethodAdapter.checkInternalName(outerName, "outer class name");
        }
        if (innerName != null) {
            CheckMethodAdapter.checkIdentifier(innerName, "inner class name");
        }
        CheckClassAdapter.checkAccess(access, 30239);
        this.cv.visitInnerClass(name, outerName, innerName, access);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.checkState();
        CheckClassAdapter.checkAccess(access, 151775);
        CheckMethodAdapter.checkIdentifier(name, "field name");
        CheckMethodAdapter.checkDesc(desc, false);
        if (value != null) {
            CheckMethodAdapter.checkConstant(value);
        }
        FieldVisitor av = this.cv.visitField(access, name, desc, signature, value);
        return new CheckFieldAdapter(av);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.checkState();
        CheckClassAdapter.checkAccess(access, 138751);
        CheckMethodAdapter.checkMethodIdentifier(name, "method name");
        CheckMethodAdapter.checkMethodDesc(desc);
        if (exceptions != null) {
            int i = 0;
            while (i < exceptions.length) {
                CheckMethodAdapter.checkInternalName(exceptions[i], "exception name at index " + i);
                ++i;
            }
        }
        return new CheckMethodAdapter(this.cv.visitMethod(access, name, desc, signature, exceptions));
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.checkState();
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(this.cv.visitAnnotation(desc, visible));
    }

    public void visitAttribute(Attribute attr) {
        this.checkState();
        if (attr == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        this.cv.visitAttribute(attr);
    }

    public void visitEnd() {
        this.checkState();
        this.end = true;
        this.cv.visitEnd();
    }

    private void checkState() {
        if (!this.start) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.end) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int access, int possibleAccess) {
        int abs;
        int pro;
        if ((access & ~possibleAccess) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + access);
        }
        int pub = (access & 1) != 0 ? 1 : 0;
        int pri = (access & 2) != 0 ? 1 : 0;
        int n = pro = (access & 4) != 0 ? 1 : 0;
        if (pub + pri + pro > 1) {
            throw new IllegalArgumentException("public private and protected are mutually exclusive: " + access);
        }
        int fin = (access & 0x10) != 0 ? 1 : 0;
        int n2 = abs = (access & 0x400) != 0 ? 1 : 0;
        if (fin + abs > 1) {
            throw new IllegalArgumentException("final and abstract are mutually exclusive: " + access);
        }
    }
}

