/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.orbd;

import gnu.CORBA.IOR;
import gnu.CORBA.NamingService.Ext;
import gnu.CORBA.OrbFunctional;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.orbd.Messages;
import gnu.classpath.tools.orbd.PersistentContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContext;

public class Main {
    public static final int PORT = 900;
    private int port = 900;
    private String iorf;
    private boolean cold;
    private String directory = "";

    public static byte[] getDefaultKey() {
        try {
            return "NameService".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("UTF-8 unsupported");
        }
    }

    private Parser initializeParser() {
        ClasspathToolParser parser = new ClasspathToolParser("orbd", true);
        parser.setHeader(Messages.getString("Main.Usage"));
        parser.add(new Option("ORBInitialPort", Messages.getString("Main.ORBInitialPort"), Messages.getString("Main.Port")){

            public void parsed(String portArgument) throws OptionException {
                Main.this.port = Integer.parseInt(portArgument);
            }
        });
        parser.add(new Option("ior", Messages.getString("Main.IOR"), Messages.getString("Main.IORFile")){

            public void parsed(String fileArgument) throws OptionException {
                Main.this.iorf = fileArgument;
            }
        });
        parser.add(new Option("directory", Messages.getString("Main.Directory"), Messages.getString("Main.DirectoryArgument")){

            public void parsed(String argument) throws OptionException {
                Main.this.directory = argument;
            }
        });
        parser.add(new Option("restart", Messages.getString("Main.Restart")){

            public void parsed(String argument) throws OptionException {
                Main.this.cold = true;
            }
        });
        return parser;
    }

    private void run(String[] args) {
        Parser parser = this.initializeParser();
        parser.parse(args);
        try {
            try {
                final OrbFunctional orb = new OrbFunctional();
                OrbFunctional.setPort((int)this.port);
                File dataDirectory = new File(this.directory);
                System.out.println("Persistent data stored at " + dataDirectory.getAbsolutePath());
                dataDirectory.mkdirs();
                Ext namer = new Ext((NamingContext)new PersistentContext((ORB)orb, dataDirectory, this.cold));
                orb.connect((Object)namer, "NameService".getBytes());
                String ior = orb.object_to_string((Object)namer);
                IOR iorr = IOR.parse((String)ior);
                if (this.iorf != null) {
                    FileOutputStream f = new FileOutputStream(this.iorf);
                    PrintStream p = new PrintStream(f);
                    p.print(ior);
                    p.close();
                }
                System.out.println("GNU Classpath persistent naming service started at " + iorr.Internet.host + ":" + iorr.Internet.port + " key 'NameService'.\n\n" + "Copyright (C) 2010 Free Software Foundation\n" + "This tool comes with ABSOLUTELY NO WARRANTY. " + "This is free software, and you are\nwelcome to " + "redistribute it under conditions, defined in " + "GNU Classpath license.\n\n" + ior);
                new Thread(){

                    public void run() {
                        orb.run();
                    }
                }.start();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            OrbFunctional.setPort((int)OrbFunctional.DEFAULT_INITIAL_PORT);
        }
    }

    public static void main(String[] args) {
        Main orbdprogram = new Main();
        try {
            orbdprogram.run(args);
        }
        catch (Exception e) {
            System.err.println(Messages.getString("Main.InternalError"));
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

