/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;

public class IOToolkit {
    private IOToolkit() {
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int nread;
        byte[] buf = new byte[256];
        while ((nread = in.read(buf)) >= 0) {
            out.write(buf, 0, nread);
        }
    }

    public static void copyStream(Reader in, Writer out) throws IOException {
        int nread;
        char[] buf = new char[256];
        while ((nread = in.read(buf)) >= 0) {
            out.write(buf, 0, nread);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyDirectory(File sourceDir, File targetDir, boolean recursive, Set excludeDirs) throws IOException {
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new IOException("Cannot create directory " + targetDir);
        }
        File[] sourceFiles = sourceDir.listFiles();
        int i = 0;
        while (i < sourceFiles.length) {
            if (sourceFiles[i].isDirectory()) {
                if (recursive && (excludeDirs == null || !excludeDirs.contains(sourceFiles[i].getName()))) {
                    File targetSubDir = new File(targetDir, sourceFiles[i].getName());
                    if (!targetSubDir.exists() && !targetSubDir.mkdir()) throw new IOException("Cannot create directory " + targetSubDir);
                    IOToolkit.copyDirectory(sourceFiles[i], targetSubDir, recursive, null);
                }
            } else {
                IOToolkit.copyFile(sourceFiles[i], new File(targetDir, sourceFiles[i].getName()));
            }
            ++i;
        }
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        int nread;
        FileInputStream in = new FileInputStream(sourceFile);
        FileOutputStream out = new FileOutputStream(targetFile);
        byte[] buf = new byte[512];
        while ((nread = ((InputStream)in).read(buf)) >= 0) {
            ((OutputStream)out).write(buf, 0, nread);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static char[] readFully(Reader reader) throws IOException {
        int nread;
        StringWriter writer = new StringWriter();
        char[] chunk = new char[256];
        while ((nread = reader.read(chunk)) >= 0) {
            writer.write(chunk, 0, nread);
        }
        StringBuffer buffer = writer.getBuffer();
        char[] result = new char[buffer.length()];
        buffer.getChars(0, buffer.length(), result, 0);
        return result;
    }

    public static String getLineFromFile(File file, int line) throws IOException {
        FileReader reader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(reader);
        while (line > 1) {
            bufferedReader.readLine();
            --line;
        }
        String result = bufferedReader.readLine();
        reader.close();
        return result;
    }

    public static String getColumnDisplayLine(int column) {
        StringBuffer result = new StringBuffer();
        while (column > 0) {
            result.append(' ');
            --column;
        }
        result.append('^');
        return result.toString();
    }
}

