var Grafico={Version:"0.9",Base:{},BaseGraph:{},Normaliser:{},LineGraph:{},AreaGraph:{},StackGraph:{},StreamGraph:{},BarGraph:{},StackedBarGraph:{},HorizontalBarGraph:{},SparkLine:{},SparkBar:{}};
Grafico.Base=Class.create({normaliseData:function(a){return $A(a).collect(function(b){return this.normalise(b)}.bind(this))},deepCopy:function(a){var b,c,d;if(Object.prototype.toString.call(a)==="[object Array]"){b=[];d=a.length;for(c=0;c<d;c++)b[c]=arguments.callee(a[c]);return b}if(typeof a==="object"){b={};for(c in a)b[c]=arguments.callee(a[c]);return b}return a}});
Grafico.Normaliser=Class.create({initialize:function(a,b){this.options={start_value:null};Object.extend(this.options,b||{});this.min=a.min();this.max=a.max();this.standard_deviation=a.standard_deviation();this.range=0;this.step=(this.same_values=!this.options.bar?this.min==this.max:false)?this.labelStep(Math.abs(this.min)):this.labelStep(this.max-this.min);this.start_value=this.calculateStart();this.process()},calculateStart:function(){var a=this.options.start_value!==null&&this.min>=0?this.options.start_value:
this.min;a=this.same_values?this.min-this.step*5:this.round(a,1);if(this.min>0&&a>this.min)return 0;return a},round:function(a,b){var c=a;b=b||1;if(this.standard_deviation>0.1){b=Math.pow(10,-b);c=Math.round(a*b)/b;if(c>this.min)return this.round(a-this.step)}return c},process:function(){this.range=this.same_values?Math.abs(this.max):this.max-this.start_value;this.step=this.labelStep(this.range);if(this.range/this.step>15)this.step*=3;this.zero_value=(0-this.start_value)/this.step},labelStep:function(a){return Math.pow(10,
(Math.log(a)/Math.LN10).round()-1)}});
Grafico.BaseGraph=Class.create(Grafico.Base,{initialize:function(a,b,c){this.options={width:parseInt(a.getStyle("width"),10),height:parseInt(a.getStyle("height"),10),grid:true,show_vertical_grid:true,show_horizontal_grid:true,plot_padding:10,font_size:10,show_horizontal_labels:true,show_vertical_labels:true,show_ticks:true,vertical_label_unit:"",background_color:a.getStyle("backgroundColor"),label_color:"#000",grid_color:"#ccc",hover_text_color:"#fff",markers:false,marker_size:5,meanline:false,padding_top:20,
draw_axis:true,datalabels:"",hover_color:"",watermark:false,watermark_location:false,hide_empty_label_grid:false,left_padding:false,label_rotation:0,label_max_size:false,min:0,max:null};Object.extend(this.options,this.chartDefaults()||{});Object.extend(this.options,c||{});this.element=a;this.data_sets=Object.isArray(b)?new Hash({one:b}):$H(b);if(this.chartDefaults().stacked===true){this.real_data=this.deepCopy(this.data_sets);this.data_sets=this.stackData(this.data_sets)}this.flat_data=this.data_sets.collect(function(d){return d[1]}).flatten();
if(this.hasBaseLine()){this.flat_data.push(this.base_line);this.flat_data=this.flat_data.flatten()}this.normaliser=new Grafico.Normaliser(this.flat_data,this.normaliserOptions());this.label_step=this.normaliser.step;this.range=this.normaliser.range;this.start_value=this.normaliser.start_value;this.zero_value=this.normaliser.zero_value;this.data_size=this.longestDataSetLength();if(c&&c.color){c.colors={};this.data_sets.keys().each(function(d){c.colors[d]=c.color})}this.options.colors=this.makeRandomColors();
this.options.labels=$A($R(1,this.data_size));Object.extend(this.options,this.chartDefaults()||{});Object.extend(this.options,c||{});this.x_padding_left=10+this.paddingLeftOffset();this.x_padding_left+=this.options.vertical_label_unit?6:0;this.x_padding_left=this.options.left_padding?this.options.left_padding:this.x_padding_left;this.x_padding_right=20;this.x_padding=this.x_padding_left+this.x_padding_right;this.y_padding_top=this.options.padding_top;this.y_padding_bottom=20+this.paddingBottomOffset();
this.y_padding=this.y_padding_top+this.y_padding_bottom;this.graph_width=this.options.width-this.x_padding;this.graph_height=this.options.height-this.y_padding;this.step=this.calculateStep();this.y_label_count=(this.range/this.label_step).round();if(isNaN(this.y_label_count)){this.y_label_count=1;this.options.show_vertical_labels=false}if(this.normaliser.min+this.y_label_count*this.normaliser.step<this.normaliser.max)this.y_label_count+=1;this.value_labels=this.makeValueLabels(this.y_label_count);
this.top_value=this.value_labels.last();this.grid_start_offset=-1;this.paper=new Raphael(this.element,this.options.width,this.options.height);this.background=this.paper.rect(this.x_padding_left,this.y_padding_top,this.graph_width,this.graph_height);this.background.attr({fill:this.options.background_color,stroke:"none"});this.options.meanline=this.options.meanline===true?{"stroke-width":"2px",stroke:"#BBBBBB"}:this.options.meanline;this.globalMarkerSet=this.paper.set();this.globalHoverSet=this.paper.set();
this.globalBlockSet=this.paper.set();this.globalAreaLineSet=this.paper.set();this.setChartSpecificOptions();this.draw();this.globalAreaLineSet.toFront();this.globalMarkerSet.toFront();this.globalHoverSet.toFront();this.globalBlockSet.toFront()},normaliserOptions:function(){return{graph_height:parseInt(this.element.getStyle("height"),10)}},hasBaseLine:function(){return false},getNormalizedBaseLine:function(){if(this.normalized_base_line==undefined)this.normalized_base_line=this.normaliseData(this.base_line);
return this.normalized_base_line},getNormalizedRealData:function(){if(this.normalized_real_data==undefined)this.normalized_real_data=this.real_data.collect(function(a){return this.normaliseData(a[1])}.bind(this));return this.normalized_real_data},chartDefaults:function(){},drawPlot:function(){},calculateStep:function(){},getMousePos:function(a){var b=0,c=0;if(!a)a=window.event;if(a.pageX||a.pageY){b=a.pageX;c=a.pageY}else if(a.clientX||a.clientY){b=a.clientX+document.body.scrollLeft-document.documentElement.scrollLeft;
c=a.clientY+document.body.scrollTop-document.documentElement.scrollTop}return{x:b,y:c}},makeRandomColors:function(){var a={},b=1/this.data_sets.size(),c=Math.random();this.data_sets.each(function(d){a[d[0]]=Raphael.hsb2rgb(c,0.85,0.75).hex;c=(c+b)%1});return a},longestDataSetLength:function(){var a=0;this.data_sets.each(function(b){a=b[1].length>a?b[1].length:a});return a},roundValue:function(a,b){b=Math.pow(10,b);a*=b;return a=Math.round(a)/b},roundValues:function(a,b){return $A(a).collect(function(c){return this.roundValue(c,
b)}.bind(this))},paddingLeftOffset:function(){if(this.options.show_vertical_labels){var a=this.flat_data;a=this.roundValues(a,2);a=$A(a).sort(function(b,c){return b.toString().length<c.toString().length}).first().toString().length;a=a>2?a-1:a;return a*this.options.font_size}else return 0},paddingBottomOffset:function(){return this.options.font_size},normalise:function(a){var b=this.start_value===0?this.top_value:this.range;if(b===0)b=1;return a/b*this.graph_height},draw:function(){this.options.grid&&
this.drawGrid();this.options.watermark&&this.drawWatermark();this.options.show_vertical_labels&&this.drawVerticalLabels();this.options.show_horizontal_labels&&this.drawHorizontalLabels();this.options.watermark||this.drawLinesInit(this);this.options.draw_axis&&this.drawAxis();this.start_value!==0&&this.drawFocusHint();this.options.meanline&&this.drawMeanLine(this.normaliseData(this.flat_data))},drawLinesInit:function(a){a.data_sets.each(function(b,c){a.drawLines(b[0],a.options.colors[b[0]],a.normaliseData(b[1]),
a.options.datalabels[b[0]],a.element,c)}.bind(a))},drawWatermark:function(){var a=this.options.watermark,b=new Image,c=this;b.onload=function(){var d,e;if(c.options.watermark_location==="middle"){d=(c.graph_width-b.width)/2+c.x_padding_left;e=(c.graph_height-b.height)/2+c.y_padding_top}else{d=c.graph_width-b.width+c.x_padding_left-2;e=c.graph_height-b.height+c.y_padding_top-2}d=c.paper.image(b.src,d,e,b.width,b.height).attr({opacity:"0.4"});c.drawLinesInit(c,c.data);if(c.options.stacked_fill||c.options.area)d.toFront()};
b.src=a.src||a},drawGrid:function(){var a=this.paper.path().attr({stroke:this.options.grid_color}),b,c;if(this.options.show_horizontal_grid){b=this.graph_height+this.y_padding_top;for(var d=0;d<this.y_label_count+1;d++){a.moveTo(this.x_padding_left-0.5,parseInt(b,10)+0.5);a.lineTo(this.x_padding_left+this.graph_width-0.5,parseInt(b,10)+0.5);b-=this.graph_height/this.y_label_count}}if(this.options.show_vertical_grid){b=this.x_padding_left+this.options.plot_padding+this.grid_start_offset;c=this.options.labels.length;
for(d=0;d<c;d++){if(this.options.hide_empty_label_grid===true&&this.options.labels[d]!==""||this.options.hide_empty_label_grid===false){a.moveTo(parseInt(b,10),this.y_padding_top);a.lineTo(parseInt(b,10),this.y_padding_top+this.graph_height)}b+=this.step}}},drawLines:function(a,b,c,d,e,f){var g=this.calculateCoords(c),h=this.graph_height+this.y_padding_top,j,i,l;if(this.options.start_at_zero===false){l=0;$A(g).each(function(k){k[1]===h&&l++});this.options.odd_horizontal_offset=l;this.options.odd_horizontal_offset>
1&&g.splice(0,this.options.odd_horizontal_offset)}if(this.options.stacked_fill||this.options.area){if(this.options.area){a=this.options.area_opacity?this.options.area_opacity:1.5/this.data_sets.collect(function(k){return k.length}).length;j=this.paper.path().attr({stroke:b,fill:b,"stroke-width":"0",opacity:a,"stroke-opacity":0})}else j=this.paper.path().attr({stroke:b,fill:b,"stroke-width":"0"});if(!this.hasBaseLine()){g.unshift([g[0][0],h]);g.push([g[g.length-1][0],h])}}else j=this.paper.path().attr({stroke:b,
"stroke-width":this.options.stroke_width+"px"});$A(g).each(function(k,m){var n=k[0];k=k[1];b instanceof Array?this.drawPlot(m,j,n,k,b[m%b.length],g,d,e,f):this.drawPlot(m,j,n,k,b,g,d,e,f)}.bind(this));if(this.options.area&&this.options.stroke_width>0){i=this.paper.path().attr({stroke:b,"stroke-width":this.options.stroke_width+"px"});g.remove(0);g.remove(-1);$A(g).each(function(k,m){this.drawPlot(m,i,k[0],k[1],b,g,d,e,f,true)}.bind(this));this.globalAreaLineSet.push(i)}if(this.options.datalabels&&
this.options.draw_hovers){this.drawHover(j,d,e,b);this.globalHoverSet.toFront()}},calculateCoords:function(a){var b=this.x_padding_left+this.options.plot_padding-this.step,c=this.graph_height+this.y_padding_top+this.normalise(this.start_value);a=$A(a).collect(function(f){b+=this.step;return[b,c-f]}.bind(this));if(!this.hasBaseLine())return a;b+=this.step;for(var d=this.getNormalizedBaseLine(),e=d.length-1;e>=0;e--){b-=this.step;a.push([b,c-d[e]])}return a},drawFocusHint:function(){var a=this.x_padding_left+
2.5-1,b=this.options.height-this.y_padding_bottom,c=this.paper.path().attr({stroke:this.options.label_color,"stroke-width":2});c.moveTo(a,b);c.lineTo(a-5,b-5);c.moveTo(a,b-5);c.lineTo(a-5,b-10)},drawMeanLine:function(a){var b=this.paper.path().attr(this.options.meanline);a=$A(a).inject(0,function(c,d){return d+c})/a.length-0.5;a=this.options.bar?a+this.zero_value*(this.graph_height/this.y_label_count):a;b.moveTo(this.x_padding_left-1,this.options.height-this.y_padding_bottom-a).lineTo(this.graph_width+
this.x_padding_left,this.options.height-this.y_padding_bottom-a)},drawAxis:function(){var a=this.paper.path().attr({stroke:this.options.label_color});a.moveTo(parseInt(this.x_padding_left,10)-0.5,this.options.height-parseInt(this.y_padding_bottom,10)+0.5);a.lineTo(parseInt(this.graph_width+this.x_padding_left,10)-0.5,this.options.height-parseInt(this.y_padding_bottom,10)+0.5);a.moveTo(parseInt(this.x_padding_left,10)-0.5,parseInt(this.options.height-this.y_padding_bottom,10)+0.5);a.lineTo(parseInt(this.x_padding_left,
10)-0.5,parseInt(this.y_padding_top,10))},makeValueLabels:function(a){for(var b=this.label_step,c=this.start_value,d=[],e=0;e<a;e++){c=this.roundValue(c+b,3);d.push(c)}return d},drawMarkers:function(a,b,c,d,e,f){function g(m){return m*b[0]}function h(m){return m*b[1]}var j=parseInt(this.x_padding_left,10)-0.5+g(d),i=this.options.height-this.y_padding_bottom+h(d),l=this.paper.path().attr({stroke:this.options.label_color}),k={font:this.options.font_size+'px "Arial"',stroke:"none",fill:this.options.label_color};
Object.extend(k,f||{});a.each(function(m){if(this.options.draw_axis&&(this.options.hide_empty_label_grid===true&&m!==""||this.options.hide_empty_label_grid===false)&&this.options.show_ticks){l.moveTo(parseInt(j,10),parseInt(i,10)+0.5);l.lineTo(parseInt(j,10)+h(5),parseInt(i,10)+0.5+g(5))}this.paper.text(j+e[0],i-2-e[1],m.toString()).attr(k);j+=g(c);i+=h(c)}.bind(this))},drawVerticalLabels:function(){for(var a=this.graph_height/this.y_label_count,b=this.options.vertical_label_unit?" "+this.options.vertical_label_unit:
"",c=0;c<this.value_labels.length;c++)this.value_labels[c]+=b;this.drawMarkers(this.value_labels,[0,-1],a,a,[-8,-2],{"text-anchor":"end"})},drawHorizontalLabels:function(){var a=this.options.label_rotation?{rotation:this.options.label_rotation,translation:-this.options.font_size+" 0"}:{},b=this.options.labels;if(this.options.label_max_size)for(var c=0;c<b.length;c++)b[c]=b[c].truncate(this.options.label_max_size+1,"\u2026");this.drawMarkers(b,[1,0],this.step,this.options.plot_padding,[0,(this.options.font_size+
7)*-1],a)},drawHover:function(a,b,c,d){var e=this,f=this.options.stacked_fill||this.options.area?"fill":"stroke",g=this.options.hover_color||d,h=this.paper.set();b=this.paper.text(a.attrs.x,a.attrs.y-this.options.font_size*1.5-4,b).attr({"font-size":this.options.font_size,fill:this.options.hover_text_color,opacity:1});var j=b.getBBox(),i=this.drawRoundRect(b,j,4);h.push(i,b).attr({opacity:0});this.checkHoverPos({rect:i,set:h});this.globalHoverSet.push(h);a.hover(function(l){f==="fill"?a.animate({fill:g,
stroke:g},200):a.animate({stroke:g},200);l=e.getMousePos(l);h[0].attr({x:l.x-j.width/2-4-c.offsetLeft,y:l.y-j.height/2-e.options.font_size*1.5-4-c.offsetTop,opacity:1});h[1].attr({x:l.x-c.offsetLeft,y:l.y-e.options.font_size*1.5-c.offsetTop,opacity:1});a.mousemove(function(k){k=e.getMousePos(k);h[0].attr({x:k.x-j.width/2-4-c.offsetLeft,y:k.y-j.height/2-e.options.font_size*1.5-4-c.offsetTop,opacity:1});h[1].attr({x:k.x-c.offsetLeft,y:k.y-e.options.font_size*1.5-c.offsetTop,opacity:1});e.checkHoverPos(i,
h)})},function(){f==="fill"?a.animate({fill:d,stroke:d},200):a.animate({stroke:d},200);h.attr({opacity:0})})},checkHoverPos:function(a){var b,c,d,e,f,g;if(a.rect){c=a.rect;d=c.getBBox()}if(a.set)e=a.set;if(a.marker)f=a.marker;if(a.nib)g=a.nib;if(a.textpadding)b=a.textpadding;if(c&&e){if(c.attrs.y<0)if(g&&f){a=e.getBBox();e.translate(0,a.height+b*2);f.translate(0,-a.height-b*2);g.translate(0,-d.height-b+1.5).scale(1,-1)}else{b=c.attrs.y;e.translate(0,1+b*-1)}if(c.attrs.y+d.height>this.options.height){b=
c.attrs.y+d.height-this.options.height;e.translate(0,b*-1-1);f&&f.translate(0,b+1)}if(c.attrs.x<0){b=c.attrs.x;e.translate(b*-1+1,0);g&&g.translate(b-1,0);f&&f.translate(b-1,0)}if(c.attrs.x+d.width>this.options.width){b=c.attrs.x+d.width-this.options.width;e.translate(b*-1-1,0);g&&g.translate(b+1,0);f&&f.translate(b+1,0)}}},drawNib:function(a,b,c){return this.paper.path().attr({fill:this.options.label_color,opacity:1,stroke:this.options.label_color,"stroke-width":"0px"}).moveTo(a.attrs.x-c,a.attrs.y+
b.height/2+c-1).lineTo(a.attrs.x,a.attrs.y+b.height/2+c*2).lineTo(a.attrs.x+c,a.attrs.y+b.height/2+c-1).andClose()},drawRoundRect:function(a,b,c){return this.paper.rect(a.attrs.x-b.width/2-c,a.attrs.y-b.height/2-c,b.width+c*2,b.height+c*2,c*1.5).attr({fill:this.options.label_color,opacity:1,stroke:this.options.label_color,"stroke-width":"0px"})}});Array.prototype.sum=function(){for(var a=0,b=0;a<this.length;b+=this[a++]);return b};
if(typeof Array.prototype.max==="undefined")Array.prototype.max=function(){return Math.max.apply({},this)};if(typeof Array.prototype.min==="undefined")Array.prototype.min=function(){return Math.min.apply({},this)};Array.prototype.mean=function(){return this.sum()/this.length};Array.prototype.variance=function(){for(var a=this.mean(),b=0,c=0;c<this.length;c++)b+=Math.pow(this[c]-a,2);return b/(this.length-1)};Array.prototype.standard_deviation=function(){return Math.sqrt(this.variance())};
Array.prototype.remove=function(a,b){b=this.slice((b||a)+1||this.length);this.length=a<0?this.length+a:a;return this.push.apply(this,b)};Raphael.el.isAbsolute=true;Raphael.el.absolutely=function(){this.isAbsolute=1;return this};Raphael.el.relatively=function(){this.isAbsolute=0;return this};Raphael.el.moveTo=function(a,b){this._last={x:a,y:b};return this.attr({path:this.attrs.path+["m","M"][+this.isAbsolute]+parseFloat(a)+" "+parseFloat(b)})};
Raphael.el.lineTo=function(a,b){this._last={x:a,y:b};return this.attr({path:this.attrs.path+["l","L"][+this.isAbsolute]+parseFloat(a)+" "+parseFloat(b)})};Raphael.el.cplineTo=function(a,b,c){if(a>this._last.x)this.attr({path:this.attrs.path+["C",this._last.x+c,this._last.y,a-c,b,a,b]});else a==this._last.x?this.lineTo(a,b):this.attr({path:this.attrs.path+["C",this._last.x-c,this._last.y,a+c,b,a,b]});this._last={x:a,y:b};return this};
Raphael.el.andClose=function(){return this.attr({path:this.attrs.path+"z"})};
Grafico.LineGraph=Class.create(Grafico.BaseGraph,{chartDefaults:function(){return{line:true,start_at_zero:true,stroke_width:5,curve_amount:10}},setChartSpecificOptions:function(){},calculateStep:function(){return(this.graph_width-this.options.plot_padding*2)/(this.data_size-1)},startPlot:function(a,b,c){a.moveTo(b,c)},drawPlot:function(a,b,c,d,e,f,g,h,j){if(a===0)return this.startPlot(b,c-0.5,d,e);this.options.curve_amount?b.cplineTo(c,d,this.options.curve_amount):b.lineTo(c,d);if(this.options.markers===
"circle")this.drawGraphMarkers(a,c,d,e,g,h);else this.options.markers==="value"&&this.drawGraphValueMarkers(a,c,d,e,g,h,j)},drawGraphMarkers:function(a,b,c,d){var e=this.paper.circle(b,c,this.options.marker_size),f=this.options.marker_size,g=this.options.hover_color||d,h=parseInt(1.7*f,10);e.attr({"stroke-width":"1px",stroke:this.options.background_color,fill:d});this.globalMarkerSet.push(e);e.hover(function(){e.animate({r:h,fill:g},200)},function(){e.animate({r:f,fill:d},200)})},drawGraphValueMarkers:function(a,
b,c,d,e,f,g){a+=this.options.odd_horizontal_offset>1?this.options.odd_horizontal_offset:0;a-=this.options.stacked_fill||this.options.area?1:0;if(f=(this.options.stacked?this.real_data:this.data_sets).collect(function(k){return k[1][a]})[g]){f=""+f.toString().split(".");if(f[1])f[1]=f[1].truncate(3,"")}if(this.options.line||this.options.stacked||(this.options.stacked_fill||this.options.area)&&a!=-1&&typeof f!="undefined"){g=b-this.step/2;var h=this.options.stacked?c-this.graph_height/18:c-this.graph_height/
6,j=this.step,i=this.options.stacked?this.graph_height/9:this.graph_height/3;b=this.paper.circle(b,c,this.options.marker_size).attr({"stroke-width":"1px",stroke:this.options.background_color,fill:d,opacity:0});d=this.paper.rect(g,h,j,i).attr({fill:d,"stroke-width":0,stroke:d,opacity:0});e=this.options.datalabels?e+": "+f:""+f;e+=this.options.vertical_label_unit?" "+this.options.vertical_label_unit:"";var l=this.paper.set();e=this.paper.text(b.attrs.cx,b.attrs.cy-this.options.font_size*1.5-8,e).attr({"font-size":this.options.font_size,
fill:this.options.hover_text_color,opacity:1});f=e.getBBox();c=this.drawRoundRect(e,f,4);f=this.drawNib(e,f,4);l.push(b,c,f,e).attr({opacity:0});this.checkHoverPos({rect:c,set:l,marker:b,nib:f,textpadding:4});this.globalHoverSet.push(l);this.globalBlockSet.push(d);d.hover(function(){l.animate({opacity:1},200)},function(){l.animate({opacity:0},200)})}}});
Grafico.AreaGraph=Class.create(Grafico.LineGraph,{chartDefaults:function(){return{area:true,area_opacity:false,stroke_width:0,curve_amount:10}},drawPlot:function(a,b,c,d,e,f,g,h,j,i){var l=this.options.area||this.options.stacked_fill;if(!i)if(l===true){if(a!==0&&a!==f.length-1)if(this.options.markers==="circle")this.drawGraphMarkers(a,c,d,e,g,h);else this.options.markers==="value"&&this.drawGraphValueMarkers(a,c,d,e,g,h,j)}else if(this.options.markers==="circle")this.drawGraphMarkers(a,c,d,e,g,h);
else this.options.markers==="value"&&this.drawGraphValueMarkers(a,c,d,e,g,h,j);c-=0.5;if(a===0)return this.startPlot(b,c,d,e);if(this.options.curve_amount&&a>1&&a<f.length-1)b.cplineTo(c,d,this.options.curve_amount);else this.options.curve_amount&&!l&&1?b.cplineTo(c,d,this.options.curve_amount):b.lineTo(c,d)}});
Grafico.StackGraph=Class.create(Grafico.AreaGraph,{chartDefaults:function(){return{stacked:true,stacked_fill:true,stroke_width:0,curve_amount:10}},setChartSpecificOptions:function(){if(!this.options.stacked_fill)this.options.stroke_width=5},stackData:function(a){for(var b=a.collect(function(e){return e[1]}),c=b.length-2;c>=0;c--)for(var d=0;d<b[0].length;d++)b[c][d]+=b[c+1][d];return a}});
Grafico.StreamGraph=Class.create(Grafico.StackGraph,{chartDefaults:function(){return{stacked:true,stacked_fill:true,stroke_width:5,grid:false,draw_axis:false,show_horizontal_labels:false,show_vertical_labels:false,stream:true,stream_line_smoothing:false,stream_smart_insertion:false,curve_amount:4,stream_label_threshold:0}},hasBaseLine:function(){return true},calcBaseLine:function(a){var b=a.collect(function(e){return e[1]});a=[];for(var c=0;c<b[0].length;c++){for(var d=sum=0;d<b.length;d++)sum+=this.options.stream_line_smoothing==
false?b[d][c]:(d+1)*b[d][c];a[c]=this.options.stream_line_smoothing==false?-sum/2:-sum/(b.length+1)}b=a.min();for(d=0;d<a.length;d++)a[d]-=b;this.base_line=a},stackData:function(a){if(this.options.stream_smart_insertion){a=$A(a);a.each(function(g){for(var h=0;h<g[1].length&&g[1][h]<=1.0E-7;)h++;g[2]=h});var b=[],c=false;a.sortBy(function(g){return g[2]}).each(function(g){c?b.push(g):b.unshift(g);c=!c});a=$H();b.each(function(g){a.set(g[0],g[1])})}this.real_data=this.deepCopy(a);this.calcBaseLine(a);
for(var d=a.collect(function(g){return g[1]}),e=0;e<d[0].length;e++)d[d.length-1][e]+=this.base_line[e];for(var f=d.length-2;f>=0;f--)for(e=0;e<d[0].length;e++)d[f][e]+=d[f+1][e];return a},drawPlot:function(a,b,c,d,e,f,g,h,j,i){if(this.options.datalabels&&!i){i=this.getNormalizedRealData();var l=this.bestMarkerPositions();a<f.length/2&&l[j]>=a&&l[j]<a+1&&this.drawStreamMarker(a+1,c+(l[j]-a)*this.step,d+i[j][a]/2,e,g,h)}c-=0.5;if(a===0)return this.startPlot(b,c,d,e);b.cplineTo(c,d,this.options.curve_amount)},
bestMarkerPositions:function(){if(this.best_marker_positions==undefined)this.best_marker_positions=this.real_data.collect(function(a){for(var b=-1,c=0,d=0,e=0;e<a[1].length;e++){var f=a[1][e];if(f>c&&f>=this.options.stream_label_threshold){c=f;b=e;d=0}else f==c&&c>0&&d++}return b+d/2}.bind(this));return this.best_marker_positions},drawStreamMarker:function(a,b,c,d,e){if(this.options.datalabels){a=this.paper.set();b=this.paper.text(b,c-8+this.options.font_size/2,e).attr({"font-size":this.options.font_size,
fill:this.options.hover_text_color,opacity:1});c=b.getBBox();c=this.drawRoundRect(b,c,4);a.push(c,b);this.checkHoverPos({rect:c,set:a,textpadding:4});this.globalHoverSet.push(a)}}});
Grafico.BarGraph=Class.create(Grafico.BaseGraph,{chartDefaults:function(){return{bar:true,plot_padding:0,bargraph_lastcolor:false,bargraph_negativecolor:false}},normaliserOptions:function(){return{start_value:0,bar:true}},setChartSpecificOptions:function(){this.bar_padding=5;this.bar_width=this.calculateBarWidth();this.options.plot_padding=this.bar_width/2;this.step=this.calculateStep();this.grid_start_offset=this.bar_padding-1},calculateBarWidth:function(){return this.graph_width/this.data_size-
this.bar_padding},calculateStep:function(){this.data_size=this.data_size===1?2:this.data_size;return(this.graph_width-this.options.plot_padding*2-this.bar_padding*2)/(this.data_size-1)},drawPlot:function(a,b,c,d,e,f,g){b=this.options.height-this.y_padding_bottom-this.zero_value*(this.graph_height/this.y_label_count);var h=this.options.bargraph_lastcolor,j=this.options.bargraph_negativecolor;c+=this.bar_padding;d=this.options.height-this.y_padding_bottom-d-this.zero_value*(this.graph_height/this.y_label_count);
e=h&&a===f.length-1?h:d<0?j:e;f=this.paper.rect(c-this.bar_width/2,b,this.bar_width,d).attr({fill:e,"stroke-width":this.options.stroke_width,stroke:this.options.color});d<0?f.attr({height:-f.attrs.height}):f.translate(0,-d);this.options.datalabels&&this.drawGraphValueMarkers(c,a,f,g,e);this.options.count++},drawHorizontalLabels:function(){var a=this.bar_padding+this.options.plot_padding,b=this.options.label_rotation?{rotation:this.options.label_rotation,translation:-this.options.font_size+" 0"}:{},
c=this.options.labels;if(this.options.label_max_size)for(var d=0;d<c.length;d++)c[d]=c[d].truncate(this.options.label_max_size+1,"\u2026");this.drawMarkers(this.options.labels,[1,0],this.step,a,[0,(this.options.font_size+7)*-1],b)},drawGrid:function(){var a=this.paper.path().attr({stroke:this.options.grid_color,"stroke-width":1}),b=this.graph_height+this.y_padding_top,c,d;if(this.options.horizontalbar){a.moveTo(this.x_padding_left-0.5,parseInt(b,10)+0.5);a.lineTo(this.x_padding_left+this.graph_width-
0.5,parseInt(b,10)+0.5);b-=this.graph_height;a.moveTo(this.x_padding_left-0.5,parseInt(b,10)+0.5);a.lineTo(this.x_padding_left+this.graph_width-0.5,parseInt(b,10)+0.5)}else if(this.options.show_horizontal_grid)for(var e=0;e<this.y_label_count+1;e++){a.moveTo(this.x_padding_left-0.5,parseInt(b,10)+0.5);a.lineTo(this.x_padding_left+this.graph_width-0.5,parseInt(b,10)+0.5);b-=this.graph_height/this.y_label_count}if(this.options.horizontalbar){b=this.x_padding_left+this.options.plot_padding+this.grid_start_offset;
c=this.y_label_count;d=this.options.horizontalbar?this.graph_width/this.y_label_count:this.step;for(e=0;e<c;e++){if(this.options.hide_empty_label_grid===true&&this.options.labels[e]!==""||this.options.hide_empty_label_grid===false){a.moveTo(parseInt(b,10)+0.5,this.y_padding_top);a.lineTo(parseInt(b,10)+0.5,this.y_padding_top+this.graph_height)}b+=d}}a.moveTo(parseInt(this.x_padding_left,10)-0.5,this.y_padding_top);a.lineTo(parseInt(this.x_padding_left,10)-0.5,this.y_padding_top+this.graph_height);
a.moveTo(parseInt(this.x_padding_left+this.graph_width,10)-0.5,this.y_padding_top);a.lineTo(parseInt(this.x_padding_left+this.graph_width,10)-0.5,this.y_padding_top+this.graph_height)},drawGraphValueMarkers:function(a,b,c,d,e){var f=this.options.hover_color||e,g=this.paper.set();a=this.paper.rect(a-this.bar_width/2,this.y_padding_top,this.bar_width,this.options.height);d=d?d[b].toString():"";b=this.paper.text(c.attrs.x+this.bar_width/2,c.attrs.y-this.options.font_size*1.5,d);a.attr({fill:e,"stroke-width":0,
stroke:e,opacity:0});b.attr({"font-size":this.options.font_size,fill:this.options.hover_text_color,opacity:1});var h=b.getBBox();d=this.drawRoundRect(b,h,4);h=this.drawNib(b,h,4);g.push(d,h,b).attr({opacity:0});this.checkHoverPos({rect:d,set:g,nib:h});this.globalHoverSet.push(g);this.globalBlockSet.push(a);d.attrs.y<0&&g.translate(0,1+d.attrs.y*-1);a.hover(function(){c.animate({fill:f,stroke:f},200);g.animate({opacity:1},200)},function(){c.animate({fill:e,stroke:e},200);g.animate({opacity:0},200)})}});
Grafico.StackedBarGraph=Class.create(Grafico.BarGraph,{chartDefaults:function(){return{opacity:100,bar:true,plot_padding:0,stacked:true,stacked_fill:true}},setChartSpecificOptions:function(){this.bar_padding=5;this.bar_width=this.calculateBarWidth();this.options.plot_padding=this.bar_width/2;this.step=this.calculateStep();this.grid_start_offset=this.bar_padding-1;this.options.stroke_width=1},stackData:function(a){for(var b=a.collect(function(e){return e[1]}),c=b.length-2;c>=0;c--)for(var d=0;d<b[0].length;d++)b[c][d]+=
b[c+1][d];return a},calculateCoords:function(a){var b=this.x_padding_left+this.options.plot_padding-this.step,c=this.graph_height+this.y_padding_top+this.normalise(this.start_value);a=$A(a).collect(function(f){b+=this.step;return[b,c-f]}.bind(this));b+=this.step;for(var d=this.getNormalizedBaseLine(),e=d.length-1;e>=0;e--){b-=this.step;a.push([b,c-d[e]])}return a},drawLines:function(a,b,c,d,e,f){var g=this.calculateCoords(c),h;h=this.paper.path().attr({stroke:b,"stroke-width":0});$A(g).each(function(j,
i){this.drawPlot(i,h,j[0],j[1],b,g,d,e,f)}.bind(this));if(this.options.datalabels&&this.options.draw_hovers){this.drawHover(h,d,e,b);this.globalHoverSet.toFront()}},drawPlot:function(a,b,c,d,e,f,g){b=this.options.height-this.y_padding_bottom-this.zero_value*(this.graph_height/this.y_label_count);c+=this.bar_padding;d=this.options.height-this.y_padding_bottom-d-this.zero_value*(this.graph_height/this.y_label_count);f={fill:e,"stroke-width":0,stroke:this.options.color2,opacity:this.options.opacity};
b=this.paper.rect(c-this.bar_width/2,b,this.bar_width,d).attr(f);d<0?b.attr({height:-b.attrs.height}):b.translate(0,-d);this.options.datalabels&&this.drawGraphValueMarkers(c,a,b,g,e);this.options.count++},drawGraphValueMarkers:function(a,b,c,d,e){a=a-this.bar_width/2;var f=c.attrs.y,g=this.bar_width,h=c.attrs.height,j=this.options.hover_color||e,i=this.paper.set();a=this.paper.rect(a,f,g,h);d=d&&d.length>b?d[b].toString():"";b=this.paper.text(c.attrs.x+this.bar_width/2,c.attrs.y-this.options.font_size*
1.5,d);a.attr({fill:e,"stroke-width":0,stroke:e,opacity:0});b.attr({"font-size":this.options.font_size,fill:this.options.hover_text_color,opacity:1});f=b.getBBox();d=this.drawRoundRect(b,f,4);f=this.drawNib(b,f,4);i.push(d,f,b).attr({opacity:0});this.checkHoverPos({rect:d,set:i,nib:f});this.globalHoverSet.push(i);this.globalBlockSet.push(a);d.attrs.y<0&&i.translate(0,1+d.attrs.y*-1);a.hover(function(){c.animate({fill:j},200);i.animate({opacity:1},200)},function(){c.animate({fill:e},200);i.animate({opacity:0},
200)})}});
Grafico.HorizontalBarGraph=Class.create(Grafico.BarGraph,{chartDefaults:function(){return{bar:true,horizontalbar:true,plot_padding:0,horizontal_rounded:false,bargraph_lastcolor:false}},setChartSpecificOptions:function(){this.x_padding_left=20+this.longestLabel()*(this.options.font_size/2);this.bar_padding=5;this.bar_width=this.calculateBarHeight();this.step=this.calculateStep();this.graph_width=this.options.width-this.x_padding_right-this.x_padding_left},normalise:function(a){var b=this.makeValueLabels(this.y_label_count);b=
b[b.length-1];return a/b*this.graph_width},longestLabel:function(){return $A(this.options.labels).sort(function(a,b){return a.toString().length<b.toString().length}).first().toString().length},calculateBarHeight:function(){return this.graph_height/this.data_size-this.bar_padding},calculateStep:function(){return(this.graph_height-this.options.plot_padding*2)/this.data_size},drawLines:function(a,b,c,d){var e=this.y_padding_top+this.bar_padding/2-0.5,f=this.zero_value*(this.graph_width/this.y_label_count),
g=this.x_padding_left+f-0.5,h=this.options.bargraph_lastcolor,j=this.options.bargraph_negativecolor;this.datalabel=d;$A(c).each(function(i,l){var k,m=this.options.horizontal_rounded?this.bar_width/2:0,n;k=h&&l===c.length-1?h:i<0?j:b;i=i/this.graph_width*(this.graph_width-f);n=this.paper.rect(g,e,i,this.bar_width,m).attr({fill:k,"stroke-width":0,stroke:k});i<0&&n.attr({width:-n.attrs.width}).translate(i,0);if(m){var p=this.paper.set();bargraph2=this.paper.rect(g,e,i-this.bar_width/2,this.bar_width);
bargraph2.attr({fill:k,"stroke-width":0,stroke:k});p.push(bargraph2,n);i<0&&bargraph2.attr({width:-bargraph2.attrs.width-this.bar_width}).translate(i+this.bar_width/2,0)}if(this.options.datalabels){var q=this.options.hover_color||k,o=this.paper.set();l=this.datalabel[l].toString();text=this.paper.text(f+i+this.x_padding_left/2,n.attrs.y-this.options.font_size*1.5,l).attr({"font-size":this.options.font_size,fill:this.options.hover_text_color,opacity:1});hoverbar=this.paper.rect(this.x_padding_left,
e,this.graph_width,this.bar_width).attr({fill:k,"stroke-width":0,stroke:k,opacity:0});textbox=text.getBBox();i<0&&text.translate(textbox.width,0);i=this.drawRoundRect(text,textbox,4);n=this.drawNib(text,textbox,4);o.push(i,n,text).attr({opacity:0});this.checkHoverPos({rect:i,set:o,nib:n});this.globalHoverSet.push(o);this.globalBlockSet.push(hoverbar);i.attrs.y<0&&o.translate(0,1+i.attrs.y*-1);hoverbar.hover(function(){p.animate({fill:q,stroke:q},200);o.animate({opacity:1},200)},function(){p.animate({fill:k,
stroke:k},200);o.animate({opacity:0},200)})}e+=this.step}.bind(this))},drawFocusHint:function(){var a=this.x_padding_left+10,b=this.options.height-this.y_padding_bottom-2.5;this.paper.path().attr({stroke:this.options.label_color,"stroke-width":2}).moveTo(a,b).lineTo(a-5,b+5).moveTo(a-5,b).lineTo(a-10,b+5)},drawVerticalLabels:function(){var a=this.step/2,b=this.options.label_rotation?{"text-anchor":"end",rotation:this.options.label_rotation,translation:"0 "+this.options.font_size/2}:{"text-anchor":"end"},
c=this.options.labels;if(this.options.label_max_size)for(var d=0;d<c.length;d++)c[d]=c[d].truncate(this.options.label_max_size+1,"\u2026");this.drawMarkers(this.options.labels.reverse(),[0,-1],this.step,a,[-8,-(this.options.font_size/5)],b)},drawHorizontalLabels:function(){var a=this.graph_width/this.y_label_count,b=this.makeValueLabels(this.y_label_count);if(this.options.vertical_label_unit)for(var c=0;c<b.length;c++)b[c]+=this.options.vertical_label_unit;this.drawMarkers(b,[1,0],a,a,[0,(this.options.font_size+
7)*-1])},drawMeanLine:function(a){var b=this.paper.path().attr(this.options.meanline);a=$A(a).inject(0,function(c,d){return d+c})/a.length;a=this.options.bar?a+this.zero_value*(this.graph_height/this.y_label_count):a;b.moveTo(this.x_padding_left-1+a,this.y_padding_top).lineTo(this.x_padding_left-1+a,this.y_padding_top+this.graph_height)}});
Grafico.SparkLine=Class.create(Grafico.Base,{initialize:function(a,b,c){this.element=a;this.data=b;this.options={highlight:false,stroke_width:1,color:this.makeRandomcolor(),width:parseInt(a.getStyle("width"),10),height:parseInt(a.getStyle("height"),10),acceptable_range:false,zeroline:false};Object.extend(this.options,c||{});this.step=this.calculateStep();this.paper=new Raphael(this.element,this.options.width,this.options.height);this.drawBackground();this.draw()},drawBackground:function(){this.background=
this.options.acceptable_range?this.paper.rect(0,this.options.height-this.normalise(this.options.acceptable_range[1]),this.options.width,this.normalise(this.options.acceptable_range[1])-this.normalise(this.options.acceptable_range[0])):(this.background=this.paper.rect(0,0,this.options.width,this.options.height));this.background.attr({fill:this.options.background_color,stroke:"none"})},calculateStep:function(){return this.options.width/(this.data.length-1)},makeRandomcolor:function(){return Raphael.hsb2rgb(Math.random(),
1,0.75).hex},normalise:function(a){var b=this.data.min()<0?this.data.max()-this.data.min():this.data.max();a-=this.data.min()<0?this.data.min():0;return a/b*this.options.height},draw:function(){var a=this.normaliseData(this.data),b;if(this.options.zeroline&&this.data.min()<0){this.options.zeroline=this.options.zeroline===true?{"stroke-width":"1px",stroke:"#BBBBBB"}:this.options.zeroline;b=parseInt(this.options.height-this.normalise(0),10);this.paper.path().attr(this.options.zeroline).moveTo(0,b).lineTo(this.options.width,
b)}this.drawLines(this.options.color,a);this.options.highlight&&this.showHighlight(a)},drawLines:function(a,b){var c=this.paper.path().attr({stroke:a,"stroke-width":this.options.stroke_width}).moveTo(0,this.options.height-b.first()),d=0,e=this.data.min()<0?this.options.stroke_width:0;b.slice(1).each(function(f){d+=this.step;c.lineTo(d,this.options.height-f-e)}.bind(this))},showHighlight:function(a){var b=1+this.options.stroke_width/2,c=this.options.width-b;a=a[this.options.highlight.index||a.length-
1]+(b/2).round();var d=this.options.highlight.color||"#f00";if(typeof this.options.highlight.index!=="undefined")c=this.step*this.options.highlight.index;this.paper.circle(c,this.options.height-a+b/2,b).attr({stroke:false,fill:d})}});
Grafico.SparkBar=Class.create(Grafico.SparkLine,{calculateStep:function(){return this.options.width/this.data.length},drawLines:function(a,b){var c=this.options.bargraph_lastcolor,d=this.step>2?this.step-1:this.step,e=d/2,f=this.normalise(0);b.each(function(g,h){var j;h=c&&h===b.length-1?c:a;j=this.paper.path().attr({stroke:h,"stroke-width":d});j.moveTo(e,this.options.height-g);j.lineTo(e,this.options.height-f);if(g<f)j.attr({stroke:this.options.bargraph_negativecolor||h});e+=this.step}.bind(this))},
showHighlight:function(){}});
Grafico.SparkArea=Class.create(Grafico.SparkLine,{drawLines:function(a,b){var c=a,d=a,e=0.2,f=this.normalise(0);if(typeof a=="object"){c=a[1];d=a[0];e=1}var g=this.paper.path().attr({fill:c,stroke:c,"stroke-width":0,"stroke-opacity":0,opacity:e}).moveTo(0,this.options.height-f).lineTo(0,this.options.height-b.first()),h=this.paper.path().attr({stroke:d,"stroke-width":this.options.stroke_width}).moveTo(0,this.options.height-b.first()),j=0;b.slice(1).each(function(i){j+=this.step;g.lineTo(j,this.options.height-
i);h.lineTo(j,this.options.height-i)}.bind(this));g.lineTo(j,this.options.height-f)}});
