<?php
/**
 * Piwik - Open source web analytics
 *
 * @link http://piwik.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 *
 * @category Piwik
 * @package DataFiles
 */

/*
 * Language database
 */
if (!isset($GLOBALS['Piwik_LanguageList'])) {
    // Reference: ISO 639-1 alpha-2
    $GLOBALS['Piwik_LanguageList'] = array(
        'aa' => array('Afar'),
        'ab' => array('Abkhazian'),
        'ae' => array('Avestan'),
        'af' => array('Afrikaans'),
        'ak' => array('Akan'),
        'am' => array('Amharic'),
        'an' => array('Aragonese'),
        'ar' => array('Arabic'),
        'as' => array('Assamese'),
        'av' => array('Avaric'),
        'ay' => array('Aymara'),
        'az' => array('Azerbaijani'),
        'ba' => array('Bashkir'),
        'be' => array('Belarusian'),
        'bg' => array('Bulgarian'),
        'bh' => array('Bihari'), // 'Bihari languages'
        'bi' => array('Bislama'),
        'bm' => array('Bambara'),
        'bn' => array('Bengali'),
        'bo' => array('Tibetan'),
        'br' => array('Breton'),
        'bs' => array('Bosnian'),
        'ca' => array('Catalan', 'Valencian'),
        'ce' => array('Chechen'),
        'ch' => array('Chamorro'),
        'co' => array('Corsican'),
        'cr' => array('Cree'),
        'cs' => array('Czech'),
        'cu' => array('Church Slavic', 'Old Slavonic', 'Church Slavonic', 'Old Bulgarian', 'Old Church Slavonic'),
        'cv' => array('Chuvash'),
        'cy' => array('Welsh'),
        'da' => array('Danish'),
        'de' => array('German'),
        'dv' => array('Divehi', 'Dhivehi', 'Maldivian'),
        'dz' => array('Dzongkha'),
        'ee' => array('Ewe'),
        'el' => array('Greek', 'Modern Greek', 'Hellenic'), // Greek, Modern (1453-)
        'en' => array('English'),
        'eo' => array('Esperanto'),
        'es' => array('Spanish', 'Castilian'),
        'et' => array('Estonian'),
        'eu' => array('Basque'),
        'fa' => array('Persian'),
        'ff' => array('Fulah'),
        'fi' => array('Finnish'),
        'fj' => array('Fijian'),
        'fo' => array('Faroese'),
        'fr' => array('French'),
        'fy' => array('Western Frisian'),
        'ga' => array('Irish'),
        'gd' => array('Gaelic', 'Scottish Gaelic'),
        'gl' => array('Galician'),
        'gn' => array('Guarani'),
        'gu' => array('Gujarati'),
        'gv' => array('Manx'),
        'ha' => array('Hausa'),
        'he' => array('Hebrew'),
        'hi' => array('Hindi'),
        'ho' => array('Hiri Motu'),
        'hr' => array('Croatian'),
        'ht' => array('Haitian', 'Haitian Creole'),
        'hu' => array('Hungarian'),
        'hy' => array('Armenian'),
        'hz' => array('Herero'),
        'ia' => array('Interlingua'), // 'Interlingua (International Auxiliary Language Association)'
        'id' => array('Indonesian'),
        'ie' => array('Interlingue', 'Occidental'),
        'ig' => array('Igbo'),
        'ii' => array('Sichuan Yi', 'Nuosu'),
        'ik' => array('Inupiaq'),
        'io' => array('Ido'),
        'is' => array('Icelandic'),
        'it' => array('Italian'),
        'iu' => array('Inuktitut'),
        'ja' => array('Japanese'),
        'jv' => array('Javanese'),
        'ka' => array('Georgian'),
        'kg' => array('Kongo'),
        'ki' => array('Kikuyu', 'Gikuyu'),
        'kj' => array('Kuanyama', 'Kwanyama'),
        'kk' => array('Kazakh'),
        'kl' => array('Kalaallisut', 'Greenlandic'),
        'km' => array('Central Khmer'),
        'kn' => array('Kannada'),
        'ko' => array('Korean'),
        'kr' => array('Kanuri'),
        'ks' => array('Kashmiri'),
        'ku' => array('Kurdish'),
        'kv' => array('Komi'),
        'kw' => array('Cornish'),
        'ky' => array('Kirghiz', 'Kyrgyz'),
        'la' => array('Latin'),
        'lb' => array('Luxembourgish', 'Letzeburgesch'),
        'lg' => array('Ganda'),
        'li' => array('Limburgan', 'Limburger', 'Limburgish'),
        'ln' => array('Lingala'),
        'lo' => array('Lao'),
        'lt' => array('Lithuanian'),
        'lu' => array('Luba-Katanga'),
        'lv' => array('Latvian'),
        'mg' => array('Malagasy'),
        'mh' => array('Marshallese'),
        'mi' => array('Maori'),
        'mk' => array('Macedonian'),
        'ml' => array('Malayalam'),
        'mn' => array('Mongolian'),
//		'mo' => array('Moldavian'), // deprecated
        'mr' => array('Marathi'),
        'ms' => array('Malay'),
        'mt' => array('Maltese'),
        'my' => array('Burmese'),
        'na' => array('Nauru'),
        'nb' => array('Norwegian Bokmål'),
        'nd' => array('North Ndebele'),
        'ne' => array('Nepali'),
        'ng' => array('Ndonga'),
        'nl' => array('Dutch', 'Flemish'),
        'nn' => array('Norwegian Nynorsk'),
        'no' => array('Norwegian'),
        'nr' => array('South Ndebele'),
        'nv' => array('Navajo', 'Navaho'),
        'ny' => array('Chichewa', 'Chewa', 'Nyanja'),
        'oc' => array('Occitan', 'Provençal'), // Occitan (post 1500)
        'oj' => array('Ojibwa'),
        'om' => array('Oromo'),
        'or' => array('Oriya'),
        'os' => array('Ossetian', 'Ossetic'),
        'pa' => array('Panjabi', 'Punjabi'),
        'pi' => array('Pali'),
        'pl' => array('Polish'),
        'ps' => array('Pushto', 'Pashto'),
        'pt' => array('Portuguese'),
        'qu' => array('Quechua'),
        'rm' => array('Romansh'),
        'rn' => array('Rundi'),
        'ro' => array('Romanian', 'Moldavian', 'Moldovan'),
        'ru' => array('Russian'),
        'rw' => array('Kinyarwanda'),
        'sa' => array('Sanskrit'),
        'sc' => array('Sardinian'),
        'sd' => array('Sindhi'),
        'se' => array('Northern Sami'),
        'sg' => array('Sango'),
//		'sh' => array('Serbo-Croatian'), // deprecated
        'si' => array('Sinhala', 'Sinhalese'),
        'sk' => array('Slovak'),
        'sl' => array('Slovenian'),
        'sm' => array('Samoan'),
        'sn' => array('Shona'),
        'so' => array('Somali'),
        'sq' => array('Albanian'),
        'sr' => array('Serbian'),
        'ss' => array('Swati'),
        'st' => array('Southern Soth'),
        'su' => array('Sundanese'),
        'sv' => array('Swedish'),
        'sw' => array('Swahili'),
        'ta' => array('Tamil'),
        'te' => array('Telugu'),
        'tg' => array('Tajik'),
        'th' => array('Thai'),
        'ti' => array('Tigrinya'),
        'tk' => array('Turkmen'),
        'tl' => array('Tagalog'),
        'tn' => array('Tswana'),
        'to' => array('Tonga'), // Tonga (Tonga Islands)
        'tr' => array('Turkish'),
        'ts' => array('Tsonga'),
        'tt' => array('Tatar'),
        'tw' => array('Twi'),
        'ty' => array('Tahitian'),
        'ug' => array('Uighur', 'Uyghur'),
        'uk' => array('Ukrainian'),
        'ur' => array('Urdu'),
        'uz' => array('Uzbek'),
        've' => array('Venda'),
        'vi' => array('Vietnamese'),
        'vo' => array('Volapük'),
        'wa' => array('Walloon'),
        'wo' => array('Wolof'),
        'xh' => array('Xhosa'),
        'yi' => array('Yiddish'),
        'yo' => array('Yoruba'),
        'za' => array('Zhuang', 'Chuang'),
        'zh' => array('Chinese'),
        'zu' => array('Zulu'),
    );
}
