/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree;

import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MemberNode;

public class FieldNode
extends MemberNode
implements FieldVisitor {
    public int access;
    public String name;
    public String desc;
    public String signature;
    public Object value;

    public FieldNode(int access, String name, String desc, String signature, Object value) {
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.value = value;
    }

    public void accept(ClassVisitor cv) {
        AnnotationNode an;
        FieldVisitor fv = cv.visitField(this.access, this.name, this.desc, this.signature, this.value);
        int n = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        int i = 0;
        while (i < n) {
            an = (AnnotationNode)this.visibleAnnotations.get(i);
            an.accept(fv.visitAnnotation(an.desc, true));
            ++i;
        }
        n = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        i = 0;
        while (i < n) {
            an = (AnnotationNode)this.invisibleAnnotations.get(i);
            an.accept(fv.visitAnnotation(an.desc, false));
            ++i;
        }
        n = this.attrs == null ? 0 : this.attrs.size();
        i = 0;
        while (i < n) {
            fv.visitAttribute((Attribute)this.attrs.get(i));
            ++i;
        }
        fv.visitEnd();
    }
}

