/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import java.net.InetAddress;
import java.util.Arrays;

public class ChannelBinding {
    private final byte[] appData;
    private final InetAddress initAddr;
    private final InetAddress acceptAddr;

    public ChannelBinding(InetAddress initAddr, InetAddress acceptAddr, byte[] appData) {
        this.appData = appData != null ? (byte[])appData.clone() : null;
        this.initAddr = initAddr;
        this.acceptAddr = acceptAddr;
    }

    public ChannelBinding(byte[] appData) {
        this(null, null, appData);
    }

    public InetAddress getInitiatorAddress() {
        return this.initAddr;
    }

    public InetAddress getAcceptorAddress() {
        return this.acceptAddr;
    }

    public byte[] getApplicationData() {
        if (this.appData != null) {
            return (byte[])this.appData.clone();
        }
        return null;
    }

    public boolean equals(Object obj) {
        boolean b3;
        if (!(obj instanceof ChannelBinding)) {
            return false;
        }
        ChannelBinding cb = (ChannelBinding)obj;
        boolean b1 = Arrays.equals(this.appData, cb.appData);
        boolean b2 = this.initAddr == null && cb.initAddr == null || cb.initAddr != null && this.initAddr.equals(cb.initAddr);
        boolean bl = b3 = this.acceptAddr == null && cb.acceptAddr == null || cb.acceptAddr != null && this.acceptAddr.equals(cb.acceptAddr);
        return b1 && b2 && b3;
    }

    public int hashCode() {
        int code = 0;
        if (this.appData != null) {
            int i = 0;
            while (i < this.appData.length) {
                code ^= this.appData[i] << (8 * i & 0x1F);
                ++i;
            }
        }
        if (this.initAddr != null) {
            code ^= this.initAddr.hashCode();
        }
        if (this.acceptAddr != null) {
            code ^= this.acceptAddr.hashCode();
        }
        return code;
    }
}

