/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JPasswordField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;

public class PasswordView
extends FieldView {
    private char[] oneCharBuffer = new char[1];

    public PasswordView(Element elem) {
        super(elem);
    }

    protected int drawEchoCharacter(Graphics g, int x, int y, char ch) {
        this.updateMetrics();
        this.oneCharBuffer[0] = ch;
        g.drawChars(this.oneCharBuffer, 0, 1, x, y);
        return x + this.metrics.charWidth(ch);
    }

    private char getEchoChar() {
        char ch = ((JPasswordField)this.getContainer()).getEchoChar();
        if (ch == '\u0000') {
            ch = '*';
        }
        return (char)ch;
    }

    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        this.updateMetrics();
        char ch = this.getEchoChar();
        g.setColor(this.selectedColor);
        g.setColor(Color.BLACK);
        int index = p0;
        while (index < p1) {
            x = this.drawEchoCharacter(g, x, y, ch);
            ++index;
        }
        return x;
    }

    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        this.updateMetrics();
        char ch = this.getEchoChar();
        g.setColor(this.unselectedColor);
        g.setColor(Color.BLACK);
        int index = p0;
        while (index < p1) {
            x = this.drawEchoCharacter(g, x, y, ch);
            ++index;
        }
        return x;
    }

    public float getPreferredSpan(int axis) {
        String text;
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException();
        }
        FontMetrics fm = this.getFontMetrics();
        if (axis == 1) {
            return fm.getHeight();
        }
        Element elem = this.getElement();
        try {
            text = elem.getDocument().getText(elem.getStartOffset(), elem.getEndOffset());
        }
        catch (BadLocationException badLocationException) {
            text = "";
        }
        return fm.stringWidth(text);
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Shape newAlloc = this.adjustAllocation(a);
        this.updateMetrics();
        int lineIndex = this.getElement().getElementIndex(pos);
        Rectangle rect = this.lineToRect(newAlloc, lineIndex);
        Element line = this.getElement().getElement(lineIndex);
        int lineStart = line.getStartOffset();
        Segment segment = this.getLineBuffer();
        segment.array = new char[pos - lineStart];
        char echoChar = this.getEchoChar();
        int i = 0;
        while (i < segment.array.length) {
            segment.array[i] = echoChar;
            ++i;
        }
        segment.offset = 0;
        segment.count = segment.array.length;
        int xoffset = Utilities.getTabbedTextWidth(segment, this.metrics, rect.x, this, lineStart);
        rect.x += xoffset;
        rect.width = 1;
        rect.height = this.metrics.getHeight();
        return rect;
    }

    public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
        return super.viewToModel(fx, fy, a, bias);
    }
}

