/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;

public class JFileChooser
extends JComponent
implements Accessible {
    private static final long serialVersionUID = 3162921138695327837L;
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int CUSTOM_DIALOG = 2;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    public static final String CANCEL_SELECTION = "CancelSelection";
    public static final String APPROVE_SELECTION = "ApproveSelection";
    public static final String APPROVE_BUTTON_TEXT_CHANGED_PROPERTY = "ApproveButtonTextChangedProperty";
    public static final String APPROVE_BUTTON_TOOL_TIP_TEXT_CHANGED_PROPERTY = "ApproveButtonToolTipTextChangedProperty";
    public static final String APPROVE_BUTTON_MNEMONIC_CHANGED_PROPERTY = "ApproveButtonMnemonicChangedProperty";
    public static final String CONTROL_BUTTONS_ARE_SHOWN_CHANGED_PROPERTY = "ControlButtonsAreShownChangedProperty";
    public static final String DIRECTORY_CHANGED_PROPERTY = "directoryChanged";
    public static final String SELECTED_FILE_CHANGED_PROPERTY = "SelectedFileChangedProperty";
    public static final String SELECTED_FILES_CHANGED_PROPERTY = "SelectedFilesChangedProperty";
    public static final String MULTI_SELECTION_ENABLED_CHANGED_PROPERTY = "MultiSelectionEnabledChangedProperty";
    public static final String FILE_SYSTEM_VIEW_CHANGED_PROPERTY = "FileSystemViewChanged";
    public static final String FILE_VIEW_CHANGED_PROPERTY = "fileViewChanged";
    public static final String FILE_HIDING_CHANGED_PROPERTY = "FileHidingChanged";
    public static final String FILE_FILTER_CHANGED_PROPERTY = "fileFilterChanged";
    public static final String FILE_SELECTION_MODE_CHANGED_PROPERTY = "fileSelectionChanged";
    public static final String ACCESSORY_CHANGED_PROPERTY = "AccessoryChangedProperty";
    public static final String ACCEPT_ALL_FILE_FILTER_USED_CHANGED_PROPERTY = "acceptAllFileFilterUsedChanged";
    public static final String DIALOG_TITLE_CHANGED_PROPERTY = "DialogTitleChangedProperty";
    public static final String DIALOG_TYPE_CHANGED_PROPERTY = "DialogTypeChangedProperty";
    public static final String CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY = "ChoosableFileFilterChangedProperty";
    protected AccessibleContext accessibleContext;
    private FileSystemView fsv;
    private JComponent accessory;
    private int approveButtonMnemonic = 0;
    private String approveButtonText;
    private String approveButtonToolTipText;
    private ArrayList choosableFilters = new ArrayList();
    private boolean isAcceptAll = true;
    private String dialogTitle;
    private int dialogType = 0;
    private int retval = -1;
    private boolean multiSelection = false;
    private boolean fileHiding = true;
    private int fileSelectionMode = 0;
    private FileView fv = null;
    private boolean controlButtonsShown = true;
    private File currentDir = null;
    private FileFilter currentFilter = null;
    private File[] selectedFiles;
    private File selectedFile;
    private boolean dragEnabled;

    public JFileChooser() {
        this.setup(null);
        this.setCurrentDirectory(null);
    }

    public JFileChooser(String currentDirectoryPath) {
        this(currentDirectoryPath, null);
    }

    public JFileChooser(String currentDirectoryPath, FileSystemView fsv) {
        this.setup(fsv);
        File dir = null;
        if (currentDirectoryPath != null) {
            dir = this.getFileSystemView().createFileObject(currentDirectoryPath);
        }
        this.setCurrentDirectory(dir);
    }

    public JFileChooser(File currentDirectory) {
        this.setup(null);
        this.setCurrentDirectory(currentDirectory);
    }

    public JFileChooser(FileSystemView fsv) {
        this.setup(fsv);
        this.setCurrentDirectory(null);
    }

    public JFileChooser(File currentDirectory, FileSystemView fsv) {
        this.setup(fsv);
        this.setCurrentDirectory(currentDirectory);
    }

    protected void setup(FileSystemView view) {
        if (view == null) {
            view = FileSystemView.getFileSystemView();
        }
        this.setFileSystemView(view);
        this.updateUI();
    }

    public void setDragEnabled(boolean b) {
        if (b && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = b;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public void setSelectedFile(File file) {
        if (this.selectedFile == null || !this.selectedFile.equals(file)) {
            File old = this.selectedFile;
            this.selectedFile = file;
            this.firePropertyChange(SELECTED_FILE_CHANGED_PROPERTY, old, this.selectedFile);
        }
    }

    public File[] getSelectedFiles() {
        if (this.selectedFiles != null) {
            return this.selectedFiles;
        }
        if (this.selectedFile != null) {
            return new File[]{this.selectedFile};
        }
        return new File[0];
    }

    public void setSelectedFiles(File[] selectedFiles) {
        if (selectedFiles == null) {
            selectedFiles = new File[]{};
        }
        if (selectedFiles.length > 0) {
            this.setSelectedFile(selectedFiles[0]);
        } else {
            this.setSelectedFile(null);
        }
        if (this.selectedFiles != selectedFiles) {
            File[] old = this.selectedFiles;
            this.selectedFiles = selectedFiles;
            this.firePropertyChange(SELECTED_FILES_CHANGED_PROPERTY, old, selectedFiles);
        }
    }

    public File getCurrentDirectory() {
        return this.currentDir;
    }

    public void setCurrentDirectory(File dir) {
        if (this.currentDir != dir || dir == null) {
            if (dir == null) {
                dir = this.fsv.getDefaultDirectory();
            }
            File old = this.currentDir;
            this.currentDir = dir;
            this.firePropertyChange(DIRECTORY_CHANGED_PROPERTY, old, this.currentDir);
        }
    }

    public void changeToParentDirectory() {
        this.setCurrentDirectory(this.fsv.getParentDirectory(this.currentDir));
    }

    public void rescanCurrentDirectory() {
        this.getUI().rescanCurrentDirectory(this);
    }

    public void ensureFileIsVisible(File f) {
        this.getUI().ensureFileIsVisible(this, f);
    }

    public int showOpenDialog(Component parent) throws HeadlessException {
        JDialog d = this.createDialog(parent);
        d.setTitle("Open");
        this.setDialogType(0);
        this.retval = -1;
        d.pack();
        d.show();
        return this.retval;
    }

    public int showSaveDialog(Component parent) throws HeadlessException {
        JDialog d = this.createDialog(parent);
        this.setDialogType(1);
        this.retval = -1;
        d.pack();
        d.show();
        return this.retval;
    }

    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        JDialog d = this.createDialog(parent);
        this.setApproveButtonText(approveButtonText);
        this.setDialogType(2);
        this.retval = -1;
        d.pack();
        d.show();
        return this.retval;
    }

    protected JDialog createDialog(Component parent) throws HeadlessException {
        Frame toUse = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        if (toUse == null) {
            toUse = (Frame)SwingUtilities.getOwnerFrame(null);
        }
        JDialog dialog = new JDialog(toUse);
        this.setSelectedFile(null);
        dialog.getContentPane().add(this);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JFileChooser.this.cancelSelection();
            }
        });
        dialog.setModal(true);
        dialog.invalidate();
        dialog.repaint();
        return dialog;
    }

    public boolean getControlButtonsAreShown() {
        return this.controlButtonsShown;
    }

    public void setControlButtonsAreShown(boolean b) {
        if (this.controlButtonsShown != b) {
            this.controlButtonsShown = b;
            this.firePropertyChange(CONTROL_BUTTONS_ARE_SHOWN_CHANGED_PROPERTY, !this.controlButtonsShown, this.controlButtonsShown);
        }
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(int dialogType) {
        if (dialogType != 0 && dialogType != 1 && dialogType != 2) {
            throw new IllegalArgumentException("Choose allowable dialogType.");
        }
        if (this.dialogType != dialogType) {
            int old = this.dialogType;
            this.dialogType = dialogType;
            this.firePropertyChange(DIALOG_TYPE_CHANGED_PROPERTY, old, this.dialogType);
        }
    }

    public void setDialogTitle(String dialogTitle) {
        if (this.dialogTitle != dialogTitle) {
            String old = this.dialogTitle;
            this.dialogTitle = dialogTitle;
            this.firePropertyChange(DIALOG_TITLE_CHANGED_PROPERTY, old, this.dialogTitle);
        }
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setApproveButtonToolTipText(String toolTipText) {
        if (this.approveButtonToolTipText != toolTipText) {
            String oldText = this.approveButtonToolTipText;
            this.approveButtonToolTipText = toolTipText;
            this.firePropertyChange(APPROVE_BUTTON_TOOL_TIP_TEXT_CHANGED_PROPERTY, oldText, this.approveButtonToolTipText);
        }
    }

    public String getApproveButtonToolTipText() {
        return this.approveButtonToolTipText;
    }

    public int getApproveButtonMnemonic() {
        return this.approveButtonMnemonic;
    }

    public void setApproveButtonMnemonic(int mnemonic) {
        if (this.approveButtonMnemonic != mnemonic) {
            int oldMnemonic = this.approveButtonMnemonic;
            this.approveButtonMnemonic = mnemonic;
            this.firePropertyChange(APPROVE_BUTTON_MNEMONIC_CHANGED_PROPERTY, oldMnemonic, this.approveButtonMnemonic);
        }
    }

    public void setApproveButtonMnemonic(char mnemonic) {
        this.setApproveButtonMnemonic((int)Character.toUpperCase(mnemonic));
    }

    public void setApproveButtonText(String approveButtonText) {
        if (this.approveButtonText != approveButtonText) {
            String oldText = this.approveButtonText;
            this.approveButtonText = approveButtonText;
            this.firePropertyChange(APPROVE_BUTTON_TEXT_CHANGED_PROPERTY, oldText, this.approveButtonText);
        }
    }

    public String getApproveButtonText() {
        return this.approveButtonText;
    }

    public FileFilter[] getChoosableFileFilters() {
        return this.choosableFilters.toArray(new FileFilter[this.choosableFilters.size()]);
    }

    public void addChoosableFileFilter(FileFilter filter) {
        if (filter != null) {
            FileFilter[] old = this.getChoosableFileFilters();
            this.choosableFilters.add(filter);
            FileFilter[] newFilters = this.getChoosableFileFilters();
            this.firePropertyChange(CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY, old, newFilters);
        }
        this.setFileFilter(filter);
    }

    public boolean removeChoosableFileFilter(FileFilter f) {
        if (f == this.currentFilter) {
            this.setFileFilter(null);
        }
        FileFilter[] old = this.getChoosableFileFilters();
        if (!this.choosableFilters.remove(f)) {
            return false;
        }
        FileFilter[] newFilters = this.getChoosableFileFilters();
        this.firePropertyChange(CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY, old, newFilters);
        return true;
    }

    public void resetChoosableFileFilters() {
        this.choosableFilters.clear();
        this.choosableFilters.add(this.getUI().getAcceptAllFileFilter(this));
        this.setFileFilter((FileFilter)this.choosableFilters.get(0));
    }

    public FileFilter getAcceptAllFileFilter() {
        return this.getUI().getAcceptAllFileFilter(this);
    }

    public boolean isAcceptAllFileFilterUsed() {
        return this.isAcceptAll;
    }

    public void setAcceptAllFileFilterUsed(boolean b) {
        if (this.isAcceptAll != b) {
            this.isAcceptAll = b;
            if (b) {
                this.addChoosableFileFilter(this.getAcceptAllFileFilter());
            } else {
                this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
            }
            this.firePropertyChange(ACCEPT_ALL_FILE_FILTER_USED_CHANGED_PROPERTY, !this.isAcceptAll, this.isAcceptAll);
        }
    }

    public JComponent getAccessory() {
        return this.accessory;
    }

    public void setAccessory(JComponent newAccessory) {
        if (this.accessory != newAccessory) {
            JComponent old = this.accessory;
            this.accessory = newAccessory;
            this.firePropertyChange(ACCESSORY_CHANGED_PROPERTY, old, this.accessory);
        }
    }

    public void setFileSelectionMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Choose a correct file selection mode.");
        }
        if (this.fileSelectionMode != mode) {
            int old = this.fileSelectionMode;
            this.fileSelectionMode = mode;
            this.firePropertyChange(FILE_SELECTION_MODE_CHANGED_PROPERTY, old, this.fileSelectionMode);
        }
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    public boolean isFileSelectionEnabled() {
        return this.fileSelectionMode == 0 || this.fileSelectionMode == 2;
    }

    public boolean isDirectorySelectionEnabled() {
        return this.fileSelectionMode == 1 || this.fileSelectionMode == 2;
    }

    public void setMultiSelectionEnabled(boolean b) {
        if (this.multiSelection != b) {
            this.multiSelection = b;
            this.firePropertyChange(MULTI_SELECTION_ENABLED_CHANGED_PROPERTY, !this.multiSelection, this.multiSelection);
        }
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelection;
    }

    public boolean isFileHidingEnabled() {
        return this.fileHiding;
    }

    public void setFileHidingEnabled(boolean b) {
        if (this.fileHiding != b) {
            this.fileHiding = b;
            this.firePropertyChange(FILE_HIDING_CHANGED_PROPERTY, !this.fileHiding, this.fileHiding);
        }
    }

    public void setFileFilter(FileFilter filter) {
        if (this.currentFilter != filter) {
            if (filter != null && !this.choosableFilters.contains(filter)) {
                this.addChoosableFileFilter(filter);
            }
            FileFilter old = this.currentFilter;
            this.currentFilter = filter;
            this.firePropertyChange(FILE_FILTER_CHANGED_PROPERTY, old, this.currentFilter);
        }
    }

    public FileFilter getFileFilter() {
        return this.currentFilter;
    }

    public void setFileView(FileView fileView) {
        if (this.fv != fileView) {
            FileView old = this.fv;
            this.fv = fileView;
            this.firePropertyChange(FILE_VIEW_CHANGED_PROPERTY, old, this.fv);
        }
    }

    public FileView getFileView() {
        return this.fv;
    }

    public String getName(File f) {
        String name = null;
        if (this.fv != null) {
            name = this.fv.getName(f);
        }
        if (name == null) {
            name = this.getUI().getFileView(this).getName(f);
        }
        return name;
    }

    public String getDescription(File f) {
        String result = null;
        if (this.fv != null) {
            result = this.fv.getDescription(f);
        }
        if (result == null) {
            result = this.getUI().getFileView(this).getDescription(f);
        }
        return result;
    }

    public String getTypeDescription(File f) {
        String result = null;
        if (this.fv != null) {
            result = this.getFileView().getTypeDescription(f);
        }
        if (result == null) {
            result = this.getUI().getFileView(this).getTypeDescription(f);
        }
        return result;
    }

    public Icon getIcon(File f) {
        Icon result = null;
        if (this.fv != null) {
            result = this.fv.getIcon(f);
        }
        if (result == null) {
            result = this.getUI().getFileView(this).getIcon(f);
        }
        return result;
    }

    public boolean isTraversable(File f) {
        return this.getFileSystemView().isTraversable(f);
    }

    public boolean accept(File f) {
        if (f == null) {
            return true;
        }
        FileFilter ff = this.getFileFilter();
        if (ff != null) {
            return ff.accept(f);
        }
        return true;
    }

    public void setFileSystemView(FileSystemView fsv) {
        if (this.fsv != fsv) {
            FileSystemView old = this.fsv;
            this.fsv = fsv;
            this.firePropertyChange(FILE_SYSTEM_VIEW_CHANGED_PROPERTY, old, this.fsv);
        }
    }

    public FileSystemView getFileSystemView() {
        return this.fsv;
    }

    public void approveSelection() {
        this.retval = 0;
        this.fireActionPerformed(APPROVE_SELECTION);
    }

    public void cancelSelection() {
        this.retval = 1;
        this.fireActionPerformed(CANCEL_SELECTION);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        try {
            this.listenerList.remove(ActionListener.class, l);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed(String command) {
        ActionListener[] list2 = this.getActionListeners();
        ActionEvent event = new ActionEvent(this, 1001, command);
        int i = 0;
        while (i < list2.length) {
            list2[i].actionPerformed(event);
            ++i;
        }
    }

    public void updateUI() {
        this.setUI((FileChooserUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "FileChooserUI";
    }

    public FileChooserUI getUI() {
        return (FileChooserUI)this.ui;
    }

    protected String paramString() {
        CPStringBuilder sb = new CPStringBuilder(super.paramString());
        sb.append(",approveButtonText=");
        if (this.approveButtonText != null) {
            sb.append(this.approveButtonText);
        }
        sb.append(",currentDirectory=");
        if (this.currentDir != null) {
            sb.append(this.currentDir);
        }
        sb.append(",dialogTitle=");
        if (this.dialogTitle != null) {
            sb.append(this.dialogTitle);
        }
        sb.append(",dialogType=");
        if (this.dialogType == 0) {
            sb.append("OPEN_DIALOG");
        }
        if (this.dialogType == 1) {
            sb.append("SAVE_DIALOG");
        }
        if (this.dialogType == 2) {
            sb.append("CUSTOM_DIALOG");
        }
        sb.append(",fileSelectionMode=");
        if (this.fileSelectionMode == 0) {
            sb.append("FILES_ONLY");
        }
        if (this.fileSelectionMode == 1) {
            sb.append("DIRECTORIES_ONLY");
        }
        if (this.fileSelectionMode == 2) {
            sb.append("FILES_AND_DIRECTORIES");
        }
        sb.append(",returnValue=");
        if (this.retval == 0) {
            sb.append("APPROVE_OPTION");
        }
        if (this.retval == 1) {
            sb.append("CANCEL_OPTION");
        }
        if (this.retval == -1) {
            sb.append("ERROR_OPTION");
        }
        sb.append(",selectedFile=");
        if (this.selectedFile != null) {
            sb.append(this.selectedFile);
        }
        sb.append(",useFileHiding=").append(this.fileHiding);
        return sb.toString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJFileChooser();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJFileChooser
    extends JComponent.AccessibleJComponent {
        protected AccessibleJFileChooser() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FILE_CHOOSER;
        }
    }
}

