/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class InflaterInputStream
extends FilterInputStream {
    protected Inflater inf;
    protected byte[] buf;
    protected int len;
    private byte[] onebytebuffer = new byte[1];

    public InflaterInputStream(InputStream in) {
        this(in, new Inflater(), 4096);
    }

    public InflaterInputStream(InputStream in, Inflater inf) {
        this(in, inf, 4096);
    }

    public InflaterInputStream(InputStream in, Inflater inf, int size) {
        super(in);
        if (in == null) {
            throw new NullPointerException("in may not be null");
        }
        if (inf == null) {
            throw new NullPointerException("inf may not be null");
        }
        if (size < 0) {
            throw new IllegalArgumentException("size may not be negative");
        }
        this.inf = inf;
        this.buf = new byte[size];
    }

    public int available() throws IOException {
        if (this.inf == null) {
            throw new IOException("stream closed");
        }
        return this.inf.finished() ? 0 : 1;
    }

    public synchronized void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = null;
    }

    protected void fill() throws IOException {
        if (this.in == null) {
            throw new ZipException("InflaterInputStream is closed");
        }
        this.len = this.in.read(this.buf, 0, this.buf.length);
        if (this.len < 0) {
            throw new ZipException("Deflated stream ends early.");
        }
        this.inf.setInput(this.buf, 0, this.len);
    }

    public int read() throws IOException {
        int nread = this.read(this.onebytebuffer, 0, 1);
        if (nread > 0) {
            return this.onebytebuffer[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.inf == null) {
            throw new IOException("stream closed");
        }
        if (len == 0) {
            return 0;
        }
        if (this.inf.finished()) {
            return -1;
        }
        int count = 0;
        while (count == 0) {
            block8: {
                if (this.inf.needsInput()) {
                    this.fill();
                }
                try {
                    count = this.inf.inflate(b, off, len);
                    if (count != 0) continue;
                    if (this.len != -1) break block8;
                    return -1;
                }
                catch (DataFormatException dfe) {
                    throw new ZipException(dfe.getMessage());
                }
            }
            if (!this.inf.needsDictionary()) continue;
            throw new ZipException("Inflater needs Dictionary");
        }
        return count;
    }

    public long skip(long n) throws IOException {
        if (this.inf == null) {
            throw new IOException("stream closed");
        }
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        if (n == 0L) {
            return 0L;
        }
        int buflen = (int)Math.min(n, 2048L);
        byte[] tmpbuf = new byte[buflen];
        long skipped = 0L;
        while (n > 0L) {
            int numread = this.read(tmpbuf, 0, buflen);
            if (numread <= 0) break;
            skipped += (long)numread;
            buflen = (int)Math.min(n -= (long)numread, 2048L);
        }
        return skipped;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readLimit) {
    }

    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }
}

