/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import gnu.java.beans.DefaultExceptionListener;
import gnu.java.beans.encoder.ArrayPersistenceDelegate;
import gnu.java.beans.encoder.ClassPersistenceDelegate;
import gnu.java.beans.encoder.CollectionPersistenceDelegate;
import gnu.java.beans.encoder.MapPersistenceDelegate;
import gnu.java.beans.encoder.PrimitivePersistenceDelegate;
import java.beans.DefaultPersistenceDelegate;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.Statement;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Encoder {
    private static PersistenceDelegate defaultPersistenceDelegate;
    private static PersistenceDelegate fakePersistenceDelegate;
    private static HashMap delegates;
    private IdentityHashMap candidates = new IdentityHashMap();
    private ExceptionListener exceptionListener;
    private int accessCounter = 0;

    static {
        delegates = new HashMap();
    }

    public Encoder() {
        Encoder.setupDefaultPersistenceDelegates();
        this.setExceptionListener(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupDefaultPersistenceDelegates() {
        HashMap hashMap = delegates;
        synchronized (hashMap) {
            if (defaultPersistenceDelegate != null) {
                return;
            }
            delegates.put(Class.class, new ClassPersistenceDelegate());
            PersistenceDelegate pd = new PrimitivePersistenceDelegate();
            delegates.put(Boolean.class, pd);
            delegates.put(Byte.class, pd);
            delegates.put(Short.class, pd);
            delegates.put(Integer.class, pd);
            delegates.put(Long.class, pd);
            delegates.put(Float.class, pd);
            delegates.put(Double.class, pd);
            delegates.put(Object[].class, new ArrayPersistenceDelegate());
            pd = new CollectionPersistenceDelegate();
            delegates.put(AbstractCollection.class, pd);
            pd = new MapPersistenceDelegate();
            delegates.put(AbstractMap.class, pd);
            delegates.put(Hashtable.class, pd);
            defaultPersistenceDelegate = new DefaultPersistenceDelegate();
            delegates.put(Object.class, defaultPersistenceDelegate);
            fakePersistenceDelegate = new PersistenceDelegate(){

                protected Expression instantiate(Object o, Encoder e) {
                    return null;
                }
            };
        }
    }

    protected void writeObject(Object o) {
        if (o == null) {
            return;
        }
        PersistenceDelegate pd = this.getPersistenceDelegate(o.getClass());
        ++this.accessCounter;
        pd.writeObject(o, this);
        --this.accessCounter;
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.exceptionListener = listener != null ? listener : DefaultExceptionListener.INSTANCE;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public PersistenceDelegate getPersistenceDelegate(Class<?> type) {
        if (type == null) {
            return fakePersistenceDelegate;
        }
        if (type.isArray()) {
            return (PersistenceDelegate)delegates.get(Object[].class);
        }
        PersistenceDelegate pd = (PersistenceDelegate)delegates.get(type);
        return pd != null ? pd : defaultPersistenceDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistenceDelegate(Class<?> type, PersistenceDelegate delegate) {
        if (type.isArray() || type.isPrimitive() || type == Boolean.class || type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class) {
            return;
        }
        HashMap hashMap = delegates;
        synchronized (hashMap) {
            delegates.put(type, delegate);
        }
    }

    public Object remove(Object oldInstance) {
        return this.candidates.remove(oldInstance);
    }

    public Object get(Object oldInstance) {
        return oldInstance == null ? null : (oldInstance.getClass() == String.class ? oldInstance : this.candidates.get(oldInstance));
    }

    public void writeStatement(Statement stmt) {
        if (this.accessCounter <= 0) {
            return;
        }
        Object target = stmt.getTarget();
        Object newTarget = this.get(target);
        if (newTarget == null) {
            this.writeObject(target);
            newTarget = this.get(target);
        }
        Object[] args = stmt.getArguments();
        Object[] newArgs = new Object[args.length];
        int i = 0;
        while (i < args.length) {
            newArgs[i] = this.get(args[i]);
            if (newArgs[i] == null || this.isImmutableType(args[i].getClass())) {
                this.writeObject(args[i]);
                newArgs[i] = this.get(args[i]);
            }
            ++i;
        }
        Statement newStmt = new Statement(newTarget, stmt.getMethodName(), newArgs);
        try {
            newStmt.execute();
        }
        catch (Exception e) {
            this.exceptionListener.exceptionThrown(e);
        }
    }

    public void writeExpression(Expression expr) {
        if (this.accessCounter <= 0) {
            return;
        }
        Object target = expr.getTarget();
        Object value = null;
        Object newValue = null;
        try {
            value = expr.getValue();
        }
        catch (Exception e) {
            this.exceptionListener.exceptionThrown(e);
            return;
        }
        newValue = this.get(value);
        if (newValue == null) {
            Object newTarget = this.get(target);
            if (newTarget == null) {
                this.writeObject(target);
                newTarget = this.get(target);
                if (newTarget == null) {
                    return;
                }
            }
            Object[] args = expr.getArguments();
            Object[] newArgs = new Object[args.length];
            int i = 0;
            while (i < args.length) {
                newArgs[i] = this.get(args[i]);
                if (newArgs[i] == null || this.isImmutableType(args[i].getClass())) {
                    this.writeObject(args[i]);
                    newArgs[i] = this.get(args[i]);
                }
                ++i;
            }
            Expression newExpr = new Expression(newTarget, expr.getMethodName(), newArgs);
            if (value instanceof Class && ((Class)value).isPrimitive()) {
                newExpr.setValue(value);
            }
            try {
                newValue = newExpr.getValue();
                this.candidates.put(value, newValue);
            }
            catch (Exception e) {
                this.exceptionListener.exceptionThrown(e);
                return;
            }
            this.writeObject(value);
        } else if (value.getClass() == String.class || value.getClass() == Class.class) {
            this.writeObject(value);
        }
    }

    boolean isImmutableType(Class type) {
        return type == String.class || type == Class.class || type == Integer.class || type == Boolean.class || type == Byte.class || type == Short.class || type == Long.class || type == Float.class || type == Double.class;
    }

    void putCandidate(Object oldObject, Object newObject) {
        this.candidates.put(oldObject, newObject);
    }
}

