/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public abstract class RoundRectangle2D
extends RectangularShape {
    public abstract double getArcHeight();

    public abstract double getArcWidth();

    public abstract void setRoundRect(double var1, double var3, double var5, double var7, double var9, double var11);

    protected RoundRectangle2D() {
    }

    public boolean contains(double x, double y) {
        double mx = this.getX();
        double mw = this.getWidth();
        if (x < mx || x >= mx + mw) {
            return false;
        }
        double my = this.getY();
        double mh = this.getHeight();
        if (y < my || y >= my + mh) {
            return false;
        }
        double dy = Math.min(Math.abs(my - y), Math.abs(my + mh - y));
        double dx = Math.min(Math.abs(mx - x), Math.abs(mx + mw - x));
        double aw = this.getArcWidth() / 2.0;
        double ah = this.getArcHeight() / 2.0;
        if (dx > aw || dy > ah) {
            return true;
        }
        return (dx = (aw - dx) / aw) * dx + (dy = (ah - dy) / ah) * dy <= 1.0;
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.contains(x, y) && this.contains(x, y + h) && this.contains(x + w, y + h) && this.contains(x + w, y);
    }

    public PathIterator getPathIterator(final AffineTransform at) {
        double arcW = Math.min(this.getArcWidth(), this.getWidth());
        double arcH = Math.min(this.getArcHeight(), this.getHeight());
        if (arcW <= 0.0 || arcH <= 0.0) {
            Rectangle2D.Double r = new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            return r.getPathIterator(at);
        }
        if (arcW >= this.getWidth() && arcH >= this.getHeight()) {
            Ellipse2D.Double e = new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            return e.getPathIterator(at);
        }
        return new PathIterator(){
            double x;
            double y;
            double w;
            double h;
            double arcW;
            double arcH;
            Arc2D.Double arc;
            PathIterator corner;
            int step;
            {
                this.x = RoundRectangle2D.this.getX();
                this.y = RoundRectangle2D.this.getY();
                this.w = RoundRectangle2D.this.getWidth();
                this.h = RoundRectangle2D.this.getHeight();
                this.arcW = Math.min(RoundRectangle2D.this.getArcWidth(), this.w);
                this.arcH = Math.min(RoundRectangle2D.this.getArcHeight(), this.h);
                this.arc = new Arc2D.Double();
                this.step = -1;
            }

            public int currentSegment(double[] coords) {
                if (this.corner != null) {
                    int r = this.corner.currentSegment(coords);
                    if (r == 0) {
                        r = 1;
                    }
                    return r;
                }
                if (this.step == -1) {
                    coords[0] = this.x + this.w - this.arcW / 2.0;
                    coords[1] = this.y;
                } else if (this.step == 0) {
                    coords[0] = this.x + this.arcW / 2.0;
                    coords[1] = this.y;
                } else if (this.step == 2) {
                    coords[0] = this.x;
                    coords[1] = this.y + this.h - this.arcH / 2.0;
                } else if (this.step == 4) {
                    coords[0] = this.x + this.w - this.arcW / 2.0;
                    coords[1] = this.y + this.h;
                } else if (this.step == 6) {
                    coords[0] = this.x + this.w;
                    coords[1] = this.y + this.arcH / 2.0;
                }
                if (at != null) {
                    at.transform(coords, 0, coords, 0, 1);
                }
                return this.step == -1 ? 0 : 1;
            }

            public int currentSegment(float[] coords) {
                if (this.corner != null) {
                    int r = this.corner.currentSegment(coords);
                    if (r == 0) {
                        r = 1;
                    }
                    return r;
                }
                if (this.step == -1) {
                    coords[0] = (float)(this.x + this.w - this.arcW / 2.0);
                    coords[1] = (float)this.y;
                } else if (this.step == 0) {
                    coords[0] = (float)(this.x + this.arcW / 2.0);
                    coords[1] = (float)this.y;
                } else if (this.step == 2) {
                    coords[0] = (float)this.x;
                    coords[1] = (float)(this.y + this.h - this.arcH / 2.0);
                } else if (this.step == 4) {
                    coords[0] = (float)(this.x + this.w - this.arcW / 2.0);
                    coords[1] = (float)(this.y + this.h);
                } else if (this.step == 6) {
                    coords[0] = (float)(this.x + this.w);
                    coords[1] = (float)(this.y + this.arcH / 2.0);
                }
                if (at != null) {
                    at.transform(coords, 0, coords, 0, 1);
                }
                return this.step == -1 ? 0 : 1;
            }

            public int getWindingRule() {
                return 1;
            }

            public boolean isDone() {
                return this.step >= 8;
            }

            public void next() {
                if (this.corner != null) {
                    this.corner.next();
                    if (this.corner.isDone()) {
                        this.corner = null;
                        ++this.step;
                    }
                } else {
                    ++this.step;
                    if (this.step == 1) {
                        this.arc.setArc(this.x, this.y, this.arcW, this.arcH, 90.0, 90.0, 0);
                        this.corner = this.arc.getPathIterator(at);
                    } else if (this.step == 3) {
                        this.arc.setArc(this.x, this.y + this.h - this.arcH, this.arcW, this.arcH, 180.0, 90.0, 0);
                        this.corner = this.arc.getPathIterator(at);
                    } else if (this.step == 5) {
                        this.arc.setArc(this.x + this.w - this.arcW, this.y + this.h - this.arcH, this.arcW, this.arcH, 270.0, 90.0, 0);
                        this.corner = this.arc.getPathIterator(at);
                    } else if (this.step == 7) {
                        this.arc.setArc(this.x + this.w - this.arcW, this.y, this.arcW, this.arcH, 0.0, 90.0, 0);
                        this.corner = this.arc.getPathIterator(at);
                    }
                }
            }
        };
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.contains(x, y) || this.contains(x, y + h) || this.contains(x + w, y + h) || this.contains(x + w, y);
    }

    public void setFrame(double x, double y, double w, double h) {
        this.setRoundRect(x, y, w, h, this.getArcWidth(), this.getArcHeight());
    }

    public void setRoundRect(RoundRectangle2D rr) {
        this.setRoundRect(rr.getX(), rr.getY(), rr.getWidth(), rr.getHeight(), rr.getArcWidth(), rr.getArcHeight());
    }

    public static class Double
    extends RoundRectangle2D {
        public double archeight;
        public double arcwidth;
        public double x;
        public double y;
        public double width;
        public double height;

        public Double() {
        }

        public Double(double x, double y, double w, double h, double arcWidth, double arcHeight) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.arcwidth = arcWidth;
            this.archeight = arcHeight;
        }

        public double getArcHeight() {
            return this.archeight;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.arcwidth = arcWidth;
            this.archeight = arcHeight;
        }
    }

    public static class Float
    extends RoundRectangle2D {
        public float archeight;
        public float arcwidth;
        public float x;
        public float y;
        public float width;
        public float height;

        public Float() {
        }

        public Float(float x, float y, float w, float h, float arcWidth, float arcHeight) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.arcwidth = arcWidth;
            this.archeight = arcHeight;
        }

        public double getArcHeight() {
            return this.archeight;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRoundRect(float x, float y, float w, float h, float arcWidth, float arcHeight) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.arcwidth = arcWidth;
            this.archeight = arcHeight;
        }

        public void setRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
            this.x = (float)x;
            this.y = (float)y;
            this.width = (float)w;
            this.height = (float)h;
            this.arcwidth = (float)arcWidth;
            this.archeight = (float)arcHeight;
        }
    }
}

