/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.NameTest;
import gnu.xml.xpath.Test;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public final class NamespaceTest
extends Test {
    final QName qName;
    final boolean anyLocalName;
    final boolean any;

    public NamespaceTest(QName qName, boolean anyLocalName, boolean any) {
        this.anyLocalName = anyLocalName;
        this.any = any;
        this.qName = qName;
    }

    public boolean matchesAny() {
        return this.any;
    }

    public boolean matchesAnyLocalName() {
        return this.anyLocalName;
    }

    public boolean matches(Node node2, int pos, int len) {
        String nodeUri;
        String uri;
        switch (node2.getNodeType()) {
            case 2: {
                uri = node2.getNamespaceURI();
                if ("http://www.w3.org/2000/xmlns/".equals(uri) || "xmlns".equals(node2.getPrefix()) || "xmlns".equals(node2.getNodeName())) break;
            }
            default: {
                return false;
            }
        }
        if (this.any) {
            return true;
        }
        uri = this.qName.getNamespaceURI();
        if (!NameTest.equal(uri, nodeUri = node2.getNamespaceURI())) {
            return false;
        }
        if (this.anyLocalName) {
            return true;
        }
        String localName = this.qName.getLocalPart();
        String nodeLocalName = NameTest.getLocalName(node2);
        return localName.equals(nodeLocalName);
    }

    public Test clone(Object context) {
        return new NamespaceTest(this.qName, this.anyLocalName, this.any);
    }

    public boolean references(QName var) {
        return false;
    }

    public String toString() {
        if (this.any) {
            return "*";
        }
        return this.qName.toString();
    }
}

