/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.util;

import gnu.java.lang.CPStringBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.helpers.XMLReaderFactory;

public class XCat
implements EntityResolver2 {
    private Catalog[] catalogs;
    private boolean usingPublic = true;
    private boolean loadingPermitted = true;
    private boolean unified = true;
    private String parserClass;
    private ErrorHandler errorHandler;
    private static final String catalogNamespace = "urn:oasis:names:tc:entity:xmlns:xml:catalog";

    public XCat() {
    }

    public XCat(String uri) throws SAXException, IOException {
        this.loadCatalog(uri);
    }

    public synchronized void loadCatalog(String uri) throws SAXException, IOException {
        int index = -1;
        if (!this.loadingPermitted) {
            throw new IllegalStateException();
        }
        uri = XCat.normalizeURI(uri);
        if (this.catalogs != null) {
            index = 0;
            while (index < this.catalogs.length) {
                if (uri.equals(this.catalogs[index].catalogURI)) break;
                ++index;
            }
        }
        Catalog catalog = XCat.loadCatalog(this.parserClass, this.errorHandler, uri, this.unified);
        if (this.catalogs == null) {
            index = 0;
            this.catalogs = new Catalog[1];
        } else if (index == this.catalogs.length) {
            Catalog[] tmp = new Catalog[index + 1];
            System.arraycopy(this.catalogs, 0, tmp, 0, index);
            this.catalogs = tmp;
        }
        this.catalogs[index] = catalog;
    }

    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        if (this.loadingPermitted) {
            this.disableLoading();
        }
        try {
            int i = 0;
            while (i < this.catalogs.length) {
                InputSource retval = this.catalogs[i].resolve(this.usingPublic, publicId, systemId);
                if (retval != null) {
                    return retval;
                }
                ++i;
            }
        }
        catch (DoneDelegation doneDelegation) {}
        return null;
    }

    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        if (this.loadingPermitted) {
            this.disableLoading();
        }
        try {
            int i = 0;
            while (i < this.catalogs.length) {
                InputSource retval = this.catalogs[i].getExternalSubset(name);
                if (retval != null) {
                    return retval;
                }
                ++i;
            }
        }
        catch (DoneDelegation doneDelegation) {}
        return null;
    }

    public final InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }

    public InputSource resolveURI(String baseURI, String uri) throws SAXException, IOException {
        if (this.loadingPermitted) {
            this.disableLoading();
        }
        try {
            int i = 0;
            while (i < this.catalogs.length) {
                InputSource tmp = this.catalogs[i].resolveURI(uri);
                if (tmp != null) {
                    return tmp;
                }
                ++i;
            }
        }
        catch (DoneDelegation doneDelegation) {}
        return null;
    }

    public synchronized void disableLoading() {
        this.loadingPermitted = false;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public String getParserClass() {
        return this.parserClass;
    }

    public void setParserClass(String parser) {
        this.parserClass = parser;
    }

    public boolean isUnified() {
        return this.unified;
    }

    public void setUnified(boolean value) {
        this.unified = value;
    }

    public boolean isUsingPublic() {
        return this.usingPublic;
    }

    public void setUsingPublic(boolean value) {
        this.usingPublic = value;
    }

    private static Catalog loadCatalog(String parserClass, ErrorHandler eh, String uri, boolean unified) throws SAXException, IOException {
        boolean doesIntern = false;
        XMLReader parser = parserClass == null ? XMLReaderFactory.createXMLReader() : XMLReaderFactory.createXMLReader(parserClass);
        if (eh != null) {
            parser.setErrorHandler(eh);
        }
        try {
            doesIntern = parser.getFeature("http://xml.org/sax/features/string-interning");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {}
        Loader loader = new Loader(doesIntern, eh, unified);
        loader.cat.parserClass = parserClass;
        loader.cat.catalogURI = uri;
        parser.setContentHandler(loader);
        parser.setProperty("http://xml.org/sax/properties/declaration-handler", loader);
        parser.setProperty("http://xml.org/sax/properties/lexical-handler", loader);
        parser.parse(uri);
        return loader.cat;
    }

    private static String normalizePublicId(boolean full, String publicId) {
        if (publicId.startsWith("urn:publicid:")) {
            CPStringBuilder buf = new CPStringBuilder();
            char[] chars = publicId.toCharArray();
            boolean hasbug = false;
            int i = 13;
            while (i < chars.length) {
                switch (chars[i]) {
                    case '+': {
                        buf.append(' ');
                        break;
                    }
                    case ':': {
                        buf.append("//");
                        break;
                    }
                    case ';': {
                        buf.append("::");
                        break;
                    }
                    case '%': {
                        hasbug = true;
                    }
                    default: {
                        buf.append(chars[i]);
                    }
                }
                ++i;
            }
            publicId = buf.toString();
            if (hasbug) {
                System.err.println("nyet unhexing public id: " + publicId);
            }
            full = true;
        }
        if (full) {
            StringTokenizer tokens = new StringTokenizer(publicId, " \r\n");
            publicId = null;
            while (tokens.hasMoreTokens()) {
                publicId = publicId == null ? tokens.nextToken() : String.valueOf(publicId) + " " + tokens.nextToken();
            }
        }
        return publicId;
    }

    private static boolean isUriExcluded(int c) {
        return c <= 32 || c >= 127 || "\"<>^`{|}".indexOf(c) != -1;
    }

    private static int hexNibble(int c) {
        if (c < 10) {
            return c + 48;
        }
        return 87 + c;
    }

    private static String normalizeURI(String systemId) {
        int length = systemId.length();
        int i = 0;
        while (i < length) {
            char c = systemId.charAt(i);
            if (XCat.isUriExcluded(c)) {
                try {
                    byte[] buf = systemId.getBytes("UTF8");
                    ByteArrayOutputStream out = new ByteArrayOutputStream(buf.length + 10);
                    i = 0;
                    while (i < buf.length) {
                        int b = buf[i] & 0xFF;
                        if (XCat.isUriExcluded(b)) {
                            out.write(37);
                            out.write(XCat.hexNibble(b >> 4));
                            out.write(XCat.hexNibble(b & 0xF));
                        } else {
                            out.write(b);
                        }
                        ++i;
                    }
                    return out.toString("8859_1");
                }
                catch (IOException e) {
                    throw new RuntimeException("can't normalize URI: " + e.getMessage());
                }
            }
            ++i;
        }
        return systemId;
    }

    private static class Catalog {
        String catalogURI;
        ErrorHandler eh;
        boolean unified;
        String parserClass;
        boolean hasPreference;
        boolean usingPublic;
        Hashtable publicIds;
        Hashtable publicDelegations;
        Hashtable systemIds;
        Hashtable systemRewrites;
        Hashtable systemDelegations;
        Hashtable uris;
        Hashtable uriRewrites;
        Hashtable uriDelegations;
        Hashtable doctypes;
        Vector next;

        Catalog() {
        }

        private InputSource locatePublicId(String publicId) throws SAXException, IOException {
            String retval;
            if (this.publicIds != null && (retval = (String)this.publicIds.get(publicId)) != null) {
                return new InputSource(retval);
            }
            if (this.publicDelegations != null) {
                return this.checkDelegations(this.publicDelegations, publicId, publicId, null);
            }
            return null;
        }

        private InputSource mapURI(String uri, Hashtable ids, Hashtable rewrites, Hashtable delegations) throws SAXException, IOException {
            String retval;
            if (ids != null && (retval = (String)ids.get(uri)) != null) {
                return new InputSource(retval);
            }
            if (rewrites != null) {
                String prefix = null;
                String replace = null;
                int prefixLen = -1;
                Enumeration e = rewrites.keys();
                while (e.hasMoreElements()) {
                    String temp = (String)e.nextElement();
                    int len = -1;
                    if (!uri.startsWith(temp) || prefix != null && (len = temp.length()) < prefixLen) continue;
                    prefix = temp;
                    prefixLen = len;
                    replace = (String)rewrites.get(temp);
                }
                if (prefix != null) {
                    CPStringBuilder buf = new CPStringBuilder(replace);
                    buf.append(uri.substring(prefixLen));
                    return new InputSource(buf.toString());
                }
            }
            if (delegations != null) {
                return this.checkDelegations(delegations, uri, null, uri);
            }
            return null;
        }

        public InputSource resolve(boolean usingPublic, String publicId, String systemId) throws SAXException, IOException {
            InputSource retval;
            boolean preferSystem;
            if (this.hasPreference) {
                preferSystem = !this.usingPublic;
            } else {
                boolean bl = preferSystem = !usingPublic;
            }
            if (publicId != null) {
                publicId = XCat.normalizePublicId(false, publicId);
            }
            if (systemId != null) {
                if (systemId.startsWith("urn:publicid:")) {
                    String temp = XCat.normalizePublicId(true, systemId);
                    if (publicId == null) {
                        publicId = temp;
                        systemId = null;
                    } else if (!publicId.equals(temp)) {
                        systemId = null;
                    }
                } else {
                    systemId = XCat.normalizeURI(systemId);
                }
            }
            if (systemId == null && publicId == null) {
                return null;
            }
            if (systemId != null && (retval = this.mapURI(systemId, this.systemIds, this.systemRewrites, this.systemDelegations)) != null) {
                retval.setPublicId(publicId);
                return retval;
            }
            if (!(publicId == null || systemId != null && preferSystem || (retval = this.locatePublicId(publicId)) == null)) {
                retval.setPublicId(publicId);
                return retval;
            }
            if (this.next != null) {
                int length = this.next.size();
                int i = 0;
                while (i < length) {
                    Catalog n = this.getNext(i);
                    retval = n.resolve(usingPublic, publicId, systemId);
                    if (retval != null) {
                        return retval;
                    }
                    ++i;
                }
            }
            return null;
        }

        public InputSource resolveURI(String uri) throws SAXException, IOException {
            if (uri.startsWith("urn:publicid:")) {
                return this.resolve(true, XCat.normalizePublicId(true, uri), null);
            }
            InputSource retval = this.mapURI(uri = XCat.normalizeURI(uri), this.uris, this.uriRewrites, this.uriDelegations);
            if (retval != null) {
                return retval;
            }
            if (this.next != null) {
                int length = this.next.size();
                int i = 0;
                while (i < length) {
                    Catalog n = this.getNext(i);
                    retval = n.resolveURI(uri);
                    if (retval != null) {
                        return retval;
                    }
                    ++i;
                }
            }
            return null;
        }

        public InputSource getExternalSubset(String name) throws SAXException, IOException {
            String value;
            if (this.doctypes != null && (value = (String)this.doctypes.get(name)) != null) {
                return new InputSource(value);
            }
            if (this.next != null) {
                int length = this.next.size();
                int i = 0;
                while (i < length) {
                    InputSource retval;
                    Catalog n = this.getNext(i);
                    if (n != null && (retval = n.getExternalSubset(name)) != null) {
                        return retval;
                    }
                    ++i;
                }
            }
            return null;
        }

        private synchronized Catalog getNext(int i) throws SAXException, IOException {
            if (this.next == null || i < 0 || i >= this.next.size()) {
                return null;
            }
            Object obj = this.next.elementAt(i);
            if (obj instanceof Catalog) {
                return (Catalog)obj;
            }
            Catalog cat = null;
            try {
                cat = XCat.loadCatalog(this.parserClass, this.eh, (String)obj, this.unified);
                this.next.setElementAt(cat, i);
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {}
            return cat;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InputSource checkDelegations(Hashtable delegations, String id, String publicId, String systemId) throws SAXException, IOException {
            Vector<String> matches = null;
            int length = 0;
            Enumeration e = delegations.keys();
            while (e.hasMoreElements()) {
                String prefix = (String)e.nextElement();
                if (!id.startsWith(prefix)) continue;
                if (matches == null) {
                    matches = new Vector<String>();
                }
                int index = 0;
                while (index < length) {
                    String temp = (String)matches.elementAt(index);
                    if (prefix.length() > temp.length()) {
                        matches.insertElementAt(prefix, index);
                        break;
                    }
                    ++index;
                }
                if (index == length) {
                    matches.addElement(prefix);
                }
                ++length;
            }
            if (matches == null) {
                return null;
            }
            int i = 0;
            while (i < length) {
                InputSource result;
                Catalog catalog = null;
                Hashtable hashtable = delegations;
                synchronized (hashtable) {
                    Object prefix = matches.elementAt(i);
                    Object cat = delegations.get(prefix);
                    if (cat instanceof Catalog) {
                        catalog = (Catalog)cat;
                    } else {
                        try {
                            catalog = XCat.loadCatalog(this.parserClass, this.eh, (String)cat, this.unified);
                            delegations.put(prefix, catalog);
                        }
                        catch (SAXException sAXException) {
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (catalog != null && (result = catalog.resolve(true, publicId, systemId)) != null) {
                    return result;
                }
                ++i;
            }
            throw new DoneDelegation();
        }
    }

    private static class DoneDelegation
    extends SAXException {
        DoneDelegation() {
        }
    }

    private static class Loader
    extends DefaultHandler2 {
        private boolean preInterned;
        private ErrorHandler handler;
        private boolean unified;
        private int ignoreDepth;
        private Locator locator;
        private boolean started;
        private Hashtable externals;
        private Stack bases;
        Catalog cat = new Catalog();

        Loader(boolean flag, ErrorHandler eh, boolean unified) {
            this.preInterned = flag;
            this.handler = eh;
            this.unified = unified;
            this.cat.unified = unified;
            this.cat.eh = eh;
        }

        private String nofrag(String uri) throws SAXException {
            if (uri.indexOf(35) != -1) {
                this.warn("URI with fragment: " + uri);
                uri = uri.substring(0, uri.indexOf(35));
            }
            return uri;
        }

        private String absolutize(String uri) throws SAXException {
            if (uri.startsWith("file:/") || uri.startsWith("http:/") || uri.startsWith("https:/") || uri.startsWith("ftp:/") || uri.startsWith("urn:")) {
                return uri;
            }
            try {
                URL base = (URL)this.bases.peek();
                return new URL(base, uri).toString();
            }
            catch (Exception exception) {
                this.fatal("can't absolutize URI: " + uri);
                return null;
            }
        }

        private void error(String message) throws SAXException {
            if (this.handler == null) {
                return;
            }
            this.handler.error(new SAXParseException(message, this.locator));
        }

        private void fatal(String message) throws SAXException {
            SAXParseException spe = new SAXParseException(message, this.locator);
            if (this.handler != null) {
                this.handler.fatalError(spe);
            }
            throw spe;
        }

        private void warn(String message) throws SAXException {
            if (this.handler == null) {
                return;
            }
            this.handler.warning(new SAXParseException(message, this.locator));
        }

        public void setDocumentLocator(Locator l) {
            this.locator = l;
        }

        public void startDocument() throws SAXException {
            if (this.locator == null) {
                this.error("no locator!");
            }
            this.bases = new Stack();
            String uri = this.locator.getSystemId();
            try {
                this.bases.push(new URL(uri));
            }
            catch (IOException iOException) {
                this.fatal("bad document base URI: " + uri);
            }
        }

        public void endDocument() throws SAXException {
            try {
                if (!this.started) {
                    this.error("not a catalog!");
                }
            }
            finally {
                this.locator = null;
                this.handler = null;
                this.externals = null;
                this.bases = null;
            }
        }

        public void externalEntityDecl(String name, String pub, String sys) throws SAXException {
            if (this.externals == null) {
                this.externals = new Hashtable();
            }
            if (this.externals.get(name) == null) {
                this.externals.put(name, pub);
            }
        }

        public void startEntity(String name) throws SAXException {
            if (this.externals == null) {
                return;
            }
            String uri = (String)this.externals.get(name);
            if (uri != null) {
                try {
                    this.bases.push(new URL(uri));
                }
                catch (IOException iOException) {
                    this.fatal("entity '" + name + "', bad URI: " + uri);
                }
            }
        }

        public void endEntity(String name) {
            if (this.externals == null) {
                return;
            }
            String value = (String)this.externals.get(name);
            if (value != null) {
                this.bases.pop();
            }
        }

        public void startElement(String namespace, String local, String qName, Attributes atts) throws SAXException {
            String uriStartString;
            String systemIdStartString;
            String rewritePrefix;
            String xmlbase;
            if (this.ignoreDepth != 0 || !XCat.catalogNamespace.equals(namespace)) {
                ++this.ignoreDepth;
                return;
            }
            if (!this.preInterned) {
                local = local.intern();
            }
            if (!this.started) {
                this.started = true;
                if ("catalog" != local) {
                    this.fatal("root element not 'catalog': " + local);
                }
            }
            if ((xmlbase = atts.getValue("xml:base")) != null) {
                URL base = (URL)this.bases.peek();
                try {
                    base = new URL(base, xmlbase);
                }
                catch (IOException iOException) {
                    this.fatal("can't resolve xml:base attribute: " + xmlbase);
                }
                this.bases.push(base);
            } else {
                this.bases.push(this.bases.peek());
            }
            String catalog = atts.getValue("catalog");
            if (catalog != null) {
                catalog = XCat.normalizeURI(this.absolutize(catalog));
            }
            if ((rewritePrefix = atts.getValue("rewritePrefix")) != null) {
                rewritePrefix = XCat.normalizeURI(this.absolutize(rewritePrefix));
            }
            if ((systemIdStartString = atts.getValue("systemIdStartString")) != null && (systemIdStartString = XCat.normalizeURI(systemIdStartString)).startsWith("urn:publicid:")) {
                this.error("systemIdStartString is really a publicId!!");
                return;
            }
            String uri = atts.getValue("uri");
            if (uri != null) {
                uri = XCat.normalizeURI(this.absolutize(uri));
            }
            if ((uriStartString = atts.getValue("uriStartString")) != null && (uriStartString = XCat.normalizeURI(uriStartString)).startsWith("urn:publicid:")) {
                this.error("uriStartString is really a publicId!!");
                return;
            }
            if ("catalog" == local || "group" == local) {
                String prefer = atts.getValue("prefer");
                if (prefer != null && !"public".equals(prefer) && !"system".equals(prefer)) {
                    this.error("in <" + local + " ... prefer='...'>, " + "assuming 'public'");
                    prefer = "public";
                }
                if (prefer != null) {
                    if ("catalog" == local) {
                        this.cat.hasPreference = true;
                        this.cat.usingPublic = "public".equals(prefer);
                    } else if (!this.cat.hasPreference || this.cat.usingPublic != "public".equals(prefer)) {
                        this.fatal("<group prefer=...> case not handled");
                    }
                } else if ("group" == local && this.cat.hasPreference) {
                    this.fatal("<group prefer=...> case not handled");
                }
            } else if ("public" == local) {
                String publicId = atts.getValue("publicId");
                String value = null;
                if (publicId == null || uri == null) {
                    this.error("expecting <public publicId=... uri=.../>");
                    return;
                }
                publicId = XCat.normalizePublicId(true, publicId);
                uri = this.nofrag(uri);
                if (this.cat.publicIds == null) {
                    this.cat.publicIds = new Hashtable();
                } else {
                    value = (String)this.cat.publicIds.get(publicId);
                }
                if (value != null) {
                    if (!value.equals(uri)) {
                        this.warn("ignoring <public...> entry for " + publicId);
                    }
                } else {
                    this.cat.publicIds.put(publicId, uri);
                }
            } else if ("delegatePublic" == local) {
                Object value = null;
                String publicIdStartString = atts.getValue("publicIdStartString");
                if (publicIdStartString == null || catalog == null) {
                    this.error("expecting <delegatePublic publicIdStartString=... catalog=.../>");
                    return;
                }
                publicIdStartString = XCat.normalizePublicId(true, publicIdStartString);
                if (this.cat.publicDelegations == null) {
                    this.cat.publicDelegations = new Hashtable();
                } else {
                    value = this.cat.publicDelegations.get(publicIdStartString);
                }
                if (value != null) {
                    if (!value.equals(catalog)) {
                        this.warn("ignoring <delegatePublic...> entry for " + uriStartString);
                    }
                } else {
                    this.cat.publicDelegations.put(publicIdStartString, catalog);
                }
            } else if ("system" == local) {
                String systemId = atts.getValue("systemId");
                String value = null;
                if (systemId == null || uri == null) {
                    this.error("expecting <system systemId=... uri=.../>");
                    return;
                }
                systemId = XCat.normalizeURI(systemId);
                uri = this.nofrag(uri);
                if (systemId.startsWith("urn:publicid:")) {
                    this.error("systemId is really a publicId!!");
                    return;
                }
                if (this.cat.systemIds == null) {
                    this.cat.systemIds = new Hashtable();
                    if (this.unified) {
                        this.cat.uris = this.cat.systemIds;
                    }
                } else {
                    value = (String)this.cat.systemIds.get(systemId);
                }
                if (value != null) {
                    if (!value.equals(uri)) {
                        this.warn("ignoring <system...> entry for " + systemId);
                    }
                } else {
                    this.cat.systemIds.put(systemId, uri);
                }
            } else if ("rewriteSystem" == local) {
                String value = null;
                if (systemIdStartString == null || rewritePrefix == null || systemIdStartString.length() == 0 || rewritePrefix.length() == 0) {
                    this.error("expecting <rewriteSystem systemIdStartString=... rewritePrefix=.../>");
                    return;
                }
                if (this.cat.systemRewrites == null) {
                    this.cat.systemRewrites = new Hashtable();
                    if (this.unified) {
                        this.cat.uriRewrites = this.cat.systemRewrites;
                    }
                } else {
                    value = (String)this.cat.systemRewrites.get(systemIdStartString);
                }
                if (value != null) {
                    if (!value.equals(rewritePrefix)) {
                        this.warn("ignoring <rewriteSystem...> entry for " + systemIdStartString);
                    }
                } else {
                    this.cat.systemRewrites.put(systemIdStartString, rewritePrefix);
                }
            } else if ("delegateSystem" == local) {
                Object value = null;
                if (systemIdStartString == null || catalog == null) {
                    this.error("expecting <delegateSystem systemIdStartString=... catalog=.../>");
                    return;
                }
                if (this.cat.systemDelegations == null) {
                    this.cat.systemDelegations = new Hashtable();
                    if (this.unified) {
                        this.cat.uriDelegations = this.cat.systemDelegations;
                    }
                } else {
                    value = this.cat.systemDelegations.get(systemIdStartString);
                }
                if (value != null) {
                    if (!value.equals(catalog)) {
                        this.warn("ignoring <delegateSystem...> entry for " + uriStartString);
                    }
                } else {
                    this.cat.systemDelegations.put(systemIdStartString, catalog);
                }
            } else if ("uri" == local) {
                String name = atts.getValue("name");
                String value = null;
                if (name == null || uri == null) {
                    this.error("expecting <uri name=... uri=.../>");
                    return;
                }
                if (name.startsWith("urn:publicid:")) {
                    this.error("name is really a publicId!!");
                    return;
                }
                name = XCat.normalizeURI(name);
                if (this.cat.uris == null) {
                    this.cat.uris = new Hashtable();
                    if (this.unified) {
                        this.cat.systemIds = this.cat.uris;
                    }
                } else {
                    value = (String)this.cat.uris.get(name);
                }
                if (value != null) {
                    if (!value.equals(uri)) {
                        this.warn("ignoring <uri...> entry for " + name);
                    }
                } else {
                    this.cat.uris.put(name, uri);
                }
            } else if ("rewriteURI" == local) {
                String value = null;
                if (uriStartString == null || rewritePrefix == null || uriStartString.length() == 0 || rewritePrefix.length() == 0) {
                    this.error("expecting <rewriteURI uriStartString=... rewritePrefix=.../>");
                    return;
                }
                if (this.cat.uriRewrites == null) {
                    this.cat.uriRewrites = new Hashtable();
                    if (this.unified) {
                        this.cat.systemRewrites = this.cat.uriRewrites;
                    }
                } else {
                    value = (String)this.cat.uriRewrites.get(uriStartString);
                }
                if (value != null) {
                    if (!value.equals(rewritePrefix)) {
                        this.warn("ignoring <rewriteURI...> entry for " + uriStartString);
                    }
                } else {
                    this.cat.uriRewrites.put(uriStartString, rewritePrefix);
                }
            } else if ("delegateURI" == local) {
                Object value = null;
                if (uriStartString == null || catalog == null) {
                    this.error("expecting <delegateURI uriStartString=... catalog=.../>");
                    return;
                }
                if (this.cat.uriDelegations == null) {
                    this.cat.uriDelegations = new Hashtable();
                    if (this.unified) {
                        this.cat.systemDelegations = this.cat.uriDelegations;
                    }
                } else {
                    value = this.cat.uriDelegations.get(uriStartString);
                }
                if (value != null) {
                    if (!value.equals(catalog)) {
                        this.warn("ignoring <delegateURI...> entry for " + uriStartString);
                    }
                } else {
                    this.cat.uriDelegations.put(uriStartString, catalog);
                }
            } else if ("nextCatalog" == local) {
                if (catalog == null) {
                    this.error("expecting <nextCatalog catalog=.../>");
                    return;
                }
                if (this.cat.next == null) {
                    this.cat.next = new Vector();
                }
                this.cat.next.addElement(catalog);
            } else if ("doctype" == local) {
                String name = atts.getValue("name");
                String value = null;
                if (name == null || uri == null) {
                    this.error("expecting <doctype name=... uri=.../>");
                    return;
                }
                name = XCat.normalizeURI(name);
                if (this.cat.doctypes == null) {
                    this.cat.doctypes = new Hashtable();
                } else {
                    value = (String)this.cat.doctypes.get(name);
                }
                if (value != null) {
                    if (!value.equals(uri)) {
                        this.warn("ignoring <doctype...> entry for " + uriStartString);
                    }
                } else {
                    this.cat.doctypes.put(name, uri);
                }
            } else {
                this.warn("ignoring unknown catalog element: " + local);
                ++this.ignoreDepth;
            }
        }

        public void endElement(String uri, String local, String qName) throws SAXException {
            if (this.ignoreDepth != 0) {
                --this.ignoreDepth;
            } else {
                this.bases.pop();
            }
        }
    }
}

